/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SubtransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;
import org.pentaho.di.trans.streaming.api.StreamSource;
import org.pentaho.di.trans.streaming.api.StreamWindow;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;

public class BaseStreamStep
extends BaseStep {
    private static final Class<?> PKG = BaseStreamStep.class;
    private BaseStreamStepMeta stepMeta;
    protected SubtransExecutor subtransExecutor;
    protected StreamWindow<List<Object>, Result> window;
    protected StreamSource<List<Object>> source;

    public BaseStreamStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean errorsPresent;
        Preconditions.checkNotNull((Object)stepMetaInterface);
        this.stepMeta = (BaseStreamStepMeta)stepMetaInterface;
        this.stepMeta.setParentStepMeta(this.getStepMeta());
        this.stepMeta.setFileName(this.stepMeta.getTransformationPath());
        boolean superInit = super.init(stepMetaInterface, stepDataInterface);
        try {
            TransMeta transMeta = TransExecutorMeta.loadMappingMeta(this.stepMeta, this.getTransMeta().getRepository(), this.getTransMeta().getMetaStore(), this.getParentVariableSpace());
            this.subtransExecutor = new SubtransExecutor(this.getStepname(), this.getTrans(), transMeta, true, new TransExecutorParameters(), this.environmentSubstitute(this.stepMeta.getSubStep()));
        }
        catch (KettleException e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        this.stepMeta.check(remarks, this.getTransMeta(), this.stepMeta.getParentStepMeta(), null, null, null, null, this.variables, this.getRepository(), this.getMetaStore());
        boolean bl = errorsPresent = remarks.stream().filter(result -> result.getType() == 4).peek(result -> this.logError(result.getText())).count() > 0L;
        if (errorsPresent) {
            return false;
        }
        return superInit;
    }

    @Override
    public void setOutputDone() {
        if (!this.safeStopped.get()) {
            super.setOutputDone();
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Preconditions.checkArgument((boolean)this.first, (Object)BaseMessages.getString(PKG, (String)"BaseStreamStep.ProcessRowsError", (String[])new String[0]));
        Preconditions.checkNotNull(this.source);
        Preconditions.checkNotNull(this.window);
        this.source.open();
        this.bufferStream().forEach(result -> {
            if (result.isSafeStop()) {
                this.getTrans().safeStop();
            }
            this.putRows(result.getRows());
        });
        super.setOutputDone();
        this.source.close();
        return false;
    }

    private Iterable<Result> bufferStream() {
        return this.window.buffer(this.source.observable());
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (!this.safeStopped.get()) {
            this.subtransExecutor.stop();
        }
        if (this.source != null) {
            this.source.close();
        }
        super.stopRunning(stepMetaInterface, stepDataInterface);
    }

    @Override
    public void resumeRunning() {
        if (this.source != null) {
            this.source.resume();
        }
        super.resumeRunning();
    }

    @Override
    public void pauseRunning() {
        if (this.source != null) {
            this.source.pause();
        }
        super.pauseRunning();
    }

    private void putRows(List<RowMetaAndData> rows) {
        if (this.isStopped() && !this.safeStopped.get()) {
            return;
        }
        rows.forEach(row -> {
            try {
                this.putRow(row.getRowMeta(), row.getData());
            }
            catch (KettleStepException e) {
                Throwables.propagate((Throwable)e);
            }
        });
    }

    protected int getBatchSize() {
        try {
            return Integer.parseInt(this.stepMeta.getBatchSize());
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    protected long getDuration() {
        try {
            return Long.parseLong(this.stepMeta.getBatchDuration());
        }
        catch (NumberFormatException nfe) {
            return 5000L;
        }
    }

    @Override
    public Collection<StepStatus> subStatuses() {
        return this.subtransExecutor != null ? this.subtransExecutor.getStatuses().values() : Collections.emptyList();
    }

    @VisibleForTesting
    public StreamSource<List<Object>> getSource() {
        return this.source;
    }

    @VisibleForTesting
    public void setSource(StreamSource<List<Object>> source) {
        this.source = source;
    }
}

