/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.SubtransExecutor;
import org.pentaho.di.trans.streaming.api.StreamWindow;

public class FixedTimeStreamWindow<I extends List>
implements StreamWindow<I, Result> {
    private final RowMetaInterface rowMeta;
    private final long millis;
    private final int batchSize;
    private SubtransExecutor subtransExecutor;

    public FixedTimeStreamWindow(SubtransExecutor subtransExecutor, RowMetaInterface rowMeta, long millis, int batchSize) {
        this.subtransExecutor = subtransExecutor;
        this.rowMeta = rowMeta;
        this.millis = millis;
        this.batchSize = batchSize;
    }

    @Override
    public Iterable<Result> buffer(Observable<I> observable) {
        Observable buffer = this.millis > 0L ? (this.batchSize > 0 ? observable.buffer(this.millis, TimeUnit.MILLISECONDS, this.batchSize) : observable.buffer(this.millis, TimeUnit.MILLISECONDS)) : observable.buffer(this.batchSize);
        return buffer.observeOn(Schedulers.io()).filter(list -> !list.isEmpty()).map(this::sendBufferToSubtrans).takeWhile(result -> result.getNrErrors() == 0L).blockingIterable();
    }

    private Result sendBufferToSubtrans(List<I> input) throws KettleException {
        List<RowMetaAndData> rows = input.stream().map(row -> row.toArray(new Object[0])).map(objects -> new RowMetaAndData(this.rowMeta, objects)).collect(Collectors.toList());
        Optional<Result> optionalRes = this.subtransExecutor.execute(rows);
        return optionalRes.orElse(new Result());
    }
}

