/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.boundedint;

import java.io.IOException;
import parquet.Log;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.boundedint.BitReader;
import parquet.io.ParquetDecodingException;

class BoundedIntValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BoundedIntValuesReader.class);
    private int currentValueCt = 0;
    private int currentValue = 0;
    private final int bitsPerValue;
    private BitReader bitReader = new BitReader();
    private int nextOffset;

    public BoundedIntValuesReader(int bound) {
        if (bound == 0) {
            throw new ParquetDecodingException("Value bound cannot be 0. Use DevNullColumnReader instead.");
        }
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
    }

    @Override
    public int readInteger() {
        try {
            if (this.currentValueCt > 0) {
                --this.currentValueCt;
                return this.currentValue;
            }
            if (this.bitReader.readBit()) {
                this.currentValue = this.bitReader.readNBitInteger(this.bitsPerValue);
                this.currentValueCt = this.bitReader.readUnsignedVarint() - 1;
            } else {
                this.currentValue = this.bitReader.readNBitInteger(this.bitsPerValue);
            }
            return this.currentValue;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read int", e);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("reading size at " + offset + ": " + in[offset] + " " + in[offset + 1] + " " + in[offset + 2] + " " + in[offset + 3] + " ");
        }
        int totalBytes = BytesUtils.readIntLittleEndian(in, offset);
        if (Log.DEBUG) {
            LOG.debug("will read " + totalBytes + " bytes");
        }
        this.currentValueCt = 0;
        this.currentValue = 0;
        this.bitReader.prepare(in, offset + 4, totalBytes);
        if (Log.DEBUG) {
            LOG.debug("will read next from " + (offset + totalBytes + 4));
        }
        this.nextOffset = offset + totalBytes + 4;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

