/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.Olap4jUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.util.MemberAddingStrategy;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.util.ResultSetOrderMemberAddingStrategy;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.util.SortedMemberAddingStrategy;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class ResultSetProcessingLib {
    private static final Log logger = LogFactory.getLog(ResultSetProcessingLib.class);

    public static int[] computeItemsPerAxis(List<CellSetAxis> axes) {
        int[] axesSize = new int[axes.size()];
        for (int axesIndex = 0; axesIndex < axes.size(); ++axesIndex) {
            CellSetAxis axis = axes.get(axesIndex);
            axesSize[axesIndex] = axis.getPositions().size();
        }
        return axesSize;
    }

    public static IntList computeColumnToAxisMapping(List<CellSetAxis> axes, int[] axesMembers, int columnCount, int startAxis) {
        IntList columnToAxisPosition = new IntList(columnCount);
        for (int axesIndex = axes.size() - 1; axesIndex >= startAxis; --axesIndex) {
            int memberCntAxis = axesMembers[axesIndex];
            for (int x = 0; x < memberCntAxis; ++x) {
                columnToAxisPosition.add(axesIndex);
            }
        }
        return columnToAxisPosition;
    }

    public static int computeMemberCountForAxis(CellSetAxis axis, boolean membersOnAxisSorted) {
        List positions = axis.getPositions();
        MemberAddingStrategy strategy = membersOnAxisSorted ? new SortedMemberAddingStrategy(positions) : new ResultSetOrderMemberAddingStrategy();
        for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
            List position = ((Position)positions.get(positionsIndex)).getMembers();
            for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                Member m = (Member)position.get(positionIndex);
                ResultSetProcessingLib.computeDeepColumnNames(m, strategy);
            }
        }
        return strategy.values().size();
    }

    public static int[] computeTotalColumnsPerAxis(List<CellSetAxis> axes, int startAxis, boolean membersOnAxisSorted) {
        int[] membersPerAxis = new int[axes.size()];
        for (int axesIndex = startAxis; axesIndex < axes.size(); ++axesIndex) {
            CellSetAxis axis = axes.get(axesIndex);
            membersPerAxis[axesIndex] = ResultSetProcessingLib.computeMemberCountForAxis(axis, membersOnAxisSorted);
        }
        return membersPerAxis;
    }

    public static ArrayList<Member> computeColumnToMemberMapping(List<CellSetAxis> axes, int[] axesMembers, int startAxis, boolean membersOnAxisSorted) {
        ArrayList<Member> columnToMemberMapper = new ArrayList<Member>();
        for (int axesIndex = axes.size() - 1; axesIndex >= startAxis; --axesIndex) {
            CellSetAxis axis = axes.get(axesIndex);
            List positions = axis.getPositions();
            MemberAddingStrategy strategy = membersOnAxisSorted ? new SortedMemberAddingStrategy(positions) : new ResultSetOrderMemberAddingStrategy();
            for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
                List position = ((Position)positions.get(positionsIndex)).getMembers();
                for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                    Member m = (Member)position.get(positionIndex);
                    ResultSetProcessingLib.computeDeepColumnNames(m, strategy);
                }
            }
            Collection<Member> columnNamesSet = strategy.values();
            if (columnNamesSet.size() != axesMembers[axesIndex]) {
                logger.error((Object)"ERROR: Number of names is not equal the pre-counted number.");
            }
            columnToMemberMapper.addAll(columnNamesSet);
        }
        return columnToMemberMapper;
    }

    public static void computeDeepColumnNames(Member m, MemberAddingStrategy memberToNameMapping) {
        FastStack memberStack = new FastStack();
        while (m != null) {
            memberStack.push((Object)m);
            m = m.getParentMember();
        }
        while (!memberStack.isEmpty()) {
            Member mx = (Member)memberStack.pop();
            memberToNameMapping.add(mx);
        }
    }

    public static String computeUniqueColumnName(Position p) {
        StringBuilder positionName = new StringBuilder(100);
        List position = p.getMembers();
        for (int j = 0; j < position.size(); ++j) {
            if (j != 0) {
                positionName.append('/');
            }
            Member member = (Member)position.get(j);
            positionName.append(Olap4jUtil.getUniqueMemberName(member));
        }
        return positionName.toString();
    }
}

