/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandraoutput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.cassandra.ConnectionFactory;
import org.pentaho.cassandra.driver.datastax.DriverCQLRowHandler;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.ITableMetaData;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.cassandra.util.CassandraUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputData;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputMeta;

public class CassandraOutput
extends BaseStep
implements StepInterface {
    protected CassandraOutputMeta m_meta;
    protected CassandraOutputData m_data;
    protected Connection m_connection;
    protected Keyspace m_keyspace;
    protected CQLRowHandler m_cqlHandler = null;
    protected ITableMetaData m_cassandraMeta;
    protected StringBuilder m_batchInsertCQL;
    protected List<Object[]> m_batch;
    protected int m_rowsSeen;
    protected int m_batchSize = 100;
    protected String m_consistency = null;
    protected String m_tableName;
    protected String m_keyspaceName;
    protected List<Integer> m_keyIndexes = null;
    protected int m_cqlBatchInsertTimeout = 0;
    protected int m_batchSplitFactor = 10;
    protected String m_consistencyLevel;
    protected Map<String, String> m_opts;

    public CassandraOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.m_meta = (CassandraOutputMeta)smi;
        this.m_data = (CassandraOutputData)sdi;
        this.first = false;
        this.m_rowsSeen = 0;
        String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
        String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
        String userS = this.m_meta.getUsername();
        String passS = this.m_meta.getPassword();
        String batchTimeoutS = this.environmentSubstitute(this.m_meta.getCQLBatchInsertTimeout());
        String batchSplitFactor = this.environmentSubstitute(this.m_meta.getCQLSubBatchSize());
        String schemaHostS = this.environmentSubstitute(this.m_meta.getSchemaHost());
        String schemaPortS = this.environmentSubstitute(this.m_meta.getSchemaPort());
        if (Utils.isEmpty((CharSequence)schemaHostS)) {
            schemaHostS = hostS;
        }
        if (Utils.isEmpty((CharSequence)schemaPortS)) {
            schemaPortS = portS;
        }
        if (!Utils.isEmpty((CharSequence)userS) && !Utils.isEmpty((CharSequence)passS)) {
            userS = this.environmentSubstitute(userS);
            passS = this.environmentSubstitute(passS);
        }
        this.m_keyspaceName = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
        this.m_tableName = CassandraUtils.cql3MixedCaseQuote(this.environmentSubstitute(this.m_meta.getTableName()));
        this.m_consistencyLevel = this.environmentSubstitute(this.m_meta.getConsistency());
        String keyField = this.environmentSubstitute(this.m_meta.getKeyField());
        try {
            if (!Utils.isEmpty((CharSequence)batchTimeoutS)) {
                try {
                    this.m_cqlBatchInsertTimeout = Integer.parseInt(batchTimeoutS);
                    if (this.m_cqlBatchInsertTimeout < 500) {
                        this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.MinimumTimeout", (String[])new String[0]));
                        this.m_cqlBatchInsertTimeout = 500;
                    }
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTimeout", (String[])new String[0]));
                    this.m_cqlBatchInsertTimeout = 10000;
                }
            }
            if (!Utils.isEmpty((CharSequence)batchSplitFactor)) {
                try {
                    this.m_batchSplitFactor = Integer.parseInt(batchSplitFactor);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseSubBatchSize", (String[])new String[0]));
                }
            }
            if (Utils.isEmpty((CharSequence)hostS) || Utils.isEmpty((CharSequence)portS) || Utils.isEmpty((CharSequence)this.m_keyspaceName)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.MissingConnectionDetails", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)this.m_tableName)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoTableSpecified", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)keyField)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoIncomingKeySpecified", (String[])new String[0]));
            }
            String[] kparts = keyField.split(",");
            this.m_keyIndexes = new ArrayList<Integer>();
            for (String kpart : kparts) {
                int index = this.getInputRowMeta().indexOfValue(kpart.trim());
                if (index < 0) {
                    throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantFindKeyField", (String[])new String[]{keyField}));
                }
                this.m_keyIndexes.add(index);
            }
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ConnectingForSchemaOperations", (String[])new String[]{schemaHostS, schemaPortS, this.m_keyspaceName}));
            Connection connection = null;
            try {
                connection = this.openConnection(true);
                Keyspace keyspace = connection.getKeyspace(this.m_keyspaceName);
                if (!Utils.isEmpty((CharSequence)this.m_meta.getAprioriCQL())) {
                    String aprioriCQL = this.environmentSubstitute(this.m_meta.getAprioriCQL());
                    List<String> statements = CassandraUtils.splitCQLStatements(aprioriCQL);
                    this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ExecutingAprioriCQL", (String[])new String[]{this.m_tableName, aprioriCQL}));
                    String compression = this.m_meta.getUseCompression() ? "gzip" : "";
                    for (String cqlS : statements) {
                        try {
                            keyspace.executeCQL(cqlS, compression, this.m_consistencyLevel, this.log);
                        }
                        catch (Exception e) {
                            if (this.m_meta.getDontComplainAboutAprioriCQLFailing()) {
                                this.logBasic("WARNING: " + e.toString());
                                continue;
                            }
                            throw e;
                        }
                    }
                }
                if (!keyspace.tableExists(this.m_tableName)) {
                    if (this.m_meta.getCreateTable()) {
                        boolean result = keyspace.createTable(this.m_tableName, this.getInputRowMeta(), this.m_keyIndexes, this.environmentSubstitute(this.m_meta.getCreateTableWithClause()), this.log);
                        if (!result) {
                            throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NeedAtLeastOneFieldAppartFromKey", (String[])new String[0]));
                        }
                    } else {
                        throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.TableDoesNotExist", (String[])new String[]{this.m_tableName, this.m_keyspaceName}));
                    }
                }
                if (this.m_meta.getUpdateCassandraMeta()) {
                    keyspace.updateTableCQL3(this.m_tableName, this.getInputRowMeta(), this.m_keyIndexes, this.log);
                }
                this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.GettingMetaData", (String[])new String[]{this.m_tableName}));
                this.m_cassandraMeta = keyspace.getTableMetaData(this.m_tableName);
                this.m_data.setOutputRowMeta(this.getInputRowMeta());
                String batchSize = this.environmentSubstitute(this.m_meta.getBatchSize());
                if (!Utils.isEmpty((CharSequence)batchSize)) {
                    try {
                        this.m_batchSize = Integer.parseInt(batchSize);
                    }
                    catch (NumberFormatException e) {
                        this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseBatchSize", (String[])new String[0]));
                        this.m_batchSize = 100;
                    }
                } else {
                    throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoBatchSizeSet", (String[])new String[0]));
                }
                if (this.m_meta.getTruncateTable()) {
                    keyspace.truncateTable(this.m_tableName, this.log);
                }
            }
            finally {
                if (connection != null) {
                    this.closeConnection(connection);
                    connection = null;
                }
            }
            this.m_consistency = this.environmentSubstitute(this.m_meta.getConsistency());
            this.m_batchInsertCQL = CassandraUtils.newCQLBatch(this.m_batchSize, this.m_meta.getUseUnloggedBatch());
            this.m_batch = new ArrayList<Object[]>();
            this.openConnection(false);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.InitializationProblem", (String[])new String[0]), ex);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.m_rowsSeen > 0 && !this.isStopped()) {
                this.doBatch();
            }
            this.m_batchInsertCQL = null;
            this.m_batch = null;
            this.closeConnection(this.m_connection);
            this.m_connection = null;
            this.m_keyspace = null;
            this.m_cqlHandler = null;
            this.setOutputDone();
            return false;
        }
        if (!this.isStopped()) {
            if (this.first) {
                this.initialize(smi, sdi);
            }
            this.m_batch.add(r);
            ++this.m_rowsSeen;
            if (this.m_rowsSeen == this.m_batchSize) {
                this.doBatch();
            }
        } else {
            this.closeConnection(this.m_connection);
            return false;
        }
        return true;
    }

    protected void doBatch() throws KettleException {
        try {
            this.doBatch(this.m_batch);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CommitFailed", (Object[])new Object[]{this.m_batchInsertCQL.toString(), e}));
            throw new KettleException(e.fillInStackTrace());
        }
        this.m_batch.clear();
        this.m_rowsSeen = 0;
    }

    protected void doBatch(List<Object[]> batch) throws Exception {
        if (this.isStopped()) {
            this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.StoppedSkippingBatch", (String[])new String[0]));
            return;
        }
        if (batch == null || batch.isEmpty()) {
            this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.SkippingEmptyBatch", (String[])new String[0]));
            return;
        }
        int size = batch.size();
        try {
            this.m_batchInsertCQL = CassandraUtils.newCQLBatch(this.m_batchSize, this.m_meta.getUseUnloggedBatch());
            int rowsAdded = 0;
            batch = CassandraUtils.fixBatchMismatchedTypes(batch, this.m_cassandraMeta);
            DriverCQLRowHandler handler = (DriverCQLRowHandler)this.m_cqlHandler;
            handler.setUnloggedBatch(this.m_meta.getUseUnloggedBatch());
            handler.batchInsert(this.getInputRowMeta(), batch, this.m_cassandraMeta, this.m_consistencyLevel, this.m_meta.getInsertFieldsNotInMeta(), this.getLogChannel());
            if (this.m_connection == null) {
                this.openConnection(false);
            }
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.CommittingBatch", (String[])new String[]{this.m_tableName, "" + rowsAdded}));
        }
        catch (Exception e) {
            this.logError(e.getLocalizedMessage(), e);
            this.setErrors(this.getErrors() + 1L);
            this.closeConnection(this.m_connection);
            this.m_connection = null;
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.FailedToInsertBatch", (String[])new String[]{"" + size}), new Object[]{e});
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.WillNowTrySplittingIntoSubBatches", (String[])new String[0]));
            if (size == 1) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    this.putError(this.getInputRowMeta(), batch.get(0), 1L, e.getMessage(), null, "ERR_INSERT01");
                }
            }
            if (size > this.m_batchSplitFactor) {
                ArrayList<Object[]> subBatch = new ArrayList<Object[]>();
                while (batch.size() > this.m_batchSplitFactor) {
                    while (subBatch.size() < this.m_batchSplitFactor && batch.size() > 0) {
                        subBatch.add(batch.remove(batch.size() - 1));
                    }
                    this.doBatch(subBatch);
                    subBatch.clear();
                }
                this.doBatch(batch);
            }
            ArrayList<Object[]> subBatch = new ArrayList<Object[]>();
            while (batch.size() > 0) {
                subBatch.clear();
                subBatch.add(batch.remove(batch.size() - 1));
                this.doBatch(subBatch);
            }
        }
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
    }

    protected Connection openConnection(boolean forSchemaChanges) throws KettleException {
        String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
        String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
        String userS = this.m_meta.getUsername();
        String passS = this.m_meta.getPassword();
        String timeoutS = this.environmentSubstitute(this.m_meta.getSocketTimeout());
        String schemaHostS = this.environmentSubstitute(this.m_meta.getSchemaHost());
        String schemaPortS = this.environmentSubstitute(this.m_meta.getSchemaPort());
        if (Utils.isEmpty((CharSequence)schemaHostS)) {
            schemaHostS = hostS;
        }
        if (Utils.isEmpty((CharSequence)schemaPortS)) {
            schemaPortS = portS;
        }
        if (!Utils.isEmpty((CharSequence)userS) && !Utils.isEmpty((CharSequence)passS)) {
            userS = this.environmentSubstitute(userS);
            passS = this.environmentSubstitute(passS);
        }
        this.m_opts = new HashMap<String, String>();
        if (!Utils.isEmpty((CharSequence)timeoutS)) {
            this.m_opts.put("socketTimeout", timeoutS);
        }
        this.m_opts.put("batchTimeout", "" + this.m_cqlBatchInsertTimeout);
        this.m_opts.put("driverVersion", "3.4.0");
        String ttl = this.m_meta.getTTL();
        ttl = this.environmentSubstitute(ttl);
        if (!Utils.isEmpty((CharSequence)ttl) && !ttl.startsWith("-")) {
            String ttlUnit = this.m_meta.getTTLUnit();
            CassandraOutputMeta.TTLUnits theUnit = CassandraOutputMeta.TTLUnits.NONE;
            for (CassandraOutputMeta.TTLUnits u : CassandraOutputMeta.TTLUnits.values()) {
                if (!ttlUnit.equals(u.toString())) continue;
                theUnit = u;
                break;
            }
            int value = -1;
            try {
                value = Integer.parseInt(ttl);
                value = theUnit.convertToSeconds(value);
                this.m_opts.put("TTL", "" + value);
            }
            catch (NumberFormatException e) {
                this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTTL", (String[])new String[]{ttl}));
            }
        }
        if (this.m_opts.size() > 0) {
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.UsingConnectionOptions", (String[])new String[]{CassandraUtils.optionsToString(this.m_opts)}));
        }
        Connection connection = null;
        try {
            String actualHostToUse = forSchemaChanges ? schemaHostS : hostS;
            connection = CassandraUtils.getCassandraConnection(actualHostToUse, Integer.parseInt(portS), userS, passS, ConnectionFactory.Driver.BINARY_CQL3_PROTOCOL, this.m_opts);
            if (!forSchemaChanges) {
                this.m_connection = connection;
                this.m_keyspace = this.m_connection.getKeyspace(this.m_keyspaceName);
                this.m_cqlHandler = this.m_keyspace.getCQLRowHandler();
            }
        }
        catch (Exception ex) {
            this.closeConnection(connection);
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        return connection;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.closeConnection(this.m_connection);
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        super.dispose(smi, sdi);
    }

    protected void closeConnection(Connection conn) throws KettleException {
        if (conn != null) {
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ClosingConnection", (String[])new String[0]));
            try {
                conn.closeConnection();
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }
}

