/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectdelete;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.openerp.core.OpenERPHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDeleteData;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDeleteMeta;

public class OpenERPObjectDelete
extends BaseStep
implements StepInterface {
    private OpenERPObjectDeleteMeta meta;
    private OpenERPObjectDeleteData data;
    private int idIndex;

    public OpenERPObjectDelete(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            try {
                this.CommitBatch();
            }
            catch (Exception e) {
                throw new KettleException("Failed to commit batch: ", (Throwable)e);
            }
            this.logDebug("No More Rows.");
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.idIndex = this.meta.getIdFieldName() == null || this.meta.getIdFieldName().equals("") ? -1 : this.getInputRowMeta().indexOfValue(this.meta.getIdFieldName());
            if (this.idIndex == -1) {
                throw new KettleException("Failed to initialize step ", (Throwable)new Exception("Could not find ID field from input step with name: '" + this.meta.getIdFieldName() + "'"));
            }
            this.first = false;
            this.data.batchRows.clear();
        }
        String row = "";
        try {
            this.data.batchRows.add(Integer.parseInt(this.getInputRowMeta().getValueMeta(this.idIndex).getString(inputRow[this.idIndex])));
            if (this.data.batchRows.size() == this.meta.getCommitBatchSize()) {
                this.CommitBatch();
            }
        }
        catch (Exception e) {
            throw new KettleException("Failed to commit batch: " + row, (Throwable)e);
        }
        return true;
    }

    private void CommitBatch() throws Exception {
        try {
            this.data.helper.deleteObjects(this.meta.getModelName(), this.data.batchRows);
            for (int i = 0; i < this.data.batchRows.size(); ++i) {
                this.incrementLinesOutput();
            }
        }
        finally {
            this.data.batchRows.clear();
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OpenERPObjectDeleteMeta)smi;
        this.data = (OpenERPObjectDeleteData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Initializing OpenERP Session");
                this.data.helper = new OpenERPHelper(this.meta.getDatabaseMeta());
                this.data.helper.StartSession();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

