/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryQueryTimeoutException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DefaultParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ResultSetTableModelFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.StaticConnectionProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SimpleSQLReportDataFactory
extends AbstractDataFactory {
    private transient Connection connection;
    private ConnectionProvider connectionProvider;
    private static final Log logger = LogFactory.getLog(SimpleSQLReportDataFactory.class);
    private boolean columnNameMapping;
    private static final String COLUMN_NAME_MAPPING_KEY = "org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ColumnNameMapping";
    private static final String[] EMPTY_NAMES = new String[0];
    private transient Statement currentRunningStatement;
    private String userField;
    private String passwordField;

    public SimpleSQLReportDataFactory() {
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.columnNameMapping = "Name".equalsIgnoreCase(globalConfig.getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Name"));
    }

    public SimpleSQLReportDataFactory(Connection connection) {
        this(new StaticConnectionProvider(connection));
    }

    public SimpleSQLReportDataFactory(ConnectionProvider connectionProvider) {
        this();
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    protected synchronized Connection getConnection(DataRow dataRow) throws SQLException {
        if (this.connection == null) {
            Object passwordField;
            Object userRaw;
            String user = this.userField == null ? null : ((userRaw = dataRow.get(this.userField)) instanceof String ? String.valueOf(userRaw) : null);
            String password = this.passwordField == null ? null : ((passwordField = dataRow.get(this.passwordField)) instanceof String ? String.valueOf(passwordField) : null);
            this.connection = this.connectionProvider.createConnection(user, password);
        }
        if (this.connection == null) {
            throw new SQLException("Unable to get a connection from the Connection-Provider.");
        }
        return this.connection;
    }

    private int getBestResultSetType(DataRow dataRow) throws SQLException {
        if ("simple".equalsIgnoreCase(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TableFactoryMode"))) {
            return 1003;
        }
        Connection connection = this.getConnection(dataRow);
        boolean supportsScrollInsensitive = connection.getMetaData().supportsResultSetType(1004);
        boolean supportsScrollSensitive = connection.getMetaData().supportsResultSetType(1005);
        if (supportsScrollInsensitive) {
            return 1004;
        }
        if (supportsScrollSensitive) {
            return 1005;
        }
        return 1003;
    }

    @Override
    public synchronized TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        try {
            ParametrizationProviderFactory factory = this.createParametrizationProviderFactory();
            Connection connection = this.getConnection(parameters);
            ParametrizationProvider parametrizationProvider = factory.create(connection);
            String translatedQuery = parametrizationProvider.rewriteQueryForParametrization(connection, query, parameters);
            String[] preparedParameterNames = parametrizationProvider.getPreparedParameterNames();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Translated-Query: " + translatedQuery));
                logger.debug((Object)("Detected parameter:" + Arrays.asList(preparedParameterNames)));
            }
            TableModel tableModel = this.parametrizeAndQuery(parameters, translatedQuery, preparedParameterNames);
            return tableModel;
        }
        catch (SQLTimeoutException e) {
            throw new ReportDataFactoryQueryTimeoutException();
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed at query: " + query, (Throwable)e);
        }
        finally {
            this.currentRunningStatement = null;
        }
    }

    private ParametrizationProviderFactory createParametrizationProviderFactory() throws ReportDataFactoryException {
        ParametrizationProviderFactory factory;
        String parametrizationProviderClassname = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProviderFactory");
        if (parametrizationProviderClassname == null) {
            factory = new DefaultParametrizationProviderFactory();
        } else {
            factory = (ParametrizationProviderFactory)ObjectUtilities.loadAndInstantiate((String)parametrizationProviderClassname, SimpleSQLReportDataFactory.class, ParametrizationProviderFactory.class);
            if (factory == null) {
                throw new ReportDataFactoryException("The specified parametrization factory is not valid: " + parametrizationProviderClassname);
            }
        }
        return factory;
    }

    @Override
    public String[] getReferencedFields(String query, DataRow parameters) throws ReportDataFactoryException {
        boolean isNewConnection = this.connection == null;
        try {
            ParametrizationProviderFactory factory = this.createParametrizationProviderFactory();
            Connection connection = this.getConnection(parameters);
            ParametrizationProvider parametrizationProvider = factory.create(connection);
            String computedQuery = this.computedQuery(query, parameters);
            parametrizationProvider.rewriteQueryForParametrization(connection, computedQuery, parameters);
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            list.addAll(Arrays.asList(parametrizationProvider.getPreparedParameterNames()));
            if (this.userField != null) {
                list.add(this.userField);
            }
            if (this.passwordField != null) {
                list.add(this.passwordField);
            }
            list.add("::org.pentaho.reporting::query-limit");
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to perform cache preparation", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to perform cache preparation", (Throwable)e);
            throw new ReportDataFactoryException("Unable to perform cache preparation", (Throwable)e);
        }
        finally {
            if (isNewConnection) {
                this.close();
            }
        }
    }

    protected String translateQuery(String query) {
        return query;
    }

    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return queryName;
    }

    public static boolean isExpandArrayParameterNeeded(String query) {
        return !SimpleSQLReportDataFactory.isCallableStatement(query) && !SimpleSQLReportDataFactory.isCallableStatementQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableModel parametrizeAndQuery(DataRow parameters, String translatedQuery, String[] preparedParameterNames) throws SQLException {
        ResultSet res;
        PreparedStatement pstmt;
        Statement statement;
        boolean callableStatementUsed;
        boolean callableStatementQuery = SimpleSQLReportDataFactory.isCallableStatementQuery(translatedQuery);
        boolean bl = callableStatementUsed = callableStatementQuery || SimpleSQLReportDataFactory.isCallableStatement(translatedQuery);
        if (preparedParameterNames.length == 0) {
            statement = this.getConnection(parameters).createStatement(this.getBestResultSetType(parameters), 1007);
        } else if (callableStatementUsed) {
            pstmt = this.getConnection(parameters).prepareCall(translatedQuery, this.getBestResultSetType(parameters), 1007);
            if (SimpleSQLReportDataFactory.isCallableStatementQuery(translatedQuery)) {
                pstmt.registerOutParameter(1, 1111);
                this.parametrize(parameters, preparedParameterNames, pstmt, false, 1);
            } else {
                this.parametrize(parameters, preparedParameterNames, pstmt, false, 0);
            }
            statement = pstmt;
        } else {
            pstmt = this.getConnection(parameters).prepareStatement(translatedQuery, this.getBestResultSetType(parameters), 1007);
            this.parametrize(parameters, preparedParameterNames, pstmt, this.isExpandArrays(), 0);
            statement = pstmt;
        }
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        try {
            Number i;
            int max;
            if (queryLimit instanceof Number && (max = (i = (Number)queryLimit).intValue()) > 0) {
                statement.setMaxRows(max);
            }
        }
        catch (SQLException sqle) {
            logger.warn((Object)("Driver indicated error: Failed to set query-limit: " + queryLimit), (Throwable)sqle);
        }
        Object queryTimeout = parameters.get("::org.pentaho.reporting::query-timeout");
        try {
            Number i;
            int seconds;
            if (queryTimeout instanceof Number && (seconds = (i = (Number)queryTimeout).intValue()) > 0) {
                statement.setQueryTimeout(seconds);
            }
        }
        catch (SQLException sqle) {
            logger.warn((Object)("Driver indicated error: Failed to set query-timeout: " + queryTimeout), (Throwable)sqle);
        }
        try {
            this.currentRunningStatement = statement;
            res = this.performQuery(statement, translatedQuery, preparedParameterNames);
        }
        finally {
            this.currentRunningStatement = null;
        }
        boolean simpleMode = "simple".equalsIgnoreCase(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TableFactoryMode"));
        if (simpleMode) {
            return ResultSetTableModelFactory.getInstance().generateDefaultTableModel(res, this.columnNameMapping);
        }
        return ResultSetTableModelFactory.getInstance().createTableModel(res, this.columnNameMapping, true);
    }

    public ResultSet performQuery(Statement statement, String translatedQuery, String[] preparedParameterNames) throws SQLException {
        ResultSet res;
        if (preparedParameterNames.length == 0) {
            res = statement.executeQuery(translatedQuery);
        } else {
            PreparedStatement pstmt = (PreparedStatement)statement;
            res = pstmt.executeQuery();
        }
        return res;
    }

    private void parametrize(DataRow parameters, String[] params, PreparedStatement pstmt, boolean expandArrays, int parameterOffset) throws SQLException {
        pstmt.clearParameters();
        int paramIndex = parameterOffset;
        ParameterMetaData parameterMetaData = null;
        try {
            parameterMetaData = pstmt.getParameterMetaData();
        }
        catch (SQLException e) {
            logger.debug((Object)("Parameter metadata fetching threw an exception:" + e.getMessage()));
        }
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            Object pvalue = parameters.get(param);
            String typeClass = null;
            if (parameterMetaData != null) {
                typeClass = parameterMetaData.getParameterClassName(paramIndex + 1);
            }
            if (pvalue == null) {
                pstmt.setObject(paramIndex + 1, null);
                logger.debug((Object)("Parametrize: " + (paramIndex + 1) + " set to <null>"));
                ++paramIndex;
                continue;
            }
            if (expandArrays && pvalue instanceof Object[]) {
                Object[] values = (Object[])pvalue;
                if (values.length > 0) {
                    for (int j = 0; j < values.length; ++j) {
                        Object ivalue = values[j];
                        if (ivalue instanceof Date || ivalue instanceof Time || ivalue instanceof Timestamp) {
                            pstmt.setObject(paramIndex + 1, ivalue);
                        } else if (ivalue instanceof java.util.Date) {
                            java.util.Date d = (java.util.Date)ivalue;
                            pstmt.setObject(paramIndex + 1, new Timestamp(d.getTime()));
                        } else if (typeClass != null && typeClass.equals("java.lang.String")) {
                            pstmt.setObject(paramIndex + 1, String.valueOf(ivalue));
                        } else {
                            pstmt.setObject(paramIndex + 1, ivalue);
                        }
                        logger.debug((Object)("Parametrize: Array: " + (paramIndex + 1) + ": " + ivalue));
                        ++paramIndex;
                    }
                    continue;
                }
                pstmt.setObject(paramIndex + 1, null);
                logger.debug((Object)("Parametrize: Array: " + (paramIndex + 1) + " set to <null> for empty array"));
                ++paramIndex;
                continue;
            }
            if (pvalue instanceof Date || pvalue instanceof Time || pvalue instanceof Timestamp) {
                pstmt.setObject(paramIndex + 1, pvalue);
            } else if (pvalue instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)pvalue;
                pstmt.setObject(paramIndex + 1, new Timestamp(d.getTime()));
            } else if (typeClass != null && typeClass.equals("java.lang.String")) {
                pstmt.setObject(paramIndex + 1, String.valueOf(pvalue));
            } else {
                pstmt.setObject(paramIndex + 1, pvalue);
            }
            logger.debug((Object)("Parametrize: " + (paramIndex + 1) + ": " + pvalue));
            ++paramIndex;
        }
    }

    protected boolean isExpandArrays() {
        return true;
    }

    @Override
    public void cancelRunningQuery() {
        if (this.currentRunningStatement == null) {
            return;
        }
        try {
            logger.debug((Object)"Cancelling the running query...");
            this.currentRunningStatement.cancel();
        }
        catch (SQLException e) {
            logger.warn((Object)("Could not cancel running query [maybe the driver does not support that operation] : " + e.getMessage()));
        }
        finally {
            logger.debug((Object)"Returning from attempt to cancel current running statement");
        }
    }

    private static boolean isCallableStatement(String query) {
        int state = 0;
        char[] chars = query.toCharArray();
        int length = query.length();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (state != 5) continue;
                return true;
            }
            if ('{' == c && state == 0) {
                state = 1;
                continue;
            }
            if (('c' == c || 'C' == c) && state == 1) {
                state = 2;
                continue;
            }
            if (('a' == c || 'A' == c) && state == 2) {
                state = 3;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 3) {
                state = 4;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 4) {
                state = 5;
                continue;
            }
            return state == 5;
        }
        return false;
    }

    private static boolean isCallableStatementQuery(String query) {
        int state = 0;
        char[] chars = query.toCharArray();
        int length = query.length();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (state != 7) continue;
                return true;
            }
            if ('{' == c && state == 0) {
                state = 1;
                continue;
            }
            if ('?' == c && state == 1) {
                state = 2;
                continue;
            }
            if ('=' == c && state == 2) {
                state = 3;
                continue;
            }
            if (('c' == c || 'C' == c) && state == 3) {
                state = 4;
                continue;
            }
            if (('a' == c || 'A' == c) && state == 4) {
                state = 5;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 5) {
                state = 6;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 6) {
                state = 7;
                continue;
            }
            return state == 7;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }

    @Override
    public SimpleSQLReportDataFactory clone() {
        SimpleSQLReportDataFactory dataFactory = (SimpleSQLReportDataFactory)super.clone();
        dataFactory.connection = null;
        return dataFactory;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connectionProvider = connectionProvider;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    @Override
    public String[] getQueryNames() {
        return EMPTY_NAMES;
    }

    @Override
    public ArrayList<Object> getQueryHash(String queryName, DataRow parameter) {
        Object connection = this.getConnectionProvider().getConnectionHash();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        list.add(this.translateQuery(queryName));
        list.add(connection);
        return list;
    }
}

