/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.elementfactory.BandElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportElementReadHandlerFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractTextElementReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BandReadHandler
extends AbstractTextElementReadHandler {
    public static final String ROUND_RECTANGLE_TAG = "round-rectangle";
    public static final String LABEL_TAG = "label";
    public static final String STRING_FIELD_TAG = "string-field";
    public static final String NUMBER_FIELD_TAG = "number-field";
    public static final String DATE_FIELD_TAG = "date-field";
    public static final String IMAGEREF_TAG = "imageref";
    public static final String IMAGEFIELD_TAG = "image-field";
    public static final String IMAGEURLFIELD_TAG = "imageurl-field";
    public static final String RECTANGLE_TAG = "rectangle";
    public static final String RESOURCELABEL_TAG = "resource-label";
    public static final String RESOURCEFIELD_TAG = "resource-field";
    public static final String RESOURCEMESSAGE_TAG = "resource-message";
    public static final String COMPONENTFIELD_TAG = "component-field";
    public static final String LINE_TAG = "line";
    public static final String DRAWABLE_FIELD_TAG = "drawable-field";
    public static final String SHAPE_FIELD_TAG = "shape-field";
    public static final String BAND_TAG = "band";
    public static final String MESSAGE_FIELD_TAG = "message-field";
    public static final String ANCHOR_FIELD_TAG = "anchor-field";
    private static final String LAYOUT_ATT = "layout";
    private BandElementFactory bandFactory;
    private Band band;
    private ArrayList<ReportElementReadHandler> elementHandlers;
    private ArrayList<StyleExpressionHandler> styleExpressionHandlers;

    public BandReadHandler() {
        this(new Band());
    }

    protected BandReadHandler(Band band) {
        if (band == null) {
            throw new NullPointerException();
        }
        this.band = band;
        this.bandFactory = new BandElementFactory(band);
        this.elementHandlers = new ArrayList();
        this.styleExpressionHandlers = new ArrayList();
    }

    @Override
    protected TextElementFactory getTextElementFactory() {
        return this.bandFactory;
    }

    @Override
    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handleLayout(attr);
    }

    public Band getBand() {
        return this.band;
    }

    private void handleLayout(Attributes attr) {
        String layoutManagerName = attr.getValue(this.getUri(), LAYOUT_ATT);
        if (layoutManagerName != null) {
            if ("org.jfree.report.layout.StaticLayoutManager".equals(layoutManagerName)) {
                this.getBand().getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "canvas");
            } else if ("org.jfree.report.layout.StackedLayoutManager".equals(layoutManagerName)) {
                this.getBand().getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
            }
            if ("org.pentaho.reporting.engine.classic.core.layout.StaticLayoutManager".equals(layoutManagerName)) {
                this.getBand().getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "canvas");
            } else if ("org.pentaho.reporting.engine.classic.core.layout.StackedLayoutManager".equals(layoutManagerName)) {
                this.getBand().getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
            } else {
                this.getBand().getStyle().setStyleProperty(BandStyleKeys.LAYOUT, layoutManagerName);
            }
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        ReportElementReadHandlerFactory factory = ReportElementReadHandlerFactory.getInstance();
        ReportElementReadHandler handler = (ReportElementReadHandler)factory.getHandler(uri, tagName);
        if (handler != null) {
            this.elementHandlers.add(handler);
            return handler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("style-expression".equals(tagName)) {
            StyleExpressionHandler stylehandler = new StyleExpressionHandler();
            this.styleExpressionHandlers.add(stylehandler);
            return stylehandler;
        }
        return null;
    }

    @Override
    protected void doneParsing() throws SAXException {
        int i;
        for (i = 0; i < this.elementHandlers.size(); ++i) {
            XmlReadHandler readHandler = this.elementHandlers.get(i);
            Element e = (Element)readHandler.getObject();
            this.band.addElement(e);
        }
        for (i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            StyleExpressionHandler handler = this.styleExpressionHandlers.get(i);
            if (handler.getKey() == null) continue;
            this.band.setStyleExpression(handler.getKey(), handler.getExpression());
        }
        this.band.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
        super.doneParsing();
    }

    @Override
    public Object getObject() {
        return this.band;
    }
}

