/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.security.KeyPair;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.ServerFactoryManager;

public class ServerSession
extends AbstractSession {
    protected static final long MAX_PACKETS = 0x80000000L;
    private long authTimeoutTimestamp;
    private long idleTimeoutTimestamp = 0L;
    private int authTimeoutMs = this.getIntProperty("auth-timeout", this.authTimeoutMs);
    private int idleTimeoutMs = 600000;
    private long maxBytes = 0x40000000L;
    private long maxKeyInterval = 3600000L;

    public ServerSession(ServerFactoryManager server, IoSession ioSession) throws Exception {
        super(true, server, ioSession);
        this.authTimeoutTimestamp = System.currentTimeMillis() + (long)this.authTimeoutMs;
        this.idleTimeoutMs = this.getIntProperty("idle-timeout", this.idleTimeoutMs);
        this.maxBytes = Math.max(32L, this.getLongProperty("rekey-bytes-limit", this.maxBytes));
        this.maxKeyInterval = this.getLongProperty("rekey-time-limit", this.maxKeyInterval);
        this.log.info("Server session created from {}", (Object)ioSession.getRemoteAddress());
        this.sendServerIdentification();
        this.kexState.set(1);
        this.sendKexInit();
    }

    public String getNegotiated(int index) {
        return this.negotiated[index];
    }

    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)this.factoryManager;
    }

    protected void checkKeys() {
    }

    public void startService(String name) throws Exception {
        this.currentService = ServiceFactory.Utils.create(this.getFactoryManager().getServiceFactories(), name, this);
    }

    protected void serviceAccept() throws IOException {
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT");
    }

    protected void checkForTimeouts() throws IOException {
        if (this.state.get() == 0) {
            long now = System.currentTimeMillis();
            if (!this.authed && now > this.authTimeoutTimestamp) {
                this.disconnect(2, "Session has timed out waiting for authentication after " + this.authTimeoutMs + " ms.");
            }
            if (this.idleTimeoutTimestamp > 0L && now > this.idleTimeoutTimestamp) {
                this.disconnect(2, "User session has timed out idling after " + this.idleTimeoutMs + " ms.");
            }
        }
    }

    protected void checkRekey() throws IOException {
        if (this.kexState.get() == 4 && (this.inPackets > 0x80000000L || this.outPackets > 0x80000000L || this.inBytes > this.maxBytes || this.outBytes > this.maxBytes || this.maxKeyInterval > 0L && System.currentTimeMillis() - this.lastKeyTime > this.maxKeyInterval)) {
            this.reExchangeKeys();
        }
    }

    public void resetIdleTimeout() {
        this.idleTimeoutTimestamp = System.currentTimeMillis() + (long)this.idleTimeoutMs;
    }

    private void sendServerIdentification() {
        this.serverVersion = this.getFactoryManager().getProperties() != null && this.getFactoryManager().getProperties().get("server-identification") != null ? "SSH-2.0-" + this.getFactoryManager().getProperties().get("server-identification") : "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.serverVersion);
    }

    protected void sendKexInit() throws IOException {
        this.serverProposal = this.createProposal(this.factoryManager.getKeyPairProvider().getKeyTypes());
        this.I_S = this.sendKexInit(this.serverProposal);
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.clientVersion = this.doReadIdentification(buffer);
        if (this.clientVersion == null) {
            return false;
        }
        this.log.debug("Client version string: {}", (Object)this.clientVersion);
        if (!this.clientVersion.startsWith("SSH-2.0-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.clientVersion);
        }
        return true;
    }

    protected void receiveKexInit(Buffer buffer) throws IOException {
        this.clientProposal = new String[10];
        this.I_C = this.receiveKexInit(buffer, this.clientProposal);
    }

    public KeyPair getHostKey() {
        return this.factoryManager.getKeyPairProvider().loadKey(this.negotiated[1]);
    }

    protected int getActiveSessionCountForUser(String userName) {
        int totalCount = 0;
        for (IoSession is : this.ioSession.getService().getManagedSessions().values()) {
            ServerSession session = (ServerSession)ServerSession.getSession(is, true);
            if (session == null || session.getUsername() == null || !session.getUsername().equals(userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public long getId() {
        return this.ioSession.getId();
    }
}

