/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class StripeStoreFileManager
implements StoreFileManager,
StripeCompactionPolicy.StripeInformationProvider {
    private static final Log LOG = LogFactory.getLog(StripeStoreFileManager.class);
    public static final byte[] STRIPE_START_KEY = Bytes.toBytes((String)"STRIPE_START_KEY");
    public static final byte[] STRIPE_END_KEY = Bytes.toBytes((String)"STRIPE_END_KEY");
    private static final Bytes.RowEndKeyComparator MAP_COMPARATOR = new Bytes.RowEndKeyComparator();
    public static final byte[] OPEN_KEY = HConstants.EMPTY_BYTE_ARRAY;
    static final byte[] INVALID_KEY = null;
    private State state = null;
    private HashMap<StoreFile, byte[]> fileStarts = new HashMap();
    private HashMap<StoreFile, byte[]> fileEnds = new HashMap();
    private static final byte[] INVALID_KEY_IN_MAP = new byte[0];
    private final KeyValue.KVComparator kvComparator;
    private StripeStoreConfig config;
    private final int blockingFileCount;

    public StripeStoreFileManager(KeyValue.KVComparator kvComparator, Configuration conf, StripeStoreConfig config) {
        this.kvComparator = kvComparator;
        this.config = config;
        this.blockingFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 7);
    }

    @Override
    public void loadFiles(List<StoreFile> storeFiles) {
        this.loadUnclassifiedStoreFiles(storeFiles);
    }

    @Override
    public Collection<StoreFile> getStorefiles() {
        return this.state.allFilesCached;
    }

    @Override
    public Collection<StoreFile> getCompactedfiles() {
        return this.state.allCompactedFilesCached;
    }

    @Override
    public void insertNewFiles(Collection<StoreFile> sfs) throws IOException {
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(true);
        cmc.mergeResults(null, sfs);
        this.debugDumpState("Added new files");
    }

    @Override
    public ImmutableCollection<StoreFile> clearFiles() {
        ImmutableList<StoreFile> result = this.state.allFilesCached;
        this.state = new State();
        this.fileStarts.clear();
        this.fileEnds.clear();
        return result;
    }

    public ImmutableCollection<StoreFile> clearCompactedFiles() {
        ImmutableList result = this.state.allCompactedFilesCached;
        this.state = new State();
        return result;
    }

    @Override
    public int getStorefileCount() {
        return this.state.allFilesCached.size();
    }

    @Override
    public Iterator<StoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        KeyBeforeConcatenatedLists result = new KeyBeforeConcatenatedLists();
        result.addSublist((List)this.state.level0Files);
        if (!this.state.stripeFiles.isEmpty()) {
            int lastStripeIndex;
            for (int stripeIndex = lastStripeIndex = this.findStripeForRow(targetKey.getRow(), false); stripeIndex >= 0; --stripeIndex) {
                result.addSublist((List)this.state.stripeFiles.get(stripeIndex));
            }
        }
        return result.iterator();
    }

    @Override
    public Iterator<StoreFile> updateCandidateFilesForRowKeyBefore(Iterator<StoreFile> candidateFiles, KeyValue targetKey, Cell candidate) {
        KeyBeforeConcatenatedLists.Iterator original = (KeyBeforeConcatenatedLists.Iterator)((Object)candidateFiles);
        assert (original != null);
        ArrayList<List<StoreFile>> components = original.getComponents();
        for (int firstIrrelevant = 0; firstIrrelevant < components.size(); ++firstIrrelevant) {
            StoreFile sf = components.get(firstIrrelevant).get(0);
            byte[] endKey = this.endOf(sf);
            if (StripeStoreFileManager.isInvalid(endKey) || StripeStoreFileManager.isOpen(endKey) || this.nonOpenRowCompare(endKey, targetKey.getRow()) > 0) continue;
            original.removeComponents(firstIrrelevant);
            break;
        }
        return original;
    }

    @Override
    public byte[] getSplitPoint() throws IOException {
        double newRatio;
        if (this.getStorefileCount() == 0) {
            return null;
        }
        if (this.state.stripeFiles.size() <= 1) {
            return this.getSplitPointFromAllFiles();
        }
        int leftIndex = -1;
        int rightIndex = this.state.stripeFiles.size();
        long leftSize = 0L;
        long rightSize = 0L;
        long lastLeftSize = 0L;
        long lastRightSize = 0L;
        while (rightIndex - 1 != leftIndex) {
            if (leftSize >= rightSize) {
                lastRightSize = this.getStripeFilesSize(--rightIndex);
                rightSize += lastRightSize;
                continue;
            }
            lastLeftSize = this.getStripeFilesSize(++leftIndex);
            leftSize += lastLeftSize;
        }
        if (leftSize == 0L || rightSize == 0L) {
            String errMsg = String.format("Cannot split on a boundary - left index %d size %d, right index %d size %d", leftIndex, leftSize, rightIndex, rightSize);
            this.debugDumpState(errMsg);
            LOG.warn((Object)errMsg);
            return this.getSplitPointFromAllFiles();
        }
        double ratio = (double)rightSize / (double)leftSize;
        if (ratio < 1.0) {
            ratio = 1.0 / ratio;
        }
        if ((double)this.config.getMaxSplitImbalance() > ratio) {
            return this.state.stripeEndRows[leftIndex];
        }
        boolean isRightLarger = rightSize >= leftSize;
        double d = newRatio = isRightLarger ? this.getMidStripeSplitRatio(leftSize, rightSize, lastRightSize) : this.getMidStripeSplitRatio(rightSize, leftSize, lastLeftSize);
        if (newRatio < 1.0) {
            newRatio = 1.0 / newRatio;
        }
        if (newRatio >= ratio) {
            return this.state.stripeEndRows[leftIndex];
        }
        LOG.debug((Object)("Splitting the stripe - ratio w/o split " + ratio + ", ratio with split " + newRatio + " configured ratio " + this.config.getMaxSplitImbalance()));
        return StoreUtils.getLargestFile((Collection)this.state.stripeFiles.get(isRightLarger ? rightIndex : leftIndex)).getFileSplitPoint(this.kvComparator);
    }

    private byte[] getSplitPointFromAllFiles() throws IOException {
        ConcatenatedLists sfs = new ConcatenatedLists();
        sfs.addSublist(this.state.level0Files);
        sfs.addAllSublists(this.state.stripeFiles);
        if (sfs.isEmpty()) {
            return null;
        }
        return StoreUtils.getLargestFile((Collection<StoreFile>)sfs).getFileSplitPoint(this.kvComparator);
    }

    private double getMidStripeSplitRatio(long smallerSize, long largerSize, long lastLargerSize) {
        return (double)((float)largerSize - (float)lastLargerSize / 2.0f) / (double)((float)smallerSize + (float)lastLargerSize / 2.0f);
    }

    @Override
    public Collection<StoreFile> getFilesForScanOrGet(boolean isGet, byte[] startRow, byte[] stopRow) {
        if (this.state.stripeFiles.isEmpty()) {
            return this.state.level0Files;
        }
        int firstStripe = this.findStripeForRow(startRow, true);
        int lastStripe = this.findStripeForRow(stopRow, false);
        assert (firstStripe <= lastStripe);
        if (firstStripe == lastStripe && this.state.level0Files.isEmpty()) {
            return (Collection)this.state.stripeFiles.get(firstStripe);
        }
        if (firstStripe == 0 && lastStripe == this.state.stripeFiles.size() - 1) {
            return this.state.allFilesCached;
        }
        ConcatenatedLists result = new ConcatenatedLists();
        result.addAllSublists(this.state.stripeFiles.subList(firstStripe, lastStripe + 1));
        result.addSublist(this.state.level0Files);
        return result;
    }

    @Override
    public void addCompactionResults(Collection<StoreFile> compactedFiles, Collection<StoreFile> results) throws IOException {
        LOG.debug((Object)("Attempting to merge compaction results: " + compactedFiles.size() + " files replaced by " + results.size()));
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(false);
        cmc.mergeResults(compactedFiles, results);
        this.markCompactedAway(compactedFiles);
        this.debugDumpState("Merged compaction results");
    }

    private void markCompactedAway(Collection<StoreFile> compactedFiles) {
        for (StoreFile file : compactedFiles) {
            file.markCompactedAway();
        }
    }

    @Override
    public void removeCompactedFiles(Collection<StoreFile> compactedFiles) throws IOException {
        LOG.debug((Object)("Attempting to delete compaction results: " + compactedFiles.size()));
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(false);
        cmc.deleteResults(compactedFiles);
        this.debugDumpState("Deleted compaction results");
    }

    @Override
    public int getStoreCompactionPriority() {
        int sc;
        int fc = this.getStorefileCount();
        if (this.state.stripeFiles.isEmpty() || this.blockingFileCount <= fc) {
            return this.blockingFileCount - fc;
        }
        int l0 = this.state.level0Files.size();
        int priority = (int)Math.ceil((double)(this.blockingFileCount - fc + l0) / (double)(sc = this.state.stripeFiles.size()) - (double)l0);
        return priority <= 1 ? 2 : priority;
    }

    private long getStripeFilesSize(int stripeIndex) {
        long result = 0L;
        for (StoreFile sf : this.state.stripeFiles.get(stripeIndex)) {
            result += sf.getReader().length();
        }
        return result;
    }

    private void loadUnclassifiedStoreFiles(List<StoreFile> storeFiles) {
        LOG.debug((Object)("Attempting to load " + storeFiles.size() + " store files."));
        TreeMap candidateStripes = new TreeMap((Comparator<byte[]>)MAP_COMPARATOR);
        ArrayList<StoreFile> level0Files = new ArrayList<StoreFile>();
        for (StoreFile sf : storeFiles) {
            byte[] startRow = this.startOf(sf);
            byte[] endRow = this.endOf(sf);
            if (StripeStoreFileManager.isInvalid(startRow) || StripeStoreFileManager.isInvalid(endRow)) {
                StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                this.ensureLevel0Metadata(sf);
                continue;
            }
            if (!StripeStoreFileManager.isOpen(startRow) && !StripeStoreFileManager.isOpen(endRow) && this.nonOpenRowCompare(startRow, endRow) >= 0) {
                LOG.error((Object)("Unexpected metadata - start row [" + Bytes.toString((byte[])startRow) + "], end row [" + Bytes.toString((byte[])endRow) + "] in file [" + sf.getPath() + "], pushing to L0"));
                StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                this.ensureLevel0Metadata(sf);
                continue;
            }
            ArrayList stripe = (ArrayList)candidateStripes.get(endRow);
            if (stripe == null) {
                stripe = new ArrayList();
                candidateStripes.put(endRow, stripe);
            }
            StripeStoreFileManager.insertFileIntoStripe(stripe, sf);
        }
        boolean hasOverlaps = false;
        byte[] expectedStartRow = null;
        Iterator entryIter = candidateStripes.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            ArrayList files = (ArrayList)entry.getValue();
            for (int i = 0; i < files.size(); ++i) {
                StoreFile sf = (StoreFile)files.get(i);
                byte[] startRow = this.startOf(sf);
                if (expectedStartRow == null) {
                    expectedStartRow = startRow;
                    continue;
                }
                if (this.rowEquals(expectedStartRow, startRow)) continue;
                hasOverlaps = true;
                LOG.warn((Object)("Store file doesn't fit into the tentative stripes - expected to start at [" + Bytes.toString((byte[])expectedStartRow) + "], but starts at [" + Bytes.toString((byte[])startRow) + "], to L0 it goes"));
                StoreFile badSf = (StoreFile)files.remove(i);
                StripeStoreFileManager.insertFileIntoStripe(level0Files, badSf);
                this.ensureLevel0Metadata(badSf);
                --i;
            }
            byte[] endRow = (byte[])entry.getKey();
            if (!files.isEmpty()) {
                expectedStartRow = endRow;
                continue;
            }
            entryIter.remove();
        }
        if (!candidateStripes.isEmpty()) {
            boolean isOpen;
            StoreFile firstFile = (StoreFile)((ArrayList)candidateStripes.firstEntry().getValue()).get(0);
            boolean bl = isOpen = StripeStoreFileManager.isOpen(this.startOf(firstFile)) && StripeStoreFileManager.isOpen((byte[])candidateStripes.lastKey());
            if (!isOpen) {
                LOG.warn((Object)("The range of the loaded files does not cover full key space: from [" + Bytes.toString((byte[])this.startOf(firstFile)) + "], to [" + Bytes.toString((byte[])((byte[])candidateStripes.lastKey())) + "]"));
                if (!hasOverlaps) {
                    this.ensureEdgeStripeMetadata((ArrayList)candidateStripes.firstEntry().getValue(), true);
                    this.ensureEdgeStripeMetadata((ArrayList)candidateStripes.lastEntry().getValue(), false);
                } else {
                    LOG.warn((Object)"Inconsistent files, everything goes to L0.");
                    for (ArrayList files : candidateStripes.values()) {
                        for (StoreFile sf : files) {
                            StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                            this.ensureLevel0Metadata(sf);
                        }
                    }
                    candidateStripes.clear();
                }
            }
        }
        State state = new State();
        state.level0Files = ImmutableList.copyOf(level0Files);
        state.stripeFiles = new ArrayList(candidateStripes.size());
        state.stripeEndRows = new byte[Math.max(0, candidateStripes.size() - 1)][];
        ArrayList<StoreFile> newAllFiles = new ArrayList<StoreFile>(level0Files);
        int i = candidateStripes.size() - 1;
        for (Map.Entry entry : candidateStripes.entrySet()) {
            state.stripeFiles.add((ImmutableList<StoreFile>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            newAllFiles.addAll((Collection)entry.getValue());
            if (i > 0) {
                state.stripeEndRows[state.stripeFiles.size() - 1] = (byte[])entry.getKey();
            }
            --i;
        }
        state.allFilesCached = ImmutableList.copyOf(newAllFiles);
        this.state = state;
        this.debugDumpState("Files loaded");
    }

    private void ensureEdgeStripeMetadata(ArrayList<StoreFile> stripe, boolean isFirst) {
        HashMap<StoreFile, byte[]> targetMap = isFirst ? this.fileStarts : this.fileEnds;
        for (StoreFile sf : stripe) {
            targetMap.put(sf, OPEN_KEY);
        }
    }

    private void ensureLevel0Metadata(StoreFile sf) {
        if (!StripeStoreFileManager.isInvalid(this.startOf(sf))) {
            this.fileStarts.put(sf, INVALID_KEY_IN_MAP);
        }
        if (!StripeStoreFileManager.isInvalid(this.endOf(sf))) {
            this.fileEnds.put(sf, INVALID_KEY_IN_MAP);
        }
    }

    private void debugDumpState(String string) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + string + "; current stripe state is as such:");
        sb.append("\n level 0 with ").append(this.state.level0Files.size()).append(" files: " + StringUtils.TraditionalBinaryPrefix.long2String((long)StripeCompactionPolicy.getTotalFileSize(this.state.level0Files), (String)"", (int)1) + ";");
        for (int i = 0; i < this.state.stripeFiles.size(); ++i) {
            String endRow = i == this.state.stripeEndRows.length ? "(end)" : "[" + Bytes.toString((byte[])this.state.stripeEndRows[i]) + "]";
            sb.append("\n stripe ending in ").append(endRow).append(" with ").append(this.state.stripeFiles.get(i).size()).append(" files: " + StringUtils.TraditionalBinaryPrefix.long2String((long)StripeCompactionPolicy.getTotalFileSize((Collection)this.state.stripeFiles.get(i)), (String)"", (int)1) + ";");
        }
        sb.append("\n").append(this.state.stripeFiles.size()).append(" stripes total.");
        sb.append("\n").append(this.getStorefileCount()).append(" files total.");
        LOG.debug((Object)sb.toString());
    }

    private static final boolean isOpen(byte[] key) {
        return key != null && key.length == 0;
    }

    private static final boolean isInvalid(byte[] key) {
        return key == INVALID_KEY;
    }

    private final boolean rowEquals(byte[] k1, byte[] k2) {
        return this.kvComparator.matchingRows(k1, 0, k1.length, k2, 0, k2.length);
    }

    private final int nonOpenRowCompare(byte[] k1, byte[] k2) {
        assert (!StripeStoreFileManager.isOpen(k1) && !StripeStoreFileManager.isOpen(k2));
        return this.kvComparator.compareRows(k1, 0, k1.length, k2, 0, k2.length);
    }

    private final int findStripeIndexByEndRow(byte[] endRow) {
        assert (!StripeStoreFileManager.isInvalid(endRow));
        if (StripeStoreFileManager.isOpen(endRow)) {
            return this.state.stripeEndRows.length;
        }
        return Arrays.binarySearch(this.state.stripeEndRows, endRow, Bytes.BYTES_COMPARATOR);
    }

    private final int findStripeForRow(byte[] row, boolean isStart) {
        if (isStart && row == HConstants.EMPTY_START_ROW) {
            return 0;
        }
        if (!isStart && row == HConstants.EMPTY_END_ROW) {
            return this.state.stripeFiles.size() - 1;
        }
        return Math.abs(Arrays.binarySearch(this.state.stripeEndRows, row, Bytes.BYTES_COMPARATOR) + 1);
    }

    @Override
    public final byte[] getStartRow(int stripeIndex) {
        return stripeIndex == 0 ? OPEN_KEY : this.state.stripeEndRows[stripeIndex - 1];
    }

    @Override
    public final byte[] getEndRow(int stripeIndex) {
        return stripeIndex == this.state.stripeEndRows.length ? OPEN_KEY : this.state.stripeEndRows[stripeIndex];
    }

    private byte[] startOf(StoreFile sf) {
        byte[] result = this.fileStarts.get(sf);
        return result == null ? sf.getMetadataValue(STRIPE_START_KEY) : (result == INVALID_KEY_IN_MAP ? INVALID_KEY : result);
    }

    private byte[] endOf(StoreFile sf) {
        byte[] result = this.fileEnds.get(sf);
        return result == null ? sf.getMetadataValue(STRIPE_END_KEY) : (result == INVALID_KEY_IN_MAP ? INVALID_KEY : result);
    }

    private static void insertFileIntoStripe(ArrayList<StoreFile> stripe, StoreFile sf) {
        int insertBefore = 0;
        while (true) {
            if (insertBefore == stripe.size() || StoreFile.Comparators.SEQ_ID.compare(sf, stripe.get(insertBefore)) >= 0) break;
            ++insertBefore;
        }
        stripe.add(insertBefore, sf);
    }

    @Override
    public List<StoreFile> getLevel0Files() {
        return this.state.level0Files;
    }

    @Override
    public List<byte[]> getStripeBoundaries() {
        if (this.state.stripeFiles.isEmpty()) {
            return new ArrayList<byte[]>();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(this.state.stripeEndRows.length + 2);
        result.add(OPEN_KEY);
        Collections.addAll(result, this.state.stripeEndRows);
        result.add(OPEN_KEY);
        return result;
    }

    @Override
    public ArrayList<ImmutableList<StoreFile>> getStripes() {
        return this.state.stripeFiles;
    }

    @Override
    public int getStripeCount() {
        return this.state.stripeFiles.size();
    }

    @Override
    public Collection<StoreFile> getUnneededFiles(long maxTs, List<StoreFile> filesCompacting) {
        State state = this.state;
        Collection<StoreFile> expiredStoreFiles = null;
        for (ImmutableList<StoreFile> stripe : state.stripeFiles) {
            expiredStoreFiles = this.findExpiredFiles(stripe, maxTs, filesCompacting, expiredStoreFiles);
        }
        return this.findExpiredFiles(state.level0Files, maxTs, filesCompacting, expiredStoreFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StoreFile> findExpiredFiles(ImmutableList<StoreFile> stripe, long maxTs, List<StoreFile> filesCompacting, Collection<StoreFile> expiredStoreFiles) {
        for (int i = 1; i < stripe.size(); ++i) {
            StoreFile sf;
            StoreFile storeFile = sf = (StoreFile)stripe.get(i);
            synchronized (storeFile) {
                long fileTs = sf.getReader().getMaxTimestamp();
                if (fileTs < maxTs && !filesCompacting.contains(sf)) {
                    LOG.info((Object)("Found an expired store file: " + sf.getPath() + " whose maxTimeStamp is " + fileTs + ", which is below " + maxTs));
                    if (expiredStoreFiles == null) {
                        expiredStoreFiles = new ArrayList<StoreFile>();
                    }
                    expiredStoreFiles.add(sf);
                }
                continue;
            }
        }
        return expiredStoreFiles;
    }

    @Override
    public double getCompactionPressure() {
        State stateLocal = this.state;
        if (stateLocal.allFilesCached.size() > this.blockingFileCount) {
            return 2.0;
        }
        if (stateLocal.stripeFiles.isEmpty()) {
            return 0.0;
        }
        int blockingFilePerStripe = this.blockingFileCount / stateLocal.stripeFiles.size();
        int delta = stateLocal.level0Files.isEmpty() ? 0 : 1;
        double max = 0.0;
        for (ImmutableList<StoreFile> stripeFile : stateLocal.stripeFiles) {
            int stripeFileCount = stripeFile.size();
            double normCount = (double)(stripeFileCount + delta - this.config.getStripeCompactMinFiles()) / (double)(blockingFilePerStripe - this.config.getStripeCompactMinFiles());
            if (normCount >= 1.0) {
                return 1.0;
            }
            if (!(normCount > max)) continue;
            max = normCount;
        }
        return max;
    }

    @Override
    public Comparator<StoreFile> getStoreFileComparator() {
        return StoreFile.Comparators.SEQ_ID;
    }

    private class CompactionOrFlushMergeCopy {
        private ArrayList<List<StoreFile>> stripeFiles = null;
        private ArrayList<StoreFile> level0Files = null;
        private ArrayList<byte[]> stripeEndRows = null;
        private Collection<StoreFile> compactedFiles = null;
        private Collection<StoreFile> results = null;
        private List<StoreFile> l0Results = new ArrayList<StoreFile>();
        private final boolean isFlush;

        public CompactionOrFlushMergeCopy(boolean isFlush) {
            this.stripeFiles = new ArrayList<ImmutableList<StoreFile>>(((StripeStoreFileManager)StripeStoreFileManager.this).state.stripeFiles);
            this.isFlush = isFlush;
        }

        private void mergeResults(Collection<StoreFile> compactedFiles, Collection<StoreFile> results) throws IOException {
            TreeMap<byte[], StoreFile> newStripes;
            assert (this.compactedFiles == null && this.results == null);
            this.compactedFiles = compactedFiles;
            this.results = results;
            if (!this.isFlush) {
                this.removeCompactedFiles();
            }
            if ((newStripes = this.processResults()) != null) {
                this.processNewCandidateStripes(newStripes);
            }
            State state = this.createNewState(false);
            StripeStoreFileManager.this.state = state;
            this.updateMetadataMaps();
        }

        private void deleteResults(Collection<StoreFile> compactedFiles) throws IOException {
            this.compactedFiles = compactedFiles;
            State state = this.createNewState(true);
            StripeStoreFileManager.this.state = state;
            this.updateMetadataMaps();
        }

        private State createNewState(boolean delCompactedFiles) {
            State oldState = StripeStoreFileManager.this.state;
            assert (oldState.stripeFiles.size() == this.stripeFiles.size() || this.stripeEndRows != null);
            State newState = new State();
            newState.level0Files = this.level0Files == null ? oldState.level0Files : ImmutableList.copyOf(this.level0Files);
            newState.stripeEndRows = this.stripeEndRows == null ? oldState.stripeEndRows : (byte[][])this.stripeEndRows.toArray((T[])new byte[this.stripeEndRows.size()][]);
            newState.stripeFiles = new ArrayList(this.stripeFiles.size());
            for (List<StoreFile> newStripe : this.stripeFiles) {
                newState.stripeFiles.add((ImmutableList<StoreFile>)(newStripe instanceof ImmutableList ? (ImmutableList)newStripe : ImmutableList.copyOf(newStripe)));
            }
            ArrayList<StoreFile> newAllFiles = new ArrayList<StoreFile>((Collection<StoreFile>)oldState.allFilesCached);
            ArrayList<StoreFile> newAllCompactedFiles = new ArrayList<StoreFile>((Collection<StoreFile>)oldState.allCompactedFilesCached);
            if (!this.isFlush) {
                newAllFiles.removeAll(this.compactedFiles);
                if (delCompactedFiles) {
                    newAllCompactedFiles.removeAll(this.compactedFiles);
                } else {
                    newAllCompactedFiles.addAll(this.compactedFiles);
                }
            }
            if (this.results != null) {
                newAllFiles.addAll(this.results);
            }
            newState.allFilesCached = ImmutableList.copyOf(newAllFiles);
            newState.allCompactedFilesCached = ImmutableList.copyOf(newAllCompactedFiles);
            return newState;
        }

        private void updateMetadataMaps() {
            StripeStoreFileManager parent = StripeStoreFileManager.this;
            if (!this.isFlush) {
                for (StoreFile sf : this.compactedFiles) {
                    parent.fileStarts.remove(sf);
                    parent.fileEnds.remove(sf);
                }
            }
            if (this.l0Results != null) {
                for (StoreFile sf : this.l0Results) {
                    parent.ensureLevel0Metadata(sf);
                }
            }
        }

        private final ArrayList<StoreFile> getStripeCopy(int index) {
            List<StoreFile> stripeCopy = this.stripeFiles.get(index);
            ArrayList<StoreFile> result = null;
            if (stripeCopy instanceof ImmutableList) {
                result = new ArrayList<StoreFile>(stripeCopy);
                this.stripeFiles.set(index, result);
            } else {
                result = (ArrayList<StoreFile>)stripeCopy;
            }
            return result;
        }

        private final ArrayList<StoreFile> getLevel0Copy() {
            if (this.level0Files == null) {
                this.level0Files = new ArrayList<StoreFile>((Collection<StoreFile>)((StripeStoreFileManager)StripeStoreFileManager.this).state.level0Files);
            }
            return this.level0Files;
        }

        private TreeMap<byte[], StoreFile> processResults() throws IOException {
            TreeMap<byte[], StoreFile> newStripes = null;
            for (StoreFile sf : this.results) {
                StoreFile oldSf;
                int stripeIndex;
                byte[] startRow = StripeStoreFileManager.this.startOf(sf);
                byte[] endRow = StripeStoreFileManager.this.endOf(sf);
                if (StripeStoreFileManager.isInvalid(endRow) || StripeStoreFileManager.isInvalid(startRow)) {
                    if (!this.isFlush) {
                        LOG.warn((Object)("The newly compacted file doesn't have stripes set: " + sf.getPath()));
                    }
                    StripeStoreFileManager.insertFileIntoStripe(this.getLevel0Copy(), sf);
                    this.l0Results.add(sf);
                    continue;
                }
                if (!this.stripeFiles.isEmpty() && (stripeIndex = StripeStoreFileManager.this.findStripeIndexByEndRow(endRow)) >= 0 && StripeStoreFileManager.this.rowEquals(StripeStoreFileManager.this.getStartRow(stripeIndex), startRow)) {
                    StripeStoreFileManager.insertFileIntoStripe(this.getStripeCopy(stripeIndex), sf);
                    continue;
                }
                if (newStripes == null) {
                    newStripes = new TreeMap<byte[], StoreFile>((Comparator<byte[]>)MAP_COMPARATOR);
                }
                if ((oldSf = newStripes.put(endRow, sf)) == null) continue;
                throw new IOException("Compactor has produced multiple files for the stripe ending in [" + Bytes.toString((byte[])endRow) + "], found " + sf.getPath() + " and " + oldSf.getPath());
            }
            return newStripes;
        }

        private void removeCompactedFiles() throws IOException {
            for (StoreFile oldFile : this.compactedFiles) {
                byte[] oldEndRow = StripeStoreFileManager.this.endOf(oldFile);
                ArrayList<StoreFile> source = null;
                if (StripeStoreFileManager.isInvalid(oldEndRow)) {
                    source = this.getLevel0Copy();
                } else {
                    int stripeIndex = StripeStoreFileManager.this.findStripeIndexByEndRow(oldEndRow);
                    if (stripeIndex < 0) {
                        throw new IOException("An allegedly compacted file [" + oldFile + "] does not belong" + " to a known stripe (end row - [" + Bytes.toString((byte[])oldEndRow) + "])");
                    }
                    source = this.getStripeCopy(stripeIndex);
                }
                if (source.remove(oldFile)) continue;
                throw new IOException("An allegedly compacted file [" + oldFile + "] was not found");
            }
        }

        private void processNewCandidateStripes(TreeMap<byte[], StoreFile> newStripes) throws IOException {
            boolean hasStripes = !this.stripeFiles.isEmpty();
            this.stripeEndRows = new ArrayList(Arrays.asList(((StripeStoreFileManager)StripeStoreFileManager.this).state.stripeEndRows));
            int removeFrom = 0;
            byte[] firstStartRow = StripeStoreFileManager.this.startOf(newStripes.firstEntry().getValue());
            byte[] lastEndRow = newStripes.lastKey();
            if (!(hasStripes || StripeStoreFileManager.isOpen(firstStartRow) && StripeStoreFileManager.isOpen(lastEndRow))) {
                throw new IOException("Newly created stripes do not cover the entire key space.");
            }
            boolean canAddNewStripes = true;
            Collection<StoreFile> filesForL0 = null;
            if (hasStripes) {
                if (StripeStoreFileManager.isOpen(firstStartRow)) {
                    removeFrom = 0;
                } else {
                    removeFrom = StripeStoreFileManager.this.findStripeIndexByEndRow(firstStartRow);
                    if (removeFrom < 0) {
                        throw new IOException("Compaction is trying to add a bad range.");
                    }
                    ++removeFrom;
                }
                int removeTo = StripeStoreFileManager.this.findStripeIndexByEndRow(lastEndRow);
                if (removeTo < 0) {
                    throw new IOException("Compaction is trying to add a bad range.");
                }
                ArrayList<StoreFile> conflictingFiles = new ArrayList<StoreFile>();
                for (int removeIndex = removeTo; removeIndex >= removeFrom; --removeIndex) {
                    conflictingFiles.addAll((Collection)this.stripeFiles.get(removeIndex));
                }
                if (!conflictingFiles.isEmpty()) {
                    if (this.isFlush) {
                        long newSize = StripeCompactionPolicy.getTotalFileSize(newStripes.values());
                        LOG.warn((Object)("Stripes were created by a flush, but results of size " + newSize + " cannot be added because the stripes have changed"));
                        canAddNewStripes = false;
                        filesForL0 = newStripes.values();
                    } else {
                        long oldSize = StripeCompactionPolicy.getTotalFileSize(conflictingFiles);
                        LOG.info((Object)(conflictingFiles.size() + " conflicting files (likely created by a flush) " + " of size " + oldSize + " are moved to L0 due to concurrent stripe change"));
                        filesForL0 = conflictingFiles;
                    }
                    if (filesForL0 != null) {
                        for (StoreFile sf : filesForL0) {
                            StripeStoreFileManager.insertFileIntoStripe(this.getLevel0Copy(), sf);
                        }
                        this.l0Results.addAll(filesForL0);
                    }
                }
                if (canAddNewStripes) {
                    int originalCount = this.stripeFiles.size();
                    for (int removeIndex = removeTo; removeIndex >= removeFrom; --removeIndex) {
                        if (removeIndex != originalCount - 1) {
                            this.stripeEndRows.remove(removeIndex);
                        }
                        this.stripeFiles.remove(removeIndex);
                    }
                }
            }
            if (!canAddNewStripes) {
                return;
            }
            byte[] previousEndRow = null;
            int insertAt = removeFrom;
            for (Map.Entry<byte[], StoreFile> newStripe : newStripes.entrySet()) {
                if (previousEndRow != null) {
                    assert (!StripeStoreFileManager.isOpen(previousEndRow));
                    byte[] startRow = StripeStoreFileManager.this.startOf(newStripe.getValue());
                    if (!StripeStoreFileManager.this.rowEquals(previousEndRow, startRow)) {
                        throw new IOException("The new stripes produced by " + (this.isFlush ? "flush" : "compaction") + " are not contiguous");
                    }
                }
                ArrayList<StoreFile> tmp = new ArrayList<StoreFile>();
                tmp.add(newStripe.getValue());
                this.stripeFiles.add(insertAt, tmp);
                previousEndRow = newStripe.getKey();
                if (!StripeStoreFileManager.isOpen(previousEndRow)) {
                    this.stripeEndRows.add(insertAt, previousEndRow);
                }
                ++insertAt;
            }
        }
    }

    private static class KeyBeforeConcatenatedLists
    extends ConcatenatedLists<StoreFile> {
        private KeyBeforeConcatenatedLists() {
        }

        public java.util.Iterator<StoreFile> iterator() {
            return new Iterator();
        }

        public class Iterator
        extends ConcatenatedLists.Iterator {
            public Iterator() {
                super((ConcatenatedLists)KeyBeforeConcatenatedLists.this);
            }

            public ArrayList<List<StoreFile>> getComponents() {
                return KeyBeforeConcatenatedLists.this.components;
            }

            public void removeComponents(int startIndex) {
                List subList = KeyBeforeConcatenatedLists.this.components.subList(startIndex, KeyBeforeConcatenatedLists.this.components.size());
                for (List entry : subList) {
                    KeyBeforeConcatenatedLists.this.size -= entry.size();
                }
                assert (KeyBeforeConcatenatedLists.this.size >= 0);
                subList.clear();
            }

            public void remove() {
                if (!this.nextWasCalled) {
                    throw new IllegalStateException("No element to remove");
                }
                this.nextWasCalled = false;
                ArrayList src = (ArrayList)KeyBeforeConcatenatedLists.this.components.get(this.currentComponent);
                if (src instanceof ImmutableList) {
                    src = new ArrayList(src);
                    KeyBeforeConcatenatedLists.this.components.set(this.currentComponent, src);
                }
                src.remove(this.indexWithinComponent);
                --KeyBeforeConcatenatedLists.this.size;
                --this.indexWithinComponent;
                if (src.isEmpty()) {
                    KeyBeforeConcatenatedLists.this.components.remove(this.currentComponent);
                }
            }
        }
    }

    private static class State {
        public byte[][] stripeEndRows = new byte[0][];
        public ArrayList<ImmutableList<StoreFile>> stripeFiles = new ArrayList();
        public ImmutableList<StoreFile> level0Files = ImmutableList.of();
        public ImmutableList<StoreFile> allFilesCached = ImmutableList.of();
        private ImmutableList<StoreFile> allCompactedFilesCached = ImmutableList.of();

        private State() {
        }
    }
}

