/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.EqualOperator;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class ArrayContainsFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "ARRAYCONTAINS";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object o;
        ArrayList<TypeValuePair> needles = new ArrayList<TypeValuePair>(512);
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int paramIdx = 1; paramIdx < parameterCount; ++paramIdx) {
            try {
                Object value = parameters.getValue(paramIdx);
                RecursiveSequence sequence = new RecursiveSequence(value, context);
                while (sequence.hasNext()) {
                    o = sequence.next();
                    needles.add(new TypeValuePair(AnyType.TYPE, o));
                }
                continue;
            }
            catch (EvaluationException e) {
                if (e.getErrorValue() == LibFormulaErrorValue.ERROR_NA_VALUE) {
                    needles.add(new TypeValuePair(AnyType.TYPE, null));
                    continue;
                }
                throw e;
            }
        }
        if (needles.size() == 0) {
            return new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
        }
        Object value = parameters.getValue(0);
        RecursiveSequence sequence = new RecursiveSequence(value, context);
        EqualOperator equalOperator = new EqualOperator();
        while (sequence.hasNext()) {
            o = sequence.next();
            TypeValuePair sequenceValue = new TypeValuePair(AnyType.TYPE, o);
            for (int i = needles.size() - 1; i >= 0; --i) {
                TypeValuePair evaluate;
                TypeValuePair needle = (TypeValuePair)needles.get(i);
                if (needle.getValue() == o) {
                    needles.remove(i);
                    continue;
                }
                if (o == null || !Boolean.TRUE.equals((evaluate = equalOperator.evaluate(context, sequenceValue, needle)).getValue())) continue;
                needles.remove(i);
            }
        }
        return new TypeValuePair(LogicalType.TYPE, needles.isEmpty());
    }
}

