/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISecurityHelper;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.core.system.UserSession;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;

public class SecurityHelper
implements ISecurityHelper {
    private static final Log logger = LogFactory.getLog(SecurityHelper.class);
    private static ISecurityHelper instance = new SecurityHelper();
    private static ISecurityHelper mockInstance;
    private ITenantedPrincipleNameResolver tenantedUserNameUtils;
    private IAuthorizationPolicy policy;
    private IAclVoter aclVoter;
    private UserDetailsService userDetailsService;
    private IUserRoleListService userRoleListService;

    public static ISecurityHelper getInstance() {
        if (mockInstance != null) {
            return mockInstance;
        }
        return instance;
    }

    public static void setMockInstance(ISecurityHelper mockInstanceValue) {
        mockInstance = mockInstanceValue;
    }

    protected SecurityHelper() {
    }

    public void becomeUser(String principalName) {
        this.becomeUser(principalName, null);
    }

    public void becomeUser(String principalName, IParameterProvider paramProvider) {
        UserSession session = null;
        this.tenantedUserNameUtils = this.getTenantedUserNameUtils();
        if (this.tenantedUserNameUtils != null) {
            session = new UserSession(principalName, null, false, paramProvider);
            ITenant tenant = this.tenantedUserNameUtils.getTenant(principalName);
            session.setAttribute("org.pentaho.tenantId", tenant.getId());
            session.setAuthenticated(tenant.getId(), principalName);
        } else {
            session = new UserSession(principalName, null, false, paramProvider);
            session.setAuthenticated(principalName);
        }
        PentahoSessionHolder.setSession(session);
        Authentication auth = this.createAuthentication(principalName);
        PentahoSessionHolder.getSession().setAttribute("roles", (Object)auth.getAuthorities());
        SecurityContextHolder.clearContext();
        SecurityContextHolder.getContext().setAuthentication(auth);
        PentahoSystem.sessionStartup(PentahoSessionHolder.getSession(), paramProvider);
    }

    public <T> T runAsUser(String principalName, Callable<T> callable) throws Exception {
        return this.runAsUser(principalName, null, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsUser(String principalName, IParameterProvider paramProvider, Callable<T> callable) throws Exception {
        IPentahoSession origSession = PentahoSessionHolder.getSession();
        Authentication origAuth = SecurityContextHolder.getContext().getAuthentication();
        try {
            this.becomeUser(principalName);
            T t = callable.call();
            return t;
        }
        finally {
            IPentahoSession sessionToDestroy = PentahoSessionHolder.getSession();
            if (sessionToDestroy != null && sessionToDestroy != origSession) {
                try {
                    sessionToDestroy.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PentahoSessionHolder.setSession(origSession);
            SecurityContextHolder.getContext().setAuthentication(origAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsAnonymous(Callable<T> callable) throws Exception {
        IPentahoSession origSession = PentahoSessionHolder.getSession();
        Authentication origAuth = SecurityContextHolder.getContext().getAuthentication();
        try {
            PentahoSessionHolder.setSession(new StandaloneSession());
            String user = PentahoSystem.getSystemSetting("anonymous-authentication/anonymous-user", "anonymousUser");
            String role = PentahoSystem.getSystemSetting("anonymous-authentication/anonymous-role", "Anonymous");
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            authorities.add(new SimpleGrantedAuthority(role));
            AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken("anonymousUser", (Object)new User(user, "ignored", true, true, true, true, authorities), authorities);
            SecurityContextHolder.clearContext();
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            T t = callable.call();
            return t;
        }
        finally {
            PentahoSessionHolder.setSession(origSession);
            SecurityContextHolder.getContext().setAuthentication(origAuth);
        }
    }

    @Deprecated
    public boolean isPentahoAdministrator(IPentahoSession session) {
        IAuthorizationPolicy policy = this.getAuthorizationPolicy();
        if (policy == null) {
            logger.warn((Object)"No IAuthorizationPolicy set in PentahoSystem");
        }
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }

    public boolean isGranted(IPentahoSession session, GrantedAuthority role) {
        Authentication auth = this.getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            Collection userAuths = auth.getAuthorities();
            if (userAuths == null) {
                return false;
            }
            for (GrantedAuthority element : userAuths) {
                if (!element.equals(role)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean hasAccess(IAclHolder aHolder, int actionOperation, IPentahoSession session) {
        int aclMask = -1;
        switch (actionOperation) {
            case 0: {
                aclMask = 1;
                break;
            }
            case 1: 
            case 2: {
                aclMask = 8;
                break;
            }
            case 3: {
                aclMask = 16;
                break;
            }
            case 4: {
                aclMask = 60;
                break;
            }
            default: {
                aclMask = 1;
            }
        }
        return this.getAclVoter().hasAccess(session, aHolder, aclMask);
    }

    @Deprecated
    public IAclVoter getAclVoter() {
        if (this.aclVoter == null) {
            this.aclVoter = PentahoSystem.get(IAclVoter.class);
        }
        return this.aclVoter;
    }

    public Authentication createAuthentication(String principalName) {
        String anonymousUser = PentahoSystem.getSystemSetting("anonymous-authentication/anonymous-user", "anonymousUser");
        this.userDetailsService = this.getUserDetailsService();
        this.userRoleListService = this.getUserRoleListService();
        List roles = new ArrayList<String>();
        if (anonymousUser.equals(principalName)) {
            String anonymousRole = PentahoSystem.getSystemSetting("anonymous-authentication/anonymous-role", "Anonymous");
            roles.add(anonymousRole);
        } else {
            roles = this.userRoleListService.getRolesForUser(null, principalName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rolesForUser:" + roles));
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        if (roles != null) {
            grantedAuthorities = new ArrayList(roles.size());
            for (String role : roles) {
                grantedAuthorities.add(new SimpleGrantedAuthority(role));
            }
        }
        User user = new User(principalName, "", true, true, true, true, grantedAuthorities);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, null, grantedAuthorities);
        return auth;
    }

    public Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public Authentication getAuthentication(IPentahoSession ignoredSession, boolean ignoredAllowAnonymous) {
        return this.getAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsSystem(Callable<T> callable) throws Exception {
        String singleTenantAdmin = PentahoSystem.get(String.class, "singleTenantAdminUserName", null);
        IPentahoSession origSession = PentahoSessionHolder.getSession();
        Authentication origAuth = SecurityContextHolder.getContext().getAuthentication();
        StandaloneSession session = null;
        try {
            session = new StandaloneSession(singleTenantAdmin);
            session.setAuthenticated(singleTenantAdmin);
            PentahoSessionHolder.setSession(session);
            SecurityContextHolder.clearContext();
            Authentication auth = this.createAuthentication(singleTenantAdmin);
            SecurityContextHolder.getContext().setAuthentication(auth);
            T t = callable.call();
            return t;
        }
        finally {
            if (session != null) {
                try {
                    session.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PentahoSessionHolder.setSession(origSession);
            SecurityContextHolder.getContext().setAuthentication(origAuth);
        }
    }

    public IAuthorizationPolicy getAuthorizationPolicy() {
        if (this.policy == null) {
            this.policy = PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    public ITenantedPrincipleNameResolver getTenantedUserNameUtils() {
        if (this.tenantedUserNameUtils == null) {
            this.tenantedUserNameUtils = PentahoSystem.get(ITenantedPrincipleNameResolver.class, "tenantedUserNameUtils", null);
        }
        return this.tenantedUserNameUtils;
    }

    public UserDetailsService getUserDetailsService() {
        if (this.userDetailsService == null) {
            this.userDetailsService = PentahoSystem.get(UserDetailsService.class);
        }
        return this.userDetailsService;
    }

    public IUserRoleListService getUserRoleListService() {
        if (this.userRoleListService == null) {
            this.userRoleListService = PentahoSystem.get(IUserRoleListService.class);
        }
        return this.userRoleListService;
    }
}

