/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ShowHelpDialog
extends Dialog {
    private String dialogTitle;
    private String url;
    private String header;
    private Browser wBrowser;
    private FormData fdBrowser;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private int headerHeight = 55;
    private int headerLabelPosition = 10;
    private LocationListener locationListener;

    public ShowHelpDialog(Shell parent, String dialogTitle, String url, String header) {
        super(parent, 0);
        this.dialogTitle = dialogTitle;
        this.header = header;
        this.url = url;
    }

    public ShowHelpDialog(Shell parent, String dialogTitle, String url, LocationListener locationListener) {
        this(parent, dialogTitle, url, "");
        this.locationListener = locationListener;
        this.headerHeight = 0;
    }

    protected Shell createShell(Shell parent) {
        return new Shell(parent, 3312);
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = this.createShell(parent);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.dialogTitle);
        if (this.headerHeight > 0) {
            Label wHeader = new Label((Composite)this.shell, 0);
            wHeader.setText(this.header);
            wHeader.setBackground(wHeader.getParent().getBackground());
            FontData[] fD = wHeader.getFont().getFontData();
            fD[0].setHeight(16);
            wHeader.setFont(new Font((Device)display, fD[0]));
            FormData fdHeader = new FormData();
            fdHeader.top = new FormAttachment(0, this.headerLabelPosition);
            fdHeader.left = new FormAttachment(0, 4);
            wHeader.setLayoutData((Object)fdHeader);
        }
        this.wBrowser = new Browser((Composite)this.shell, 0);
        this.props.setLook((Control)this.wBrowser);
        this.fdBrowser = new FormData();
        this.fdBrowser.left = new FormAttachment(0, 0);
        this.fdBrowser.top = new FormAttachment(0, this.headerHeight);
        this.fdBrowser.right = new FormAttachment(100, 0);
        this.fdBrowser.bottom = new FormAttachment(100, 0);
        this.wBrowser.setLayoutData((Object)this.fdBrowser);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowHelpDialog.this.ok();
            }
        });
        this.wBrowser.setUrl(this.url);
        if (this.locationListener != null) {
            this.wBrowser.addLocationListener(this.locationListener);
        }
        BaseStepDialog.setSize(this.shell, 800, 600, true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

