/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.events.SelectionListener;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.FieldDisabledListener;
import org.pentaho.di.ui.core.widget.TextVarButtonRenderCallback;

public class ColumnInfo {
    public static final int COLUMN_TYPE_NONE = 0;
    public static final int COLUMN_TYPE_TEXT = 1;
    public static final int COLUMN_TYPE_CCOMBO = 2;
    public static final int COLUMN_TYPE_BUTTON = 3;
    public static final int COLUMN_TYPE_ICON = 4;
    public static final int COLUMN_TYPE_FORMAT = 5;
    public static final int COLUMN_TYPE_TEXT_BUTTON = 6;
    private int type;
    private String name;
    private String[] combovals;
    private boolean numeric;
    private String tooltip;
    private int allignement;
    private boolean readonly;
    private String button_text;
    private boolean hide_negative;
    private int width = -1;
    private boolean autoResize = true;
    private ValueMetaInterface valueMeta;
    private SelectionListener selButton;
    private SelectionListener textVarButtonSelectionListener;
    private TextVarButtonRenderCallback renderTextVarButtonCallback;
    private FieldDisabledListener disabledListener;
    private boolean usingVariables;
    private boolean passwordField;
    private ComboValuesSelectionListener comboValuesSelectionListener;
    private int fieldTypeColumn;

    public ColumnInfo(String colname, int coltype) {
        this.name = colname;
        this.type = coltype;
        this.combovals = null;
        this.numeric = false;
        this.tooltip = null;
        this.allignement = 16384;
        this.readonly = false;
        this.hide_negative = false;
        this.valueMeta = new ValueMetaString(colname);
    }

    public ColumnInfo(String colname, int coltype, String[] combo) {
        this(colname, coltype);
        this.combovals = combo;
        this.numeric = false;
        this.tooltip = null;
        this.allignement = 16384;
        this.readonly = false;
        this.hide_negative = false;
        this.valueMeta = new ValueMetaString(colname);
    }

    public ColumnInfo(String colname, int coltype, boolean numeric) {
        this(colname, coltype);
        this.combovals = null;
        this.numeric = numeric;
        this.tooltip = null;
        this.allignement = 16384;
        this.readonly = false;
        this.hide_negative = false;
        this.valueMeta = numeric ? new ValueMetaInteger(colname) : new ValueMetaString(colname);
    }

    public ColumnInfo(String colname, int coltype, String[] combo, boolean ro) {
        this(colname, coltype, combo);
        this.readonly = ro;
    }

    public ColumnInfo(String colname, int coltype, boolean num, boolean ro) {
        this(colname, coltype, num);
        this.readonly = ro;
    }

    public ColumnInfo(String colname, int coltype, boolean num, boolean ro, int width) {
        this(colname, coltype, num);
        this.readonly = ro;
        this.width = width;
    }

    public ColumnInfo(String colname, int coltype, int fieldTypeColumn) {
        this(colname, coltype);
        this.fieldTypeColumn = fieldTypeColumn;
    }

    public String toString() {
        return this.name;
    }

    public void setToolTip(String tip) {
        this.tooltip = tip;
    }

    public void setReadOnly(boolean ro) {
        this.readonly = ro;
    }

    public void setAllignement(int allign) {
        this.allignement = allign;
    }

    public void setComboValues(String[] cv) {
        this.combovals = cv;
    }

    public void setButtonText(String bt) {
        this.button_text = bt;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String[] getComboValues() {
        String[] retval = this.combovals;
        return retval;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public int getAllignement() {
        return this.allignement;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public String getButtonText() {
        return this.button_text;
    }

    public void setSelectionAdapter(SelectionListener sb) {
        this.selButton = sb;
    }

    public SelectionListener getSelectionAdapter() {
        return this.selButton;
    }

    public void hideNegative() {
        this.hide_negative = true;
    }

    public void showNegative() {
        this.hide_negative = false;
    }

    public boolean isNegativeHidden() {
        return this.hide_negative;
    }

    public ValueMetaInterface getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(ValueMetaInterface valueMeta) {
        this.valueMeta = valueMeta;
    }

    public boolean isUsingVariables() {
        return this.usingVariables;
    }

    public void setUsingVariables(boolean usingVariables) {
        this.usingVariables = usingVariables;
    }

    public boolean isPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(boolean password) {
        this.passwordField = password;
    }

    public int getFieldTypeColumn() {
        return this.fieldTypeColumn;
    }

    public void setFieldTypeColumn(int fieldTypeColumn) {
        this.fieldTypeColumn = fieldTypeColumn;
    }

    public ComboValuesSelectionListener getComboValuesSelectionListener() {
        return this.comboValuesSelectionListener;
    }

    public void setComboValuesSelectionListener(ComboValuesSelectionListener comboValuesSelectionListener) {
        this.comboValuesSelectionListener = comboValuesSelectionListener;
    }

    public FieldDisabledListener getDisabledListener() {
        return this.disabledListener;
    }

    public void setDisabledListener(FieldDisabledListener disabledListener) {
        this.disabledListener = disabledListener;
    }

    public SelectionListener getTextVarButtonSelectionListener() {
        return this.textVarButtonSelectionListener;
    }

    public void setTextVarButtonSelectionListener(SelectionListener textVarButtonSelectionListener) {
        this.textVarButtonSelectionListener = textVarButtonSelectionListener;
    }

    public void setRenderTextVarButtonCallback(TextVarButtonRenderCallback callback) {
        this.renderTextVarButtonCallback = callback;
    }

    public boolean shouldRenderTextVarButton() {
        return this.renderTextVarButtonCallback == null || this.renderTextVarButtonCallback.shouldRenderButton();
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean resize) {
        this.autoResize = resize;
    }
}

