/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.SourceStore;

public class LocaleStore {
    private String locale;
    private Map<String, SourceStore> sourceMap;
    private String mainLocale;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private LogChannelInterface log;

    public LocaleStore(LogChannelInterface log, String locale, String mainLocale, Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.log = log;
        this.locale = locale;
        this.mainLocale = mainLocale;
        this.sourceMap = new HashMap<String, SourceStore>();
        this.sourcePackageOccurrences = sourcePackageOccurrences;
    }

    public void read(List<String> directories) throws KettleException {
        for (String sourceFolder : this.sourcePackageOccurrences.keySet()) {
            SourceStore sourceStore = new SourceStore(this.log, this.locale, sourceFolder, this.sourcePackageOccurrences);
            try {
                sourceStore.read(directories);
                this.sourceMap.put(sourceFolder, sourceStore);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getMainLocale() {
        return this.mainLocale;
    }

    public void setMainLocale(String mainLocale) {
        this.mainLocale = mainLocale;
    }

    public Map<String, SourceStore> getSourceMap() {
        return this.sourceMap;
    }
}

