/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.partition.dialog.PartitionSchemaDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIPartition;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIPartitions;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class PartitionsController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    protected BindingFactory bf = null;
    private Shell shell = null;
    private XulTree partitionsTable = null;
    private UIPartitions partitionList = new UIPartitions();
    private MainController mainController;
    private VariableSpace variableSpace = Variables.getADefaultVariableSpace();

    @Override
    public String getName() {
        return "partitionsController";
    }

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        this.repository = repository;
    }

    public void createBindings() {
        block2: {
            this.refreshPartitions();
            try {
                this.partitionsTable = (XulTree)this.document.getElementById("partitions-table");
                this.bf.setBindingType(Binding.Type.ONE_WAY);
                this.bf.createBinding((Object)this.partitionList, "children", (Object)this.partitionsTable, "elements", new BindingConvertor[0]).fireSourceChanged();
                this.bf.createBinding((Object)this.partitionsTable, "selectedItems", (Object)this, "enableButtons", new BindingConvertor[0]);
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected boolean doLazyInit() {
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
        try {
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
        }
        catch (XulException e) {
            return false;
        }
        this.enableButtons(true, false, false);
        this.bf = new SwtBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        if (this.bf != null) {
            this.createBindings();
        }
        return true;
    }

    public void setVariableSpace(VariableSpace variableSpace) {
        this.variableSpace = variableSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editPartition() {
        String partitionSchemaName = "";
        try {
            Collection partitions = this.partitionsTable.getSelectedItems();
            if (partitions != null && !partitions.isEmpty()) {
                PartitionSchema partitionSchema = ((UIPartition)((Object)partitions.toArray()[0])).getPartitionSchema();
                partitionSchemaName = partitionSchema.getName();
                ObjectId partitionId = this.repository.getPartitionSchemaID(partitionSchema.getName());
                if (partitionId == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.DoesNotExists.Message", (String[])new String[]{partitionSchemaName}));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    PartitionSchemaDialog partitionDialog = new PartitionSchemaDialog(this.shell, partitionSchema, this.repository.readDatabases(), this.variableSpace);
                    if (partitionDialog.open()) {
                        if (partitionSchema.getName() != null && !partitionSchema.getName().equals("")) {
                            this.repository.insertLogEntry(BaseMessages.getString(RepositoryExplorer.class, (String)"PartitionsController.Message.UpdatingPartition", (String[])new String[]{partitionSchema.getName()}));
                            this.repository.save((RepositoryElementInterface)partitionSchema, "Modification by user", null);
                            if (this.mainController != null && this.mainController.getSharedObjectSyncUtil() != null) {
                                this.mainController.getSharedObjectSyncUtil().synchronizePartitionSchemas(partitionSchema, partitionSchemaName);
                            }
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.InvalidName.Message", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.Title", (String[])new String[0]));
                            mb.open();
                        }
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.UnexpectedError.Message", (String[])new String[0]) + partitionSchemaName + "]", (Exception)((Object)e));
            }
        }
        finally {
            this.refreshPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPartition() {
        try {
            PartitionSchema partition = new PartitionSchema();
            PartitionSchemaDialog partitionDialog = new PartitionSchemaDialog(this.shell, partition, this.repository.readDatabases(), this.variableSpace);
            if (partitionDialog.open()) {
                ObjectId idPartition = this.repository.getPartitionSchemaID(partition.getName());
                if (idPartition == null) {
                    if (partition.getName() != null && !partition.getName().equals("")) {
                        this.repository.insertLogEntry(BaseMessages.getString(RepositoryExplorer.class, (String)"PartitionsController.Message.CreatingPartition", (String[])new String[]{partition.getName()}));
                        this.repository.save((RepositoryElementInterface)partition, "Creation of initial version", null);
                        if (this.mainController != null && this.mainController.getSharedObjectSyncUtil() != null) {
                            this.mainController.getSharedObjectSyncUtil().reloadTransformationRepositoryObjects(true);
                        }
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Edit.InvalidName.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Create.Title", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        finally {
            this.refreshPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartition() {
        String partitionSchemaName = "";
        try {
            Collection partitions = this.partitionsTable.getSelectedItems();
            if (partitions != null && !partitions.isEmpty()) {
                for (Object obj : partitions) {
                    if (obj == null || !(obj instanceof UIPartition)) continue;
                    UIPartition partition = (UIPartition)((Object)obj);
                    PartitionSchema partitionSchema = partition.getPartitionSchema();
                    partitionSchemaName = partitionSchema.getName();
                    ObjectId partitionId = this.repository.getPartitionSchemaID(partitionSchema.getName());
                    if (partitionId == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.DoesNotExists.Message", (String[])new String[]{partitionSchemaName}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Delete.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    this.repository.deletePartitionSchema(partitionId);
                    if (this.mainController == null || this.mainController.getSharedObjectSyncUtil() == null) continue;
                    this.mainController.getSharedObjectSyncUtil().deletePartitionSchema(partitionSchema);
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Delete.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Delete.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Partition.Delete.UnexpectedError.Message", (String[])new String[0]) + partitionSchemaName + "]", (Exception)((Object)e));
            }
        }
        finally {
            this.refreshPartitions();
        }
    }

    public void refreshPartitions() {
        if (this.repository != null) {
            final ArrayList tmpList = new ArrayList();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            ObjectId[] partitionIdList;
                            for (ObjectId partitionId : partitionIdList = PartitionsController.this.repository.getPartitionSchemaIDs(false)) {
                                PartitionSchema partition = PartitionsController.this.repository.loadPartitionSchema(partitionId, null);
                                tmpList.add(new UIPartition(partition));
                            }
                        }
                        catch (KettleException e) {
                            if (PartitionsController.this.mainController != null && PartitionsController.this.mainController.handleLostRepository(e)) break block3;
                            throw new RuntimeException(e);
                        }
                    }
                }
            };
            this.doWithBusyIndicator(r);
            this.partitionList.setChildren(tmpList);
        }
    }

    public void setEnableButtons(List<UIPartition> partitions) {
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (partitions != null && partitions.size() > 0) {
            enableRemove = true;
            if (partitions.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("partitions-new");
        XulButton bEdit = (XulButton)this.document.getElementById("partitions-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("partitions-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

