/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.jobexecutor;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorParameters;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobExecutorDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = JobExecutorMeta.class;
    private static int FIELD_DESCRIPTION = 1;
    private static int FIELD_NAME = 2;
    private JobExecutorMeta jobExecutorMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private JobMeta executorJobMeta = null;
    protected boolean jobModified;
    private ModifyListener lsMod;
    private Button wInheritAll;
    private TableView wJobExecutorParameters;
    private Label wlGroupSize;
    private TextVar wGroupSize;
    private Label wlGroupField;
    private CCombo wGroupField;
    private Label wlGroupTime;
    private TextVar wGroupTime;
    private Label wlExecutionResultTarget;
    private CCombo wExecutionResultTarget;
    private TableItem tiExecutionTimeField;
    private TableItem tiExecutionResultField;
    private TableItem tiExecutionNrErrorsField;
    private TableItem tiExecutionLinesReadField;
    private TableItem tiExecutionLinesWrittenField;
    private TableItem tiExecutionLinesInputField;
    private TableItem tiExecutionLinesOutputField;
    private TableItem tiExecutionLinesRejectedField;
    private TableItem tiExecutionLinesUpdatedField;
    private TableItem tiExecutionLinesDeletedField;
    private TableItem tiExecutionFilesRetrievedField;
    private TableItem tiExecutionExitStatusField;
    private TableItem tiExecutionLogTextField;
    private TableItem tiExecutionLogChannelIdField;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private ColumnInfo[] parameterColumns;
    private Label wlResultFilesTarget;
    private CCombo wResultFilesTarget;
    private Label wlResultFileNameField;
    private TextVar wResultFileNameField;
    private Label wlResultRowsTarget;
    private CCombo wResultRowsTarget;
    private Label wlResultFields;
    private TableView wResultRowsFields;
    private Button wGetParameters;

    public JobExecutorDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.jobExecutorMeta = (JobExecutorMeta)in;
        this.jobModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.jobExecutorMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobExecutorDialog.this.jobExecutorMeta.setChanged();
                JobExecutorDialog.this.setFlags();
            }
        };
        this.changed = this.jobExecutorMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Job.Label", (String[])new String[0]));
        FormData fdlJobformation = new FormData();
        fdlJobformation.left = new FormAttachment(0, 0);
        fdlJobformation.top = new FormAttachment((Control)spacer, 20);
        fdlJobformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlJobformation);
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdJobformation = new FormData();
        fdJobformation.left = new FormAttachment(0, 0);
        fdJobformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdJobformation.width = 350;
        this.wPath.setLayoutData(fdJobformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wPath, 5);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JobExecutorDialog.this.repository != null) {
                    JobExecutorDialog.this.selectRepositoryJob();
                } else {
                    JobExecutorDialog.this.selectFileJob();
                }
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addParametersTab();
        this.addExecutionResultTab();
        this.addRowGroupTab();
        this.addResultRowsTab();
        this.addResultFilesTab();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobExecutorDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobExecutorDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobExecutorDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wPath.addSelectionListener(this.lsDef);
        this.wResultFileNameField.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobExecutorDialog.this.cancel();
            }
        });
        JobExecutorDialog.setSize(this.shell, 620, 675);
        this.getData();
        this.jobExecutorMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "JOBEx.svg", 32, 32);
    }

    private void selectRepositoryJob() {
        RepositoryObject repositoryObject = DialogHelper.selectRepositoryObject("*.kjb", this.log);
        try {
            if (repositoryObject != null) {
                this.loadRepositoryJob(repositoryObject.getName(), repositoryObject.getRepositoryDirectory());
                String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), this.executorJobMeta.getRepositoryDirectory().getPath());
                String fullPath = (path.equals("/") ? "/" : path + "/") + this.executorJobMeta.getName();
                this.wPath.setText(fullPath);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryJob(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.executorJobMeta = this.repository.loadJob(this.transMeta.environmentSubstitute(transName), repdir, null, null);
        this.executorJobMeta.clearChanged();
    }

    private void selectFileJob() {
        String curFile = this.transMeta.environmentSubstitute(this.wPath.getText());
        FileObject root = null;
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_JOB_FILTER_EXT, Const.getJobFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fileName = file.getName().toString();
            if (fileName != null) {
                this.loadFileJob(fileName);
                if (parentFolder != null && fileName.startsWith(parentFolder)) {
                    fileName = fileName.replace(parentFolder, "${Internal.Entry.Current.Directory}");
                }
                this.wPath.setText(fileName);
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            }
        }
        catch (IOException | KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingJobformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingJobformation.DialogMessage", (String[])new String[0]), (Exception)e);
        }
    }

    private void loadFileJob(String fname) throws KettleException {
        this.executorJobMeta = new JobMeta(this.transMeta.environmentSubstitute(fname), this.repository);
        this.executorJobMeta.clearChanged();
    }

    private void loadJob() throws KettleException {
        String filename = this.wPath.getText();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.specificationMethod) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (!filename.endsWith(".kjb")) {
                    filename = filename + ".kjb";
                    this.wPath.setText(filename);
                }
                this.loadFileJob(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (filename.endsWith(".kjb")) {
                    filename = filename.replace(".kjb", "");
                    this.wPath.setText(filename);
                }
                String realJobname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realJobname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realJobname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Exception.UnableToFindRepositoryDirectory", (String[])new String[0]));
                }
                this.loadRepositoryJob(realJobname, repdir);
                break;
            }
        }
    }

    public void getData() {
        this.specificationMethod = this.jobExecutorMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.jobExecutorMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.jobExecutorMeta.getDirectoryPath(), (String)"") + "/" + Const.NVL((String)this.jobExecutorMeta.getJobName(), (String)"");
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.jobExecutorMeta.getJobObjectId();
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        try {
            Object[] prevSteps = this.transMeta.getStepNames();
            Arrays.sort(prevSteps);
            this.wExecutionResultTarget.setItems((String[])prevSteps);
            this.wResultFilesTarget.setItems((String[])prevSteps);
            this.wResultRowsTarget.setItems((String[])prevSteps);
            String[] inputFields = this.transMeta.getPrevStepFields(this.stepMeta).getFieldNames();
            this.parameterColumns[1].setComboValues(inputFields);
            this.wGroupField.setItems(inputFields);
        }
        catch (Exception e) {
            this.log.logError("couldn't get previous step list", (Throwable)e);
        }
        this.wGroupSize.setText(Const.NVL((String)this.jobExecutorMeta.getGroupSize(), (String)""));
        this.wGroupTime.setText(Const.NVL((String)this.jobExecutorMeta.getGroupTime(), (String)""));
        this.wGroupField.setText(Const.NVL((String)this.jobExecutorMeta.getGroupField(), (String)""));
        this.wExecutionResultTarget.setText(this.jobExecutorMeta.getExecutionResultTargetStepMeta() == null ? "" : this.jobExecutorMeta.getExecutionResultTargetStepMeta().getName());
        this.tiExecutionTimeField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionTimeField(), (String)""));
        this.tiExecutionResultField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionResultField(), (String)""));
        this.tiExecutionNrErrorsField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionNrErrorsField(), (String)""));
        this.tiExecutionLinesReadField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesReadField(), (String)""));
        this.tiExecutionLinesWrittenField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesWrittenField(), (String)""));
        this.tiExecutionLinesInputField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesInputField(), (String)""));
        this.tiExecutionLinesOutputField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesOutputField(), (String)""));
        this.tiExecutionLinesRejectedField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesRejectedField(), (String)""));
        this.tiExecutionLinesUpdatedField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesUpdatedField(), (String)""));
        this.tiExecutionLinesDeletedField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLinesDeletedField(), (String)""));
        this.tiExecutionFilesRetrievedField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionFilesRetrievedField(), (String)""));
        this.tiExecutionExitStatusField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionExitStatusField(), (String)""));
        this.tiExecutionLogTextField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLogTextField(), (String)""));
        this.tiExecutionLogChannelIdField.setText(FIELD_NAME, Const.NVL((String)this.jobExecutorMeta.getExecutionLogChannelIdField(), (String)""));
        this.wResultFilesTarget.setText(this.jobExecutorMeta.getResultFilesTargetStepMeta() == null ? "" : this.jobExecutorMeta.getResultFilesTargetStepMeta().getName());
        this.wResultFileNameField.setText(Const.NVL((String)this.jobExecutorMeta.getResultFilesFileNameField(), (String)""));
        this.wResultRowsTarget.setText(this.jobExecutorMeta.getResultRowsTargetStepMeta() == null ? "" : this.jobExecutorMeta.getResultRowsTargetStepMeta().getName());
        for (int i = 0; i < this.jobExecutorMeta.getResultRowsField().length; ++i) {
            TableItem item = new TableItem(this.wResultRowsFields.table, 0);
            item.setText(1, Const.NVL((String)this.jobExecutorMeta.getResultRowsField()[i], (String)""));
            item.setText(2, ValueMetaFactory.getValueMetaName((int)this.jobExecutorMeta.getResultRowsType()[i]));
            int length = this.jobExecutorMeta.getResultRowsLength()[i];
            item.setText(3, length < 0 ? "" : Integer.toString(length));
            int precision = this.jobExecutorMeta.getResultRowsPrecision()[i];
            item.setText(4, precision < 0 ? "" : Integer.toString(precision));
        }
        this.wResultRowsFields.removeEmptyRows();
        this.wResultRowsFields.setRowNums();
        this.wResultRowsFields.optWidth(true);
        this.wTabFolder.setSelection(0);
        try {
            this.loadJob();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void getByReferenceData(ObjectId jobObjectId) {
        try {
            RepositoryObject jobInf = this.repository.getObjectInformation(jobObjectId, RepositoryObjectType.JOB);
            String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), jobInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)jobInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void addParametersTab() {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        this.wGetParameters = new Button(wParametersComposite, 8);
        this.wGetParameters.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.GetParameters", (String[])new String[0]));
        this.props.setLook((Control)this.wGetParameters);
        FormData fdGetParameters = new FormData();
        fdGetParameters.bottom = new FormAttachment(100, 0);
        fdGetParameters.right = new FormAttachment(100, 0);
        this.wGetParameters.setLayoutData((Object)fdGetParameters);
        this.wGetParameters.setSelection(this.jobExecutorMeta.getParameters().isInheritingAllVariables());
        this.wGetParameters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutorDialog.this.getParametersFromJob(null);
            }
        });
        this.parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.column.Field", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.column.Input", (String[])new String[0]), 1, false, false)};
        this.parameterColumns[1].setUsingVariables(true);
        JobExecutorParameters parameters = this.jobExecutorMeta.getParameters();
        this.wJobExecutorParameters = new TableView((VariableSpace)this.transMeta, wParametersComposite, 67588, this.parameterColumns, parameters.getVariable().length, this.lsMod, this.props);
        this.props.setLook((Control)this.wJobExecutorParameters);
        FormData fdJobExecutors = new FormData();
        fdJobExecutors.left = new FormAttachment(0, 0);
        fdJobExecutors.right = new FormAttachment(100, 0);
        fdJobExecutors.top = new FormAttachment(0, 0);
        fdJobExecutors.bottom = new FormAttachment((Control)this.wGetParameters, -10);
        this.wJobExecutorParameters.setLayoutData(fdJobExecutors);
        this.wJobExecutorParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 33, 33, 33));
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = this.wJobExecutorParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getField()[i], (String)""));
            tableItem.setText(3, Const.NVL((String)parameters.getInput()[i], (String)""));
        }
        this.wJobExecutorParameters.setRowNums();
        this.wJobExecutorParameters.optWidth(true);
        this.wInheritAll = new Button(wParametersComposite, 32);
        this.wInheritAll.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)this.wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.top = new FormAttachment((Control)this.wJobExecutorParameters, 15);
        this.wInheritAll.setLayoutData((Object)fdInheritAll);
        this.wInheritAll.setSelection(this.jobExecutorMeta.getParameters().isInheritingAllVariables());
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
    }

    protected void getParametersFromJob(JobMeta inputJobMeta) {
        try {
            if (inputJobMeta == null) {
                this.loadJob();
                inputJobMeta = this.executorJobMeta;
            }
            String[] parameters = inputJobMeta.listParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i];
                String desc = inputJobMeta.getParameterDescription(name);
                TableItem item = new TableItem(this.wJobExecutorParameters.table, 0);
                item.setText(1, Const.NVL((String)name, (String)""));
                item.setText(3, Const.NVL((String)desc, (String)""));
            }
            this.wJobExecutorParameters.removeEmptyRows();
            this.wJobExecutorParameters.setRowNums();
            this.wJobExecutorParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingSpecifiedJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingSpecifiedJob.Message", (String[])new String[0]), e);
        }
    }

    private void addRowGroupTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.RowGroup.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.RowGroup.Tooltip", (String[])new String[0]));
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlGroupSize = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupSize);
        this.wlGroupSize.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.GroupSize.Label", (String[])new String[0]));
        FormData fdlGroupSize = new FormData();
        fdlGroupSize.top = new FormAttachment(0, 0);
        fdlGroupSize.left = new FormAttachment(0, 0);
        this.wlGroupSize.setLayoutData((Object)fdlGroupSize);
        this.wGroupSize = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupSize);
        this.wGroupSize.addModifyListener(this.lsMod);
        FormData fdGroupSize = new FormData();
        fdGroupSize.width = 250;
        fdGroupSize.top = new FormAttachment((Control)this.wlGroupSize, 5);
        fdGroupSize.left = new FormAttachment(0, 0);
        this.wGroupSize.setLayoutData(fdGroupSize);
        this.wlGroupField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupField);
        this.wlGroupField.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.GroupField.Label", (String[])new String[0]));
        FormData fdlGroupField = new FormData();
        fdlGroupField.top = new FormAttachment((Control)this.wGroupSize, 10);
        fdlGroupField.left = new FormAttachment(0, 0);
        this.wlGroupField.setLayoutData((Object)fdlGroupField);
        this.wGroupField = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupField);
        this.wGroupField.addModifyListener(this.lsMod);
        FormData fdGroupField = new FormData();
        fdGroupField.width = 250;
        fdGroupField.top = new FormAttachment((Control)this.wlGroupField, 5);
        fdGroupField.left = new FormAttachment(0, 0);
        this.wGroupField.setLayoutData((Object)fdGroupField);
        this.wlGroupTime = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupTime);
        this.wlGroupTime.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.GroupTime.Label", (String[])new String[0]));
        FormData fdlGroupTime = new FormData();
        fdlGroupTime.top = new FormAttachment((Control)this.wGroupField, 10);
        fdlGroupTime.left = new FormAttachment(0, 0);
        this.wlGroupTime.setLayoutData((Object)fdlGroupTime);
        this.wGroupTime = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupTime);
        this.wGroupTime.addModifyListener(this.lsMod);
        FormData fdGroupTime = new FormData();
        fdGroupTime.width = 250;
        fdGroupTime.top = new FormAttachment((Control)this.wlGroupTime, 5);
        fdGroupTime.left = new FormAttachment(0, 0);
        this.wGroupTime.setLayoutData(fdGroupTime);
        wTab.setControl((Control)wInputComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addExecutionResultTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionResults.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionResults.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlExecutionResultTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionResultTarget);
        this.wlExecutionResultTarget.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionResultTarget.Label", (String[])new String[0]));
        FormData fdlExecutionResultTarget = new FormData();
        fdlExecutionResultTarget.top = new FormAttachment(0, 0);
        fdlExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wlExecutionResultTarget.setLayoutData((Object)fdlExecutionResultTarget);
        this.wExecutionResultTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionResultTarget);
        this.wExecutionResultTarget.addModifyListener(this.lsMod);
        FormData fdExecutionResultTarget = new FormData();
        fdExecutionResultTarget.width = 250;
        fdExecutionResultTarget.top = new FormAttachment((Control)this.wlExecutionResultTarget, 5);
        fdExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wExecutionResultTarget.setLayoutData((Object)fdExecutionResultTarget);
        ColumnInfo[] executionResultColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorMeta.ExecutionResults.FieldDescription.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorMeta.ExecutionResults.FieldName.Label", (String[])new String[0]), 1, false, false)};
        executionResultColumns[1].setUsingVariables(true);
        TableView wExectionResults = new TableView((VariableSpace)this.transMeta, wInputComposite, 67588, executionResultColumns, 14, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wExectionResults);
        FormData fdExecutionResults = new FormData();
        fdExecutionResults.left = new FormAttachment(0);
        fdExecutionResults.right = new FormAttachment(100);
        fdExecutionResults.top = new FormAttachment((Control)this.wExecutionResultTarget, 10);
        fdExecutionResults.bottom = new FormAttachment(100);
        wExectionResults.setLayoutData(fdExecutionResults);
        wExectionResults.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        int index = 0;
        this.tiExecutionTimeField = wExectionResults.table.getItem(index++);
        this.tiExecutionResultField = wExectionResults.table.getItem(index++);
        this.tiExecutionNrErrorsField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesReadField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesWrittenField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesInputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesOutputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesRejectedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesUpdatedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesDeletedField = wExectionResults.table.getItem(index++);
        this.tiExecutionFilesRetrievedField = wExectionResults.table.getItem(index++);
        this.tiExecutionExitStatusField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogTextField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogChannelIdField = wExectionResults.table.getItem(index++);
        this.tiExecutionTimeField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionTimeField.Label", (String[])new String[0]));
        this.tiExecutionResultField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionResultField.Label", (String[])new String[0]));
        this.tiExecutionNrErrorsField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionNrErrorsField.Label", (String[])new String[0]));
        this.tiExecutionLinesReadField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesReadField.Label", (String[])new String[0]));
        this.tiExecutionLinesWrittenField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesWrittenField.Label", (String[])new String[0]));
        this.tiExecutionLinesInputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesInputField.Label", (String[])new String[0]));
        this.tiExecutionLinesOutputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesOutputField.Label", (String[])new String[0]));
        this.tiExecutionLinesRejectedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesRejectedField.Label", (String[])new String[0]));
        this.tiExecutionLinesUpdatedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesUpdatedField.Label", (String[])new String[0]));
        this.tiExecutionLinesDeletedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLinesDeletedField.Label", (String[])new String[0]));
        this.tiExecutionFilesRetrievedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionFilesRetrievedField.Label", (String[])new String[0]));
        this.tiExecutionExitStatusField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionExitStatusField.Label", (String[])new String[0]));
        this.tiExecutionLogTextField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLogTextField.Label", (String[])new String[0]));
        this.tiExecutionLogChannelIdField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ExecutionLogChannelIdField.Label", (String[])new String[0]));
        this.wJobExecutorParameters.setRowNums();
        this.wJobExecutorParameters.optWidth(true);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultFilesTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultFiles.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultFiles.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultFilesTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFilesTarget);
        this.wlResultFilesTarget.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultFilesTarget.Label", (String[])new String[0]));
        FormData fdlResultFilesTarget = new FormData();
        fdlResultFilesTarget.top = new FormAttachment(0, 0);
        fdlResultFilesTarget.left = new FormAttachment(0, 0);
        this.wlResultFilesTarget.setLayoutData((Object)fdlResultFilesTarget);
        this.wResultFilesTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFilesTarget);
        this.wResultFilesTarget.addModifyListener(this.lsMod);
        FormData fdResultFilesTarget = new FormData();
        fdResultFilesTarget.width = 250;
        fdResultFilesTarget.top = new FormAttachment((Control)this.wlResultFilesTarget, 5);
        fdResultFilesTarget.left = new FormAttachment(0, 0);
        this.wResultFilesTarget.setLayoutData((Object)fdResultFilesTarget);
        this.wlResultFileNameField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFileNameField);
        this.wlResultFileNameField.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultFileNameField.Label", (String[])new String[0]));
        FormData fdlResultFileNameField = new FormData();
        fdlResultFileNameField.top = new FormAttachment((Control)this.wResultFilesTarget, 10);
        fdlResultFileNameField.left = new FormAttachment(0, 0);
        this.wlResultFileNameField.setLayoutData((Object)fdlResultFileNameField);
        this.wResultFileNameField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFileNameField);
        this.wResultFileNameField.addModifyListener(this.lsMod);
        FormData fdResultFileNameField = new FormData();
        fdResultFileNameField.width = 250;
        fdResultFileNameField.top = new FormAttachment((Control)this.wlResultFileNameField, 5);
        fdResultFileNameField.left = new FormAttachment(0, 0);
        this.wResultFileNameField.setLayoutData(fdResultFileNameField);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultRowsTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultRows.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultRows.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultRowsTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultRowsTarget);
        this.wlResultRowsTarget.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultRowsTarget.Label", (String[])new String[0]));
        FormData fdlResultRowsTarget = new FormData();
        fdlResultRowsTarget.top = new FormAttachment(0, 0);
        fdlResultRowsTarget.left = new FormAttachment(0, 0);
        this.wlResultRowsTarget.setLayoutData((Object)fdlResultRowsTarget);
        this.wResultRowsTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultRowsTarget);
        this.wResultRowsTarget.addModifyListener(this.lsMod);
        FormData fdResultRowsTarget = new FormData();
        fdResultRowsTarget.width = 250;
        fdResultRowsTarget.top = new FormAttachment((Control)this.wlResultRowsTarget, 5);
        fdResultRowsTarget.left = new FormAttachment(0, 0);
        this.wResultRowsTarget.setLayoutData((Object)fdResultRowsTarget);
        this.wlResultFields = new Label(wInputComposite, 0);
        this.wlResultFields.setText(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ResultFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResultFields);
        FormData fdlResultFields = new FormData();
        fdlResultFields.left = new FormAttachment(0, 0);
        fdlResultFields.top = new FormAttachment((Control)this.wResultRowsTarget, 10);
        this.wlResultFields.setLayoutData((Object)fdlResultFields);
        int nrRows = this.jobExecutorMeta.getResultRowsField() != null ? this.jobExecutorMeta.getResultRowsField().length : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ColumnInfo.Field", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutorDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wResultRowsFields = new TableView((VariableSpace)this.transMeta, wInputComposite, 68354, ciResultFields, nrRows, false, this.lsMod, this.props, false);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment((Control)this.wlResultFields, 5);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, 0);
        this.wResultRowsFields.setLayoutData(fdResultFields);
        this.wResultRowsFields.getTable().addListener(11, (Listener)new ColumnsResizer(0, 25, 25, 25, 25));
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void setFlags() {
        if (this.wlGroupSize == null || this.wlGroupSize == null || this.wlGroupField == null || this.wGroupField == null || this.wlGroupTime == null || this.wGroupTime == null) {
            return;
        }
        boolean enableSize = Const.toInt((String)this.transMeta.environmentSubstitute(this.wGroupSize.getText()), (int)-1) >= 0;
        boolean enableField = !Utils.isEmpty((CharSequence)this.wGroupField.getText());
        this.wlGroupSize.setEnabled(true);
        this.wGroupSize.setEnabled(true);
        this.wlGroupField.setEnabled(!enableSize);
        this.wGroupField.setEnabled(!enableSize);
        this.wlGroupTime.setEnabled(!enableSize && !enableField);
        this.wGroupTime.setEnabled(!enableSize && !enableField);
    }

    private void cancel() {
        this.stepname = null;
        this.jobExecutorMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadJob();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingSpecifiedJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobExecutorDialog.ErrorLoadingSpecifiedJob.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.jobExecutorMeta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                this.jobExecutorMeta.setFileName(this.wPath.getText());
                this.jobExecutorMeta.setDirectoryPath(null);
                this.jobExecutorMeta.setJobName(null);
                this.jobExecutorMeta.setJobObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                this.jobExecutorMeta.setDirectoryPath(directory);
                this.jobExecutorMeta.setJobName(transName);
                this.jobExecutorMeta.setFileName(null);
                this.jobExecutorMeta.setJobObjectId(null);
                break;
            }
        }
        this.collectInformation();
        this.jobExecutorMeta.searchInfoAndTargetSteps(this.transMeta.getSteps());
        this.jobExecutorMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        JobExecutorParameters parameters = this.jobExecutorMeta.getParameters();
        int nrLines = this.wJobExecutorParameters.nrNonEmpty();
        String[] variables = new String[nrLines];
        String[] fields = new String[nrLines];
        String[] input = new String[nrLines];
        parameters.setVariable(variables);
        parameters.setField(fields);
        parameters.setInput(input);
        for (int i = 0; i < nrLines; ++i) {
            TableItem item = this.wJobExecutorParameters.getNonEmpty(i);
            variables[i] = item.getText(1);
            fields[i] = item.getText(2);
            input[i] = item.getText(3);
        }
        parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        this.jobExecutorMeta.setGroupSize(this.wGroupSize.getText());
        this.jobExecutorMeta.setGroupField(this.wGroupField.getText());
        this.jobExecutorMeta.setGroupTime(this.wGroupTime.getText());
        this.jobExecutorMeta.setExecutionResultTargetStep(this.wExecutionResultTarget.getText());
        this.jobExecutorMeta.setExecutionResultTargetStepMeta(this.transMeta.findStep(this.wExecutionResultTarget.getText()));
        this.jobExecutorMeta.setExecutionTimeField(this.tiExecutionTimeField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionResultField(this.tiExecutionResultField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionNrErrorsField(this.tiExecutionNrErrorsField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesReadField(this.tiExecutionLinesReadField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesWrittenField(this.tiExecutionLinesWrittenField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesInputField(this.tiExecutionLinesInputField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesOutputField(this.tiExecutionLinesOutputField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesRejectedField(this.tiExecutionLinesRejectedField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesUpdatedField(this.tiExecutionLinesUpdatedField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLinesDeletedField(this.tiExecutionLinesDeletedField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionFilesRetrievedField(this.tiExecutionFilesRetrievedField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionExitStatusField(this.tiExecutionExitStatusField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLogTextField(this.tiExecutionLogTextField.getText(FIELD_NAME));
        this.jobExecutorMeta.setExecutionLogChannelIdField(this.tiExecutionLogChannelIdField.getText(FIELD_NAME));
        this.jobExecutorMeta.setResultFilesTargetStep(this.wResultFilesTarget.getText());
        this.jobExecutorMeta.setResultFilesTargetStepMeta(this.transMeta.findStep(this.wResultFilesTarget.getText()));
        this.jobExecutorMeta.setResultFilesFileNameField(this.wResultFileNameField.getText());
        this.jobExecutorMeta.setResultRowsTargetStep(this.wResultRowsTarget.getText());
        this.jobExecutorMeta.setResultRowsTargetStepMeta(this.transMeta.findStep(this.wResultRowsTarget.getText()));
        int nrFields = this.wResultRowsFields.nrNonEmpty();
        this.jobExecutorMeta.setResultRowsField(new String[nrFields]);
        this.jobExecutorMeta.setResultRowsType(new int[nrFields]);
        this.jobExecutorMeta.setResultRowsLength(new int[nrFields]);
        this.jobExecutorMeta.setResultRowsPrecision(new int[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wResultRowsFields.getNonEmpty(i);
            this.jobExecutorMeta.getResultRowsField()[i] = item.getText(1);
            this.jobExecutorMeta.getResultRowsType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            this.jobExecutorMeta.getResultRowsLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.jobExecutorMeta.getResultRowsPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
    }
}

