/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;

public class AbortFunction
extends ConfigurableFunction<Row, Row> {
    private static final String STEP_META = "AbortFunction-stepMeta";
    private static final String METRICS_ACCUM = "AbortFunction-metricsAccumulator";
    private static final String LOGGER = "AbortFunction-logger";
    private static final String LOG_ROWS = "AbortFunction-logRows";
    private static final String SEPARATOR = ":  ";
    private transient FunctionLogger logger;
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient boolean logRows;

    public AbortFunction() {
    }

    public AbortFunction(StepMeta stepMeta, SparkOperation.Subscriber subscriber, boolean logRows) {
        this.stepMeta = stepMeta;
        this.logRows = logRows;
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        AccumulatorV2 accum = (AccumulatorV2)subscriber.getAccumulators().get("op_logging");
        this.logger = accum != null && accum instanceof CollectionAccumulator ? new FunctionLogger((CollectionAccumulator)accum) : FunctionLogger.EMPTY;
    }

    @VisibleForTesting
    AbortFunction(StepMeta stepMeta, SparkOperation.Subscriber subscriber, boolean logRows, FunctionLogger logger) {
        this.stepMeta = stepMeta;
        this.logRows = logRows;
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        this.logger = logger;
    }

    public Row call(Row row) {
        this.metricsAccumulator.addRowIn();
        if (this.logRows) {
            this.logger.basic(this.stepMeta.getName() + SEPARATOR + row.toString());
        }
        this.metricsAccumulator.addRowOut();
        return row;
    }

    public Map<String, Serializable> getConfig() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(STEP_META, (Serializable)new SerializableStepMeta(this.stepMeta));
        map.put(METRICS_ACCUM, (Serializable)this.metricsAccumulator);
        map.put(LOGGER, (Serializable)this.logger);
        map.put(LOG_ROWS, Boolean.valueOf(this.logRows));
        return map;
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "AbortFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                break;
            }
            case "AbortFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
                break;
            }
            case "AbortFunction-logger": {
                this.logger = (FunctionLogger)value;
                break;
            }
            case "AbortFunction-logRows": {
                this.logRows = (Boolean)value;
            }
        }
    }
}

