/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;

public class AvroConverter {
    private static final Class<?> PKG = AvroConverter.class;
    private static final String ERROR_EXPECTING_VALUE = "AvroConverter.ErrorExpectingValue";
    private static final String ERROR_CAN_NOT_CONVERT_TYPES = "AvroConverter.ErrorCanNotConvertTypes";
    private static final String ERROR_TRYING_CONVERT_TYPES = "AvroConverter.ErrorTryingConvertTypes";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TYPE_DOUBLE = "Double";
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_BYTE_BUFFER = "ByteBuffer";

    public static Object convertFromSourceToTargetDataType(int sourceValueMetaInterface, int targetValueMetaInterface, Object value) {
        if (value == null) {
            return null;
        }
        switch (sourceValueMetaInterface) {
            case 10: {
                return AvroConverter.convertFromInetMetaInterface(targetValueMetaInterface, value);
            }
            case 2: {
                return AvroConverter.convertFromStringMetaInterface(targetValueMetaInterface, value);
            }
            case 5: {
                return AvroConverter.convertFromIntegerMetaInterface(targetValueMetaInterface, value);
            }
            case 1: {
                return AvroConverter.convertFromNumberMetaInterface(targetValueMetaInterface, value);
            }
            case 6: {
                return AvroConverter.convertFromBigNumberMetaInterface(targetValueMetaInterface, value);
            }
            case 9: {
                return AvroConverter.convertFromTimestampMetaInterface(targetValueMetaInterface, value);
            }
            case 3: {
                return AvroConverter.convertFromDateMetaInterface(targetValueMetaInterface, value);
            }
            case 4: {
                return AvroConverter.convertFromBooleanMetaInterface(targetValueMetaInterface, value);
            }
            case 8: {
                return AvroConverter.convertFromBinaryMetaInterface(targetValueMetaInterface, value);
            }
        }
        return value;
    }

    protected static Object convertFromStringMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        SimpleDateFormat datePattern = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        SimpleDateFormat timePattern = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2).toLowerCase(), value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    if (value == null) break;
                    try {
                        returnVal = InetAddress.getByName(value.toString());
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 2: {
                    returnVal = value;
                    break;
                }
                case 5: {
                    returnVal = Long.parseLong((String)value);
                    break;
                }
                case 1: {
                    returnVal = Double.parseDouble((String)value);
                    break;
                }
                case 6: {
                    Double doubleValue = Double.parseDouble((String)value);
                    returnVal = new BigDecimal(doubleValue);
                    break;
                }
                case 9: {
                    returnVal = new Timestamp(timePattern.parse((String)value).getTime());
                    break;
                }
                case 3: {
                    returnVal = datePattern.parse((String)value);
                    break;
                }
                case 4: {
                    returnVal = Boolean.parseBoolean((String)value);
                    break;
                }
                case 8: {
                    returnVal = ((String)value).getBytes();
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2).toLowerCase(), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromDateMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Integer)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
        }
        try {
            LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(((Integer)value).intValue());
            Date dateValue = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    SimpleDateFormat datePattern = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
                    returnVal = datePattern.format(dateValue);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)1), value.getClass(), value}));
                }
                case 6: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)6), value.getClass(), value}));
                }
                case 9: {
                    returnVal = new Timestamp(dateValue.getTime());
                    break;
                }
                case 3: {
                    returnVal = dateValue;
                    break;
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)3), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromNumberMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Double)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{TYPE_DOUBLE, value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    returnVal = value;
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal((Double)value);
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)1), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromBooleanMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Boolean)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2).toLowerCase(), value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    returnVal = Boolean.toString((Boolean)value);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)1), value.getClass(), value}));
                }
                case 6: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)6), value.getClass(), value}));
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    returnVal = value;
                    break;
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)4), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromIntegerMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Long)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{TYPE_LONG, value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    returnVal = Long.toString((Long)value);
                    break;
                }
                case 5: {
                    returnVal = (Long)value;
                    break;
                }
                case 1: {
                    returnVal = ((Long)value).doubleValue();
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal(((Long)value).doubleValue());
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)5), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromBigNumberMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Double)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{TYPE_DOUBLE, value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    returnVal = ((Double)value).toString();
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    returnVal = (Double)value;
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal((Double)value);
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)6), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromTimestampMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Long)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2).toLowerCase(), value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    Date dateValue = new Date((Long)value);
                    SimpleDateFormat timestampPattern = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
                    returnVal = timestampPattern.format(dateValue);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)1), value.getClass(), value}));
                }
                case 6: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)6), value.getClass(), value}));
                }
                case 9: {
                    returnVal = new Timestamp((Long)value);
                    break;
                }
                case 3: {
                    returnVal = new Date((Long)value);
                    break;
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)9), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromInetMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2).toLowerCase(), value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    try {
                        returnVal = InetAddress.getByName(value.toString());
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 2: {
                    try {
                        returnVal = InetAddress.getByName((String)value).toString();
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)1), value.getClass(), value}));
                }
                case 6: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)6), value.getClass(), value}));
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)10), ValueMetaInterface.getTypeDescription((int)8), value.getClass(), value}));
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object convertFromBinaryMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof byte[])) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_EXPECTING_VALUE, (Object[])new Object[]{TYPE_BYTE_BUFFER, value.getClass(), value}));
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)10), value.getClass(), value}));
                }
                case 2: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)2), value.getClass(), value}));
                }
                case 5: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)5), value.getClass(), value}));
                }
                case 1: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)1), value.getClass(), value}));
                }
                case 6: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)6), value.getClass(), value}));
                }
                case 9: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)9), value.getClass(), value}));
                }
                case 3: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)3), value.getClass(), value}));
                }
                case 4: {
                    return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_CAN_NOT_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)8), ValueMetaInterface.getTypeDescription((int)4), value.getClass(), value}));
                }
                case 8: {
                    if (value instanceof byte[]) {
                        return value;
                    }
                    returnVal = ((ByteBuffer)value).array();
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError(BaseMessages.getString(PKG, (String)ERROR_TRYING_CONVERT_TYPES, (Object[])new Object[]{ValueMetaInterface.getTypeDescription((int)2), value, e.getClass(), e.getMessage()}), e);
        }
        return returnVal;
    }

    protected static Object handleConversionError(String errorMessage) {
        return AvroConverter.handleConversionError(errorMessage, null);
    }

    protected static Object handleConversionError(String errorMessage, Exception e) {
        return null;
    }
}

