/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.engine.spark.util.Util;

public class RowToSparkDatasetConverter {
    public static Dataset<Row> convert(JavaRDD<org.pentaho.di.engine.api.model.Row> input, RowMetaInterface rowMeta, String stepID, MetricsAccumulator metricsAccumulator) {
        SparkSession spark = Util.getSparkSession();
        StructType schema = new StructTypeMapper(rowMeta).schema();
        JavaRDD sparkRDD = input.map((Function)new KettleToSparkRowFunction(rowMeta, metricsAccumulator).asRegisteredFunction(stepID));
        return spark.createDataFrame(sparkRDD, schema);
    }

    public static Dataset<Row> convert(StructType schema, JavaRDD<org.pentaho.di.engine.api.model.Row> input, RowMetaInterface rowMeta, String stepID, MetricsAccumulator metricsAccumulator) {
        SparkSession spark = Util.getSparkSession();
        JavaRDD sparkRDD = input.map((Function)new KettleToSparkRowFunction(rowMeta, metricsAccumulator).asRegisteredFunction(stepID));
        return spark.createDataFrame(sparkRDD, schema);
    }
}

