/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import scala.Tuple2;

public class TupleToKettleRowFunction
extends ConfigurableFunction<Iterator<Tuple2>, Iterator<Row>>
implements FlatMapFunction<Iterator<Tuple2>, Row> {
    private static final long serialVersionUID = -6483887919649893073L;
    private transient StepMeta stepMeta;
    private MetricsAccumulator metricsAccumulator;

    public TupleToKettleRowFunction() {
    }

    public TupleToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
    }

    public Iterator<Row> call(final Iterator<Tuple2> messageIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return messageIterator.hasNext();
            }

            @Override
            public Row next() {
                TupleToKettleRowFunction.this.metricsAccumulator.addRowIn();
                return TupleToKettleRowFunction.this.toKettleRow((Tuple2<String, String>)((Tuple2)messageIterator.next()), rowMeta);
            }
        };
    }

    private Row toKettleRow(Tuple2<String, String> message, RowMetaInterface rowMeta) {
        Object[] values = new Object[]{message._2(), message._1()};
        return new KettleRow(rowMeta, values);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)MetricsAccumulator.class.getName(), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, MetricsAccumulator.class.getName())) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }
}

