/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.AbortFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class AbortSparkOperation
extends BaseSparkOperation {
    private static final Class<?> PKG = AbortSparkOperation.class;
    private static final String ROW_CAUSING_ABORT = "AbortSparkOperation.RowCausingAbort";
    private static final String ABORT_REACHED = "AbortSparkOperation.AbortReached";
    private final JavaSparkContext sparkContext;
    private final SparkEngineContext executionContext;
    private final StepMeta stepMeta;
    private final boolean logRows;
    private final boolean abortWithError;
    private final int rowThreshold;
    private final String message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    AbortSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.sparkContext = sparkContext;
        this.executionContext = (SparkEngineContext)executionContext;
        this.stepMeta = stepMeta;
        StepMetaInterface abortMetaObj = stepMeta.getStepMetaInterface();
        boolean logRows = false;
        boolean abortWithError = true;
        int rowThreshold = 0;
        String message = "IN ERROR Check Daemon Log.";
        try {
            logRows = AbortSparkOperation.invokeMethod(abortMetaObj, "isAlwaysLogRows", null, Boolean.class);
            rowThreshold = AbortSparkOperation.invokeMethod(abortMetaObj, "getRowThreshold", null, Integer.class);
            abortWithError = AbortSparkOperation.invokeMethod(abortMetaObj, "isAbortWithError", null, Boolean.class);
            message = AbortSparkOperation.invokeMethod(abortMetaObj, "getMessage", null, String.class);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            this.logRows = logRows;
            this.abortWithError = abortWithError;
            this.rowThreshold = rowThreshold;
            this.message = message;
        }
    }

    private static <T> T invokeMethod(Object clsObj, String methodName, Object[] inputParameters, Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NullPointerException {
        Class<?> cls = clsObj.getClass();
        Method method = cls.getMethod(methodName, new Class[0]);
        Object obj = method.invoke(clsObj, inputParameters);
        T result = null;
        if (obj != null) {
            if (clazz != obj.getClass()) {
                Object[] params = new Object[]{obj};
                method = clazz.getMethod("valueOf", obj.getClass());
                obj = method.invoke(clazz, params);
                result = clazz.cast(obj);
            } else {
                result = clazz.cast(obj);
            }
        } else {
            String errMsg = cls.getName() + ":" + methodName + " is returning null and it is not allowed to return null.";
            throw new NullPointerException(errMsg);
        }
        return result;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(AbortSparkOperation::new, new Supplier[]{AbortFunction::new});
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        subscriber.setOutput(CompletableFuture.supplyAsync(() -> this.retrieveAbortRows(subscriber), arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    private JavaRDD<Row> retrieveAbortRows(SparkOperation.Subscriber subscriber) {
        Preconditions.checkArgument((this.rowThreshold >= 0 ? 1 : 0) != 0);
        MetricsAccumulator metricsAccumulator = subscriber.getMetricsAccumulator();
        JavaRDD output = subscriber.getInput().orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD()).map((Function)new AbortFunction(this.stepMeta, subscriber, this.logRows).asRegisteredFunction(this.stepMeta.getStepID()));
        List rows = output.take(this.rowThreshold + 1);
        if (rows.size() > this.rowThreshold) {
            subscriber.getLogger().error(BaseMessages.getString(PKG, (String)ROW_CAUSING_ABORT, (Object[])new Object[]{this.rowThreshold, rows.get(rows.size() - 1)}));
            subscriber.getLogger().error(this.message);
            if (this.abortWithError) {
                metricsAccumulator.addRowError();
                subscriber.updateStatus(Status.FAILED, Optional.ofNullable(this.message).orElse(BaseMessages.getString(PKG, (String)ABORT_REACHED, (String[])new String[0])));
            } else {
                subscriber.updateStatus(Status.FINISHED, this.message);
                this.executionContext.stopTransformation();
            }
        }
        return this.sparkContext.parallelize(rows);
    }
}

