/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.ops.FileInputResolver;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;

public class FileInputSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = 6935963394687169493L;
    private static final Class<?> PKG = FileInputSparkOperation.class;
    private static final String NO_SEPARATOR_DEFINED = "FileInputSparkOperation.NoSeparatorDefined";
    private static final String FAIL_FAST_MODE = "FAILFAST";
    private static final String DROP_MALFORMED_MODE = "DROPMALFORMED";
    private static final String COMMA = ",";
    private static final String CSV = "CSV";
    private static final String CSV_FORMAT = "org.apache.spark.csv";
    private static final String DELIMITER = "delimiter";
    private static final String HEADER = "header";
    private static final String QUOTE = "quote";
    private static final String ESCAPE = "escape";
    private static final String CHARSET = "charset";
    private static final String MODE = "mode";
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final TextFileInputMeta fileMeta;
    private MetricsAccumulator metricsAccumulator;
    private final Supplier<String[]> fileListSupplier = Suppliers.memoize(this::getFileInputList);

    public FileInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
    }

    FileInputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (TextFileInputMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, TextFileInputMeta.class);
        this.sparkContext = sparkContext;
    }

    private String[] getFileInputList() {
        List<String> files = FileInputResolver.getFiles((VariableSpace)this.transMeta, (BaseFileInputMeta)this.fileMeta, this.sparkContext);
        return files.toArray(new String[files.size()]);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(FileInputSparkOperation::new, new java.util.function.Supplier[]{FileInputContentFunction::new, SparkToKettleRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        java.util.function.Supplier<JavaRDD> readAction = () -> this.loadDefaultAction(subscriber);
        subscriber.setOutput(CompletableFuture.supplyAsync(readAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    private JavaRDD<Row> loadDefaultActionCsv(String[] files) throws RuntimeException {
        if (this.fileMeta.content.separator == null || this.fileMeta.content.separator.isEmpty()) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)NO_SEPARATOR_DEFINED, (String[])new String[0]));
        }
        SparkSession sparkSession = Util.getSparkSession();
        Dataset dataset = sparkSession.read().format(CSV_FORMAT).option(DELIMITER, this.environmentSubstitute(this.fileMeta.content.separator)).option(HEADER, this.fileMeta.content.header).option(QUOTE, this.environmentSubstitute(this.fileMeta.content.enclosure)).option(ESCAPE, this.environmentSubstitute(this.fileMeta.content.escapeCharacter)).option(CHARSET, this.fileMeta.content.encoding == null ? Charset.defaultCharset().name() : this.fileMeta.content.encoding).option(MODE, this.fileMeta.errorHandling.errorIgnored ? DROP_MALFORMED_MODE : FAIL_FAST_MODE).schema(new StructTypeMapper(MetaHelper.getRowMeta((TransMeta)this.transMeta, (String)this.getId())).schemaForRead()).csv(files);
        this.metricsAccumulator.setCountRowIn(false);
        return dataset.toJavaRDD().mapPartitions(new SparkToKettleRowFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator).asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID()).toFlatMap());
    }

    private JavaRDD<Row> loadDefaultActionFixedWidth(String[] files) {
        JavaRDD fileRdd = this.sparkContext.textFile(String.join((CharSequence)COMMA, files));
        return fileRdd.mapPartitions(new FileInputContentFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator).asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID()).toFlatMap());
    }

    private JavaRDD<Row> loadDefaultAction(SparkOperation.Subscriber subscriber) {
        try {
            String[] files = this.fileMeta.isAcceptingFilenames() ? this.acceptedFilenames(subscriber) : (String[])this.fileListSupplier.get();
            if (CSV.equals(this.fileMeta.content.fileType)) {
                return this.loadDefaultActionCsv(files);
            }
            return this.loadDefaultActionFixedWidth(files);
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
            return null;
        }
    }

    private String[] acceptedFilenames(SparkOperation.Subscriber subscriber) {
        RowMetaInterface rowMeta = MetaHelper.getRowMeta((TransMeta)this.transMeta, (String)this.fileMeta.getAcceptingStepName());
        int index = rowMeta.indexOfValue(this.fileMeta.getAcceptingField());
        SparkOperation operation = subscriber.getInputs().keySet().stream().filter(op -> op.getId().equals(this.fileMeta.getAcceptingStepName())).findFirst().get();
        List rows = ((JavaRDD)subscriber.getInputs().get(operation)).collect();
        ArrayList<String> results = new ArrayList<String>();
        for (Row row : rows) {
            results.add(row.getObjects()[index].toString().trim());
        }
        return results.toArray(new String[rows.size()]);
    }

    private String environmentSubstitute(String s) {
        return this.transMeta.environmentSubstitute(s);
    }
}

