/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.KettleFilterFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;

public class FilterSparkOperation
extends BaseSparkOperation {
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String NONE = "NONE";
    private final TransMeta transMeta;
    private final FilterRowsMeta filterMeta;
    private final JavaSparkContext sparkContext;
    private final ExecutionContext executionContext;

    FilterSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.filterMeta = (FilterRowsMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, FilterRowsMeta.class);
        this.sparkContext = sparkContext;
        this.executionContext = executionContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(FilterSparkOperation::new, new Supplier[]{KettleFilterFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        JavaRDD input = subscriber.getInput().orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        Optional<String> trueStepname = Optional.ofNullable(this.filterMeta.getTrueStepname());
        Optional<String> falseStepname = Optional.ofNullable(this.filterMeta.getFalseStepname());
        Map<String, List<SparkOperation>> outputGroups = subscriber.getExpectedOutputs().stream().collect(Collectors.groupingBy(sparkOperation -> {
            Optional<String> logicalId = sparkOperation.getLogicalOperation().map(ModelElement::getId);
            if (trueStepname.isPresent() && logicalId.equals(trueStepname)) {
                return TRUE;
            }
            if (falseStepname.isPresent() && logicalId.equals(falseStepname)) {
                return FALSE;
            }
            return NONE;
        }));
        StepMeta stepMeta = this.transMeta.findStep(this.getId());
        JavaRDD accepted = input.filter((Function)new KettleFilterFunction(stepMeta, true, subscriber.getMetricsAccumulator()).asRegisteredFunction(stepMeta.getStepID()));
        JavaRDD rejected = input.filter((Function)new KettleFilterFunction(stepMeta, false, MetricsAccumulator.empty()).asRegisteredFunction(stepMeta.getStepID()));
        if (Stream.of(TRUE, FALSE).anyMatch(outputGroups::containsKey)) {
            outputGroups.getOrDefault(TRUE, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, accepted));
            outputGroups.getOrDefault(FALSE, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, rejected));
            outputGroups.getOrDefault(NONE, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, this.sparkContext.emptyRDD()));
        } else {
            subscriber.setOutput(accepted);
        }
    }
}

