/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.di.core.osgi.api.NamedClusterOsgi;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkStreamingOperation;
import org.pentaho.di.engine.spark.impl.functions.KafkaToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.functions.WaitForeverFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;

public class KafkaSparkOperation
extends BaseSparkStreamingOperation {
    protected final transient KafkaConsumerInputMeta kafkaConsumerMeta;
    private static final String SPARK_PROP_PREFIX = "spark.";

    public KafkaSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation, transformation, stepMeta, sparkContext, executionContext);
        this.kafkaConsumerMeta = (KafkaConsumerInputMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, KafkaConsumerInputMeta.class);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(KafkaSparkOperation::new, new Supplier[]{KafkaToKettleRowFunction::new, WaitForeverFunction::new});
    }

    protected JavaInputDStream buildStream() {
        HashMap<String, Object> kafkaParams = new HashMap<String, Object>();
        SparkConf sparkConf = this.sparkContext.sc().conf();
        this.kafkaConsumerMeta.getConfig().entrySet().forEach(entry -> {
            String propertyValue = this.transMeta.environmentSubstitute((String)entry.getValue());
            if (((String)entry.getKey()).startsWith(SPARK_PROP_PREFIX)) {
                sparkConf.set((String)entry.getKey(), propertyValue);
            } else {
                kafkaParams.put((String)entry.getKey(), propertyValue);
            }
        });
        if (KafkaConsumerInputMeta.ConnectionType.CLUSTER.equals((Object)this.kafkaConsumerMeta.getConnectionType())) {
            NamedClusterOsgi namedCluster = this.transMeta.getNamedClusterServiceOsgi().getNamedClusterByName(this.transMeta.environmentSubstitute(this.kafkaConsumerMeta.getClusterName()), (IMetaStore)this.transMeta.getEmbeddedMetaStore());
            kafkaParams.put("bootstrap.servers", this.transMeta.environmentSubstitute(namedCluster.getKafkaBootstrapServers()));
        } else {
            kafkaParams.put("bootstrap.servers", this.transMeta.environmentSubstitute(this.kafkaConsumerMeta.getDirectBootstrapServers()));
        }
        kafkaParams.put("key.deserializer", this.kafkaConsumerMeta.getKeyField().getOutputType().getKafkaDeserializerClass());
        kafkaParams.put("value.deserializer", this.kafkaConsumerMeta.getMessageField().getOutputType().getKafkaDeserializerClass());
        kafkaParams.put("group.id", this.transMeta.environmentSubstitute(this.kafkaConsumerMeta.getConsumerGroup()));
        kafkaParams.put("enable.auto.commit", true);
        List topics = this.kafkaConsumerMeta.getTopics();
        topics = topics.stream().map(arg_0 -> ((TransMeta)this.transMeta).environmentSubstitute(arg_0)).collect(Collectors.toList());
        return KafkaUtils.createDirectStream((JavaStreamingContext)this.javaStreamingContext, (LocationStrategy)LocationStrategies.PreferConsistent(), (ConsumerStrategy)ConsumerStrategies.Subscribe(topics, kafkaParams));
    }

    protected JavaRDD<Row> mapPartitions(JavaRDD javaRDD) {
        return javaRDD.mapPartitions(new KafkaToKettleRowFunction(this.consumerMeta.getParentStepMeta(), this.subscriber.getMetricsAccumulator()).asRegisteredFunction(this.consumerMeta.getParentStepMeta().getStepID()).toFlatMap());
    }
}

