/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.MergeJoinFunctions;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;
import scala.Tuple2;

public class MergeJoinSparkOperation
extends BaseSparkOperation {
    private static final Class<?> PKG = MergeJoinSparkOperation.class;
    private static final String MERGE_JOIN_EXPECTS_2_INPUTS = "MergeJoinSparkOperation.MergeJoinStepExpects2Inputs";
    private static final String CANNOT_GET_ROW_META = "MergeJoinSparkOperation.CannotGetRowMeta";
    private static final String FAILED_TO_SERIALIZE_ROW_META = "MergeJoinSparkOperation.FailedToSerializeRowMeta";
    private static final String FIRST_STEP_RDD_NOT_FOUND = "MergeJoinSparkOperation.FirstStepRDDNotFound";
    private static final String SECOND_STEP_RDD_NOT_FOUND = "MergeJoinSparkOperation.SecondStepRDDNotFound";
    private static final String JOIN_TYPE_NOT_SUPPORTED = "MergeJoinSparkOperation.JoinTypeNotSupported";
    private static final String INNER = "INNER";
    private static final String LEFT_OUTER = "LEFT OUTER";
    private static final String RIGHT_OUTER = "RIGHT OUTER";
    private static final String FULL_OUTER = "FULL OUTER";
    private final String stepID;
    private JavaSparkContext sparkContext;
    private TransMeta transMeta;
    private MergeJoinMeta meta;

    public MergeJoinSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.sparkContext = sparkContext;
        this.transMeta = MetaHelper.getTransMeta((Transformation)transformation);
        this.stepID = stepMeta.getStepID();
        this.meta = (MergeJoinMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, MergeJoinMeta.class);
    }

    public void apply(SparkOperation.Subscriber sub) {
        JavaRDD result;
        String resultRowMetaXML;
        RowMetaInterface rowMeta2;
        RowMetaInterface rowMeta1;
        Preconditions.checkArgument((sub.getInputs().size() == 2 ? 1 : 0) != 0, (Object)BaseMessages.getString(PKG, (String)MERGE_JOIN_EXPECTS_2_INPUTS, (String[])new String[0]));
        List streams = this.meta.getStepIOMeta().getInfoStreams();
        MetricsAccumulator metricsAccumulator = sub.getMetricsAccumulator();
        try {
            rowMeta1 = this.transMeta.getStepFields(((StreamInterface)streams.get(0)).getStepname());
            rowMeta2 = this.transMeta.getStepFields(((StreamInterface)streams.get(1)).getStepname());
        }
        catch (KettleStepException kse) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)CANNOT_GET_ROW_META, (String[])new String[0]));
        }
        int row1Size = rowMeta1.size();
        int row2Size = rowMeta2.size();
        RowMetaInterface resultRowMeta = rowMeta1.clone();
        resultRowMeta.addRowMeta(rowMeta2);
        try {
            resultRowMetaXML = resultRowMeta.getMetaXML();
        }
        catch (IOException e2) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)FAILED_TO_SERIALIZE_ROW_META, (String[])new String[0]));
        }
        Preconditions.checkArgument((boolean)this.keyFieldsExist(rowMeta1.getFieldNames(), this.meta.getKeyFields1()));
        Preconditions.checkArgument((boolean)this.keyFieldsExist(rowMeta2.getFieldNames(), this.meta.getKeyFields2()));
        JavaRDD input1 = sub.getInputs().entrySet().stream().filter(e -> ((SparkOperation)e.getKey()).getId().equals(((StreamInterface)streams.get(0)).getStepname())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new RuntimeException(BaseMessages.getString(PKG, (String)FIRST_STEP_RDD_NOT_FOUND, (String[])new String[0])));
        JavaRDD input2 = sub.getInputs().entrySet().stream().filter(e -> ((SparkOperation)e.getKey()).getId().equals(((StreamInterface)streams.get(1)).getStepname())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new RuntimeException(BaseMessages.getString(PKG, (String)SECOND_STEP_RDD_NOT_FOUND, (String[])new String[0])));
        JavaPairRDD pair1 = input1.mapToPair(this.getRegisteredFunc(rowMeta1.getFieldNames(), this.meta.getKeyFields1(), metricsAccumulator).toPair());
        JavaPairRDD pair2 = input2.mapToPair(this.getRegisteredFunc(rowMeta2.getFieldNames(), this.meta.getKeyFields2(), metricsAccumulator).toPair());
        switch (this.meta.getJoinType()) {
            case "INNER": {
                JavaPairRDD joined = pair1.join(pair2);
                result = joined.map((Function)new MergeJoinFunctions.InnerJoinToRddFunction(resultRowMetaXML, row1Size, row2Size, metricsAccumulator).asRegisteredFunction(this.stepID));
                break;
            }
            case "LEFT OUTER": {
                JavaPairRDD joined = pair1.leftOuterJoin(pair2);
                result = joined.map((Function)new MergeJoinFunctions.LeftOuterJoinToRddFunction(resultRowMetaXML, row1Size, row2Size, metricsAccumulator).asRegisteredFunction(this.stepID));
                break;
            }
            case "RIGHT OUTER": {
                JavaPairRDD joined = pair1.rightOuterJoin(pair2);
                result = joined.map((Function)new MergeJoinFunctions.RightOuterJoinToRddFunction(resultRowMetaXML, row1Size, row2Size, metricsAccumulator).asRegisteredFunction(this.stepID));
                break;
            }
            case "FULL OUTER": {
                JavaPairRDD joined = pair1.fullOuterJoin(pair2);
                result = joined.map((Function)new MergeJoinFunctions.FullOuterJoinToRddFunction(resultRowMetaXML, row1Size, row2Size, metricsAccumulator).asRegisteredFunction(this.stepID));
                break;
            }
            default: {
                throw new RuntimeException(BaseMessages.getString(PKG, (String)JOIN_TYPE_NOT_SUPPORTED, (String[])new String[]{this.meta.getJoinType()}));
            }
        }
        sub.setOutput(result);
    }

    private RegisteredFunction<Row, Tuple2<List<Object>, Row>> getRegisteredFunc(String[] fieldNames, String[] keyFields1, MetricsAccumulator metricsAccumulator) {
        return new RegisteredFunction(this.meta.getParentStepMeta().getStepID(), (ConfigurableFunction)new MergeJoinFunctions.ToPairRddFunction(fieldNames, keyFields1, metricsAccumulator));
    }

    private boolean keyFieldsExist(String[] fieldNames, String[] keyFields) {
        return Arrays.asList(fieldNames).containsAll(Arrays.asList(keyFields));
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(MergeJoinSparkOperation::new, new Supplier[]{MergeJoinFunctions.FullOuterJoinToRddFunction::new, MergeJoinFunctions.InnerJoinToRddFunction::new, MergeJoinFunctions.LeftOuterJoinToRddFunction::new, MergeJoinFunctions.RightOuterJoinToRddFunction::new, MergeJoinFunctions.ToPairRddFunction::new});
    }
}

