/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.orc.output.OrcOutputMetaBase;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.engine.spark.impl.typehandling.OrcSpec;
import org.pentaho.di.engine.spark.impl.typehandling.OrcTypeMapper;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class OrcOutputSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = 1L;
    private static final String ORC_COMPRESS = "orc.compress";
    private static final String ORC_COMPRESS_SIZE = "orc.compress.size";
    private static final String ORC_STRIPE_SIZE = "orc.stripe.size";
    private static final String ORC_ROW_INDEX_STRIDE = "orc.row.index.stride";
    private static final String ORC_FORMAT = "orc";
    private static final String SNAPPY_COMPRESS_OPTION = "snappy";
    private static final String ZLIB_COMPRESS_OPTION = "zlib";
    private static final String LZO_COMPRESS_OPTION = "lzo";
    private static final String UNCOMPRESSED_COMPRESS_OPTION = "uncompressed";
    private final TransMeta transMeta;
    private final OrcOutputMetaBase orcOutputMetaBase;
    private final OrcOutputMetaBase outputMeta;
    private final JavaSparkContext sparkContext;
    private final boolean isFinalOperation;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(OrcOutputSparkOperation::new, new Supplier[]{KettleToSparkRowFunction::new});
    }

    public OrcOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.orcOutputMetaBase = (OrcOutputMetaBase)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, OrcOutputMetaBase.class);
        this.outputMeta = (OrcOutputMetaBase)stepMeta.getStepMetaInterface();
        this.sparkContext = sparkContext;
        this.isFinalOperation = operation.getHopsOut() == null || operation.getHopsOut().isEmpty();
    }

    @VisibleForTesting
    protected OrcOutputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext, Map<String, Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>>> fileActionMap) {
        this(operation, null, stepMeta, sparkContext, executionContext);
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Set expectedOutputs = subscriber.getExpectedOutputs();
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        JavaRDD rdd = subscriber.getInput().map(input -> expectedOutputs.isEmpty() ? input : input.cache()).orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        expectedOutputs.forEach(output -> subscriber.addOutput(output, rdd));
        subscriber.registerDriverAction(() -> this.saveDefaultAction((JavaRDD<org.pentaho.di.engine.api.model.Row>)rdd));
    }

    @VisibleForTesting
    protected void saveDefaultAction(JavaRDD<org.pentaho.di.engine.api.model.Row> rdd) {
        try {
            Dataset<Row> rowDataset = this.convert(rdd);
            DataFrameWriter writer = rowDataset.write().format(ORC_FORMAT);
            if (this.orcOutputMetaBase.isOverrideOutput()) {
                writer.mode(SaveMode.Overwrite);
            } else {
                writer.mode(SaveMode.ErrorIfExists);
            }
            switch (OrcOutputMetaBase.CompressionType.valueOf((String)this.orcOutputMetaBase.getCompressionType().toUpperCase())) {
                case SNAPPY: {
                    writer.option(ORC_COMPRESS, SNAPPY_COMPRESS_OPTION);
                    break;
                }
                case ZLIB: {
                    writer.option(ORC_COMPRESS, ZLIB_COMPRESS_OPTION);
                    break;
                }
                case LZO: {
                    writer.option(ORC_COMPRESS, LZO_COMPRESS_OPTION);
                    break;
                }
                default: {
                    writer.option(ORC_COMPRESS, UNCOMPRESSED_COMPRESS_OPTION);
                }
            }
            writer.option(ORC_COMPRESS_SIZE, (long)this.orcOutputMetaBase.getCompressSize());
            writer.option(ORC_STRIPE_SIZE, (long)this.orcOutputMetaBase.getStripeSize());
            writer.option(ORC_ROW_INDEX_STRIDE, (long)this.orcOutputMetaBase.getRowsBetweenEntries());
            String filename = this.transMeta.environmentSubstitute(this.orcOutputMetaBase.getFilename());
            this.orcOutputMetaBase.setFilename(filename);
            writer.save(this.orcOutputMetaBase.constructOutputFilename());
            if (this.isFinalOperation) {
                FinalOperationEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID());
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
        }
    }

    private Dataset<Row> convert(JavaRDD<org.pentaho.di.engine.api.model.Row> input) {
        SparkSession.builder().enableHiveSupport();
        SparkSession spark = Util.getSparkSession();
        OrcTypeMapper typeMapper = new OrcTypeMapper(MetaHelper.getRowMeta((StepMeta)this.orcOutputMetaBase.getParentStepMeta()), this.orcOutputMetaBase.getOutputFields(), true, OrcSpec.DataType.class);
        JavaRDD sparkRDD = input.map((Function)new KettleToSparkRowFunction(this.metricsAccumulator, typeMapper).asRegisteredFunction(this.orcOutputMetaBase.getParentStepMeta().getStepID()));
        return spark.createDataFrame(sparkRDD, typeMapper.schema());
    }
}

