/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.engine.spark.impl.functions.RowToSparkDatasetConverter;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

public class SortSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = 1778585150509557393L;
    private final SortRowsMeta sortMeta;
    private final JavaSparkContext sparkContext;
    private final RowMetaInterface rowMeta;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();

    private SortSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.sortMeta = (SortRowsMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, SortRowsMeta.class);
        this.rowMeta = MetaHelper.getRowMeta((TransMeta)MetaHelper.getTransMeta((Transformation)transformation), (String)operation.getId());
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(SortSparkOperation::new, new Supplier[]{SparkToKettleRowFunction::new, KettleToSparkRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        JavaRDD input = subscriber.getInput().orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        Dataset<Row> dataFrame = RowToSparkDatasetConverter.convert((JavaRDD<org.pentaho.di.engine.api.model.Row>)input, this.rowMeta, this.sortMeta.getParentStepMeta().getStepID(), this.metricsAccumulator);
        StructType schema = dataFrame.schema();
        String[] fieldNames = this.sortMeta.getFieldName();
        boolean[] ascending = this.sortMeta.getAscending();
        boolean[] caseSensitive = this.sortMeta.getCaseSensitive();
        Column[] columns = (Column[])IntStream.range(0, fieldNames.length).mapToObj(i -> {
            DataType dataType = schema.fields()[(Integer)schema.getFieldIndex(fieldNames[i]).get()].dataType();
            Column column = functions.col((String)fieldNames[i]);
            if (DataTypes.StringType.equals(dataType)) {
                Column column2 = column = caseSensitive[i] ? column : functions.upper((Column)column);
            }
            if (!ascending[i]) {
                column = column.desc();
            }
            return column;
        }).toArray(Column[]::new);
        Dataset sortedDataFrame = dataFrame.orderBy(columns);
        JavaRDD rowJavaRDD = sortedDataFrame.toJavaRDD();
        JavaRDD output = rowJavaRDD.mapPartitions(new SparkToKettleRowFunction(this.sortMeta.getParentStepMeta(), this.metricsAccumulator).asRegisteredFunction(this.sortMeta.getParentStepMeta().getStepID()).toFlatMap());
        subscriber.setOutput(output);
    }
}

