/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.functions.StreamLookupFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;

public class StreamLookupSparkOperation
extends BaseSparkOperation {
    private static final Class<?> PKG = StreamLookupSparkOperation.class;
    private static final String NO_LKP_STEP_SPECIFIED = "StreamLookupSparkOperation.NoLookupStepSpecified";
    private final JavaSparkContext sparkContext;
    private final String infoStreamName;
    private final StepMeta stepMeta;

    public StreamLookupSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.sparkContext = sparkContext;
        this.stepMeta = stepMeta;
        StepMetaInterface streamLookupMeta = MetaHelper.getTypedStepMeta((StepMeta)stepMeta, StreamLookupMeta.class);
        if (streamLookupMeta.getStepIOMeta().getInfoStreams().get(0) == null || ((StreamInterface)streamLookupMeta.getStepIOMeta().getInfoStreams().get(0)).getStepMeta() == null) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)NO_LKP_STEP_SPECIFIED, (String[])new String[0]));
        }
        this.infoStreamName = ((StreamInterface)streamLookupMeta.getStepIOMeta().getInfoStreams().get(0)).getStepMeta().getName();
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(StreamLookupSparkOperation::new, new Supplier[]{StreamLookupFunction::new});
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        String dataStreamName;
        Map inputs = subscriber.getInputs();
        SparkOperation infoStreamOp = inputs.keySet().stream().filter(sparkOp -> this.infoStreamName.equals(sparkOp.getId())).findFirst().orElse(null);
        SparkOperation dataStreamOp = inputs.keySet().stream().filter(sparkOp -> !this.infoStreamName.equals(sparkOp.getId())).findFirst().orElse(null);
        String string = dataStreamName = dataStreamOp != null ? dataStreamOp.getId() : null;
        if (infoStreamOp != null) {
            Broadcast<List<Row>> b_infoStream = this.broadcastInfoStream((JavaRDD<Row>)((JavaRDD)inputs.get(infoStreamOp)));
            JavaRDD data = dataStreamOp != null ? (JavaRDD)inputs.get(dataStreamOp) : this.sparkContext.emptyRDD();
            subscriber.setOutput(data.mapPartitions(new StreamLookupFunction(this.stepMeta, b_infoStream, dataStreamName, subscriber.getMetricsAccumulator()).asRegisteredFunction(this.stepMeta.getStepID()).toFlatMap()));
        }
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    private Broadcast<List<Row>> broadcastInfoStream(JavaRDD<Row> infoStreamRDD) {
        List lookupData = infoStreamRDD.collect();
        return this.sparkContext.broadcast((Object)lookupData);
    }
}

