/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransExecutorSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = -4186228183586733870L;
    private final Logger LOG = LoggerFactory.getLogger(TransExecutorSparkOperation.class);
    private final TransExecutorMeta transExecutorMeta;
    private final JavaSparkContext sparkContext;
    private final SparkEngineContext sparkEngineContext;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();

    @VisibleForTesting
    protected TransExecutorSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.transExecutorMeta = (TransExecutorMeta)MetaHelper.getTypedStepMeta((StepMeta)stepMeta, TransExecutorMeta.class);
        this.sparkContext = sparkContext;
        this.sparkEngineContext = (SparkEngineContext)executionContext;
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.LOG.trace("apply(subscriber: {})", (Object)subscriber);
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        JavaRDD input = subscriber.getInput().orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        Optional<String> outputRowsStep = Optional.ofNullable(this.transExecutorMeta.getOutputRowsSourceStep());
        Optional<String> resultFilesStep = Optional.ofNullable(this.transExecutorMeta.getResultFilesTargetStep());
        Optional<String> executorsOutputStep = Optional.ofNullable(this.transExecutorMeta.getExecutorsOutputStep());
        Map<Route, List<SparkOperation>> outputGroups = subscriber.getExpectedOutputs().stream().collect(Collectors.groupingBy(sparkOperation -> {
            Optional<String> logicalId = sparkOperation.getLogicalOperation().map(ModelElement::getId);
            if (executorsOutputStep.isPresent() && logicalId.equals(executorsOutputStep)) {
                return Route.MAIN;
            }
            if (outputRowsStep.isPresent() && logicalId.equals(outputRowsStep)) {
                return Route.RESULT_ROWS;
            }
            if (resultFilesStep.isPresent() && logicalId.equals(resultFilesStep)) {
                return Route.FILES;
            }
            return Route.NONE;
        }));
        Map<Route, JavaRDD<Row>> results = this.executeSubTransformation(input, subscriber);
        JavaRDD<Row> resultRows = results.get((Object)Route.RESULT_ROWS);
        JavaRDD<Row> files = results.get((Object)Route.FILES);
        if (Stream.of(Route.values()).anyMatch(outputGroups::containsKey)) {
            outputGroups.getOrDefault((Object)Route.MAIN, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, input));
            outputGroups.getOrDefault((Object)Route.FILES, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, files));
            outputGroups.getOrDefault((Object)Route.RESULT_ROWS, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, resultRows));
            outputGroups.getOrDefault((Object)Route.NONE, (List<SparkOperation>)ImmutableList.of()).forEach(output -> subscriber.addOutput(output, this.sparkContext.emptyRDD()));
        } else {
            subscriber.setOutput(resultRows);
        }
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(TransExecutorSparkOperation::new, new Supplier[]{SparkToKettleRowFunction::new, KettleToSparkRowFunction::new});
    }

    protected Map<Route, JavaRDD<Row>> executeSubTransformation(JavaRDD javaRDD, SparkOperation.Subscriber subscriber) {
        try {
            String transformationPath;
            TransMeta transMeta = this.transExecutorMeta.getParentStepMeta().getParentTransMeta();
            if (this.transExecutorMeta.getFileName() != null) {
                transformationPath = transMeta.environmentSubstitute(this.transExecutorMeta.getFileName());
            } else {
                String transName = transMeta.environmentSubstitute(this.transExecutorMeta.getTransName());
                String directoryPath = transMeta.environmentSubstitute(this.transExecutorMeta.getDirectoryPath());
                transformationPath = directoryPath + "/" + transName;
            }
            SparkEngineContext subTransContext = this.sparkEngineContext.createSubTransContext(transformationPath);
            Map<String, Object> env = this.generateParamMapping(subTransContext);
            if (!env.isEmpty()) {
                subTransContext.setEnvironment(env);
            }
            subTransContext.setInitialRdd(javaRDD);
            subscriber.initializeContext((ExecutionContext)subTransContext, subTransContext.getTransformation());
            subTransContext.execute().get();
            JavaRDD resultRows = this.sparkContext.parallelize(((JavaRDD)subTransContext.getFinalRdd().get()).collect());
            ArrayList<KettleRow> fileList = new ArrayList<KettleRow>();
            List<String> fields = Arrays.asList(this.transExecutorMeta.getResultFilesFileNameField());
            for (String file : subTransContext.getResultFiles()) {
                fileList.add(new KettleRow(fields, new Object[]{file}));
            }
            JavaRDD files = this.sparkContext.parallelize(fileList);
            HashMap<Route, JavaRDD<Row>> result = new HashMap<Route, JavaRDD<Row>>();
            result.put(Route.RESULT_ROWS, resultRows);
            result.put(Route.FILES, files);
            return result;
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
            HashMap<Route, JavaRDD<Row>> result = new HashMap<Route, JavaRDD<Row>>();
            result.put(Route.RESULT_ROWS, this.sparkContext.emptyRDD());
            result.put(Route.FILES, this.sparkContext.emptyRDD());
            return result;
        }
    }

    @VisibleForTesting
    protected Map<String, Object> generateParamMapping(SparkEngineContext subTransContext) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        TransMeta childTransformationTranMeta = MetaHelper.getTransMeta((Transformation)subTransContext.getTransformation());
        List usedVariables = childTransformationTranMeta.getUsedVariables();
        TransMeta parentTransMeta = this.transExecutorMeta.getParentStepMeta().getParentTransMeta();
        TransExecutorParameters transExecParams = this.transExecutorMeta.getParameters();
        List<String> keys = Arrays.asList(transExecParams.getVariable());
        List<String> values = Arrays.asList(transExecParams.getInput());
        values.replaceAll(str -> {
            if (str != null) {
                return str;
            }
            return "";
        });
        Map<String, String> transExecParamMap = IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, values::get));
        for (String usedVariableName : usedVariables) {
            String varVal = null;
            try {
                if (this.transExecutorMeta.getParameters().isInheritingAllVariables()) {
                    varVal = parentTransMeta.getParameterDefault(usedVariableName);
                }
                if (varVal == null && (varVal = transExecParamMap.get(usedVariableName)) == null && (varVal = childTransformationTranMeta.getParameterDefault(usedVariableName)) == null) {
                    varVal = "";
                }
            }
            catch (UnknownParamException e) {
                OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getUUID(), (Throwable)e);
                throw new RuntimeException(e);
            }
            env.put(usedVariableName, varVal);
        }
        return env;
    }

    private static enum Route {
        MAIN,
        FILES,
        RESULT_ROWS,
        NONE;

    }
}

