/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.groupby.builder;

import java.util.List;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAelMeta;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregateField;

public class GroupBySparkSqlQueryBuilder {
    protected static final String TABLE_ALIAS = "A";
    protected static final String FORMATTING_LEADING_SPACES_SQL_FIELD = "       ";
    protected static final String FORMATTING_LEADING_SPACES_SQL_CLAUSE = "";
    protected static final String TEXT_FIELD_SEPARATOR = ", ";
    protected static final String TEXT_TABLE_ALIAS_SEPARATOR = ".";
    protected static final String TEXT_NEWLINE_CHAR = "\n";
    protected static final String TEXT_OPEN_PAREN = "(";
    protected static final String TEXT_CLOSE_PAREN = ")";
    protected static final String SQL_CLAUSE_SELECT = "SELECT";
    protected static final String SQL_CLAUSE_FROM = "FROM";
    protected static final String SQL_CLAUSE_GROUP_BY = "GROUP BY";
    protected static final String SQL_CLAUSE_ORDER_BY = "ORDER BY";
    protected static final String SQL_CLAUSE_OVER = "OVER";
    protected static final String SQL_CLAUSE_PARTITION_BY = "PARTITION BY";
    protected static final String SQL_CLAUSE_DISTINCT = "DISTINCT";
    protected static final String SQL_CLAUSE_ALL_COLUMNS = "*";
    protected static final String SQL_CLAUSE_CAST = "cast";
    protected static final String SQL_CLAUSE_AS = "AS";
    protected static final String SQL_CLAUSE_CUMULATIVE_RESULTS = "ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW";
    protected final GroupByAelMeta groupByAelMeta;
    protected final String tableName;

    private GroupBySparkSqlQueryBuilder(GroupByAelMeta groupByAelMeta, String tableName) {
        this.groupByAelMeta = groupByAelMeta;
        this.tableName = tableName;
    }

    public static GroupBySparkSqlQueryBuilder init(GroupByAelMeta groupByAelMeta, String tableName) {
        return new GroupBySparkSqlQueryBuilder(groupByAelMeta, tableName);
    }

    public String buildGroupBySparkSqlQuery() {
        StringBuilder queryStringBuilder = new StringBuilder();
        Boolean includeAllRows = this.groupByAelMeta.getShouldIncludeAllRows();
        queryStringBuilder.append((CharSequence)this.buildSelectString(includeAllRows)).append(TEXT_NEWLINE_CHAR).append((CharSequence)this.buildFromString()).append(TEXT_NEWLINE_CHAR);
        if (!includeAllRows.booleanValue() && this.groupByAelMeta.hasGroupingFields()) {
            queryStringBuilder.append((CharSequence)this.buildGroupByString(includeAllRows)).append(TEXT_NEWLINE_CHAR);
        }
        if (this.groupByAelMeta.hasGroupingFields()) {
            queryStringBuilder.append((CharSequence)this.buildOrderByString(includeAllRows));
        }
        return queryStringBuilder.toString();
    }

    protected StringBuilder buildSelectString(Boolean includeAllRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("SELECT ").append((CharSequence)this.buildGroupFieldsString(this.groupByAelMeta.getGroupingFields(), includeAllRows)).append((CharSequence)this.buildAggregateFieldsString(this.groupByAelMeta.getGroupingFields(), this.groupByAelMeta.getAggregateFields(), this.groupByAelMeta.hasGroupingFields(), includeAllRows));
        return queryStringBuilder;
    }

    protected StringBuilder buildGroupFieldsString(List<PentahoSparkField> groupingFields, Boolean includeAllRows) {
        return this.buildGroupFieldsString(groupingFields, includeAllRows, false, false);
    }

    protected StringBuilder buildGroupFieldsString(List<PentahoSparkField> groupingFields, Boolean includeAllRows, Boolean returnGroupFieldsOverride, Boolean singleLine) {
        StringBuilder queryStringBuilder = new StringBuilder();
        if (!includeAllRows.booleanValue() || returnGroupFieldsOverride.booleanValue()) {
            groupingFields.stream().findFirst().ifPresent(groupingField -> queryStringBuilder.append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_NEWLINE_CHAR).append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : FORMATTING_LEADING_SPACES_SQL_FIELD).append("A.").append(groupingField.getFieldName()));
            groupingFields.stream().skip(1L).forEach(groupingField -> queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_NEWLINE_CHAR).append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : FORMATTING_LEADING_SPACES_SQL_FIELD).append("A.").append(groupingField.getFieldName()));
        } else if (includeAllRows.booleanValue()) {
            queryStringBuilder.append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_NEWLINE_CHAR).append(singleLine != false ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : FORMATTING_LEADING_SPACES_SQL_FIELD).append("A.").append(SQL_CLAUSE_ALL_COLUMNS);
        }
        return queryStringBuilder;
    }

    protected StringBuilder buildAggregateFieldsString(List<PentahoSparkField> groupingFields, List<GroupByAggregateField> aggregateFields, Boolean hasGroupFields, Boolean includeAllRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        String groupingFieldsStringSingleLine = includeAllRows != false ? this.buildGroupFieldsString(groupingFields, includeAllRows, true, true).toString() : null;
        aggregateFields.stream().findFirst().ifPresent(aggregateField -> queryStringBuilder.append(hasGroupFields != false ? TEXT_FIELD_SEPARATOR : FORMATTING_LEADING_SPACES_SQL_CLAUSE).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append((CharSequence)this.buildAggreagteFieldExpression((GroupByAggregateField)aggregateField, groupingFieldsStringSingleLine, includeAllRows)));
        aggregateFields.stream().skip(1L).forEach(aggregateField -> queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append((CharSequence)this.buildAggreagteFieldExpression((GroupByAggregateField)aggregateField, groupingFieldsStringSingleLine, includeAllRows)));
        return queryStringBuilder;
    }

    protected StringBuilder buildAggreagteFieldExpression(GroupByAggregateField aggregateField, String groupingFieldsStringSingleLine, Boolean includeAllRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(SQL_CLAUSE_CAST).append(TEXT_OPEN_PAREN).append(" ").append(aggregateField.getAggregateType().getSqlAggFunctionName()).append(TEXT_OPEN_PAREN).append(" ");
        if (aggregateField.getAggregateType().getSqlAggFunctionNumOfParameters() > 0) {
            if (aggregateField.getAggregateType().getIsSqlAggFunctionDistinct().booleanValue()) {
                queryStringBuilder.append(SQL_CLAUSE_DISTINCT).append(" ");
            }
            if (aggregateField.getAggregateType().getDoesSqlAggOperateOnAllColumns().booleanValue()) {
                queryStringBuilder.append(SQL_CLAUSE_ALL_COLUMNS);
            } else {
                queryStringBuilder.append("A.").append(aggregateField.getSubjectField().getFieldName());
            }
            if (aggregateField.getAggregateType().getSqlAggFunctionNumOfParameters() > 1) {
                queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(" ").append(aggregateField.getAggregateType().getAggregateConfigValue(aggregateField.getAggregateFieldConfgValue()));
            }
        }
        queryStringBuilder.append(" ").append(TEXT_CLOSE_PAREN);
        if (includeAllRows.booleanValue()) {
            queryStringBuilder.append(" ").append(SQL_CLAUSE_OVER).append(" ").append(TEXT_OPEN_PAREN).append(" ").append(SQL_CLAUSE_PARTITION_BY).append(" ").append(groupingFieldsStringSingleLine).append(" ").append(SQL_CLAUSE_ORDER_BY).append(" ").append(groupingFieldsStringSingleLine);
            if (aggregateField.getAggregateType().isSqlAggFunctionCumulative().booleanValue()) {
                queryStringBuilder.append(" ").append(SQL_CLAUSE_CUMULATIVE_RESULTS);
            }
            queryStringBuilder.append(" ").append(TEXT_CLOSE_PAREN);
        }
        queryStringBuilder.append(" ").append(SQL_CLAUSE_AS).append(" ").append(aggregateField.getAggregateField().getSparkSqlDataType().typeName()).append(" ").append(TEXT_CLOSE_PAREN).append(" ").append(SQL_CLAUSE_AS).append(" ").append(aggregateField.getAggregateField().getFieldName());
        return queryStringBuilder;
    }

    protected StringBuilder buildFromString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("FROM " + this.tableName).append(" A");
        return queryStringBuilder;
    }

    protected StringBuilder buildGroupByString(Boolean includeAllRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("GROUP BY ").append((CharSequence)this.buildGroupFieldsString(this.groupByAelMeta.getGroupingFields(), includeAllRows));
        return queryStringBuilder;
    }

    protected StringBuilder buildOrderByString(Boolean includeAllRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("ORDER BY ").append((CharSequence)this.buildGroupFieldsString(this.groupByAelMeta.getGroupingFields(), includeAllRows, true, false));
        return queryStringBuilder;
    }
}

