/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.groupby.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAelMeta;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregateField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregationTypeEnum;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;

public class MemoryGroupByMetaDataMapper {
    public static GroupByAelMeta fromPdiToAelGroupByMeta(MemoryGroupByMeta groupByMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        GroupByAelMeta groupByAelMeta = new GroupByAelMeta();
        groupByAelMeta.setStepName(groupByMeta.getParentStepMeta().getName());
        groupByAelMeta.setShouldAlwaysReturnResultRow(groupByMeta.isAlwaysGivingBackOneRow());
        groupByAelMeta.setShouldAddLineNumbersToEachRow(false);
        groupByAelMeta.setShouldIncludeAllRows(false);
        groupByAelMeta.setGroupingFields(MemoryGroupByMetaDataMapper.mapGroupingFields(groupByMeta, inRowMeta));
        groupByAelMeta.setAggregateFields(MemoryGroupByMetaDataMapper.mapAggregateFields(groupByMeta, inRowMeta, outRowMeta));
        return groupByAelMeta;
    }

    protected static List<GroupByAggregateField> mapAggregateFields(MemoryGroupByMeta groupByMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        ArrayList<GroupByAggregateField> aggregateFields = new ArrayList();
        StructType inSchema = new StructTypeMapper(inRowMeta).schema();
        StructType outSchema = new StructTypeMapper(outRowMeta).schema();
        aggregateFields = IntStream.range(0, groupByMeta.getAggregateField().length).mapToObj(i -> {
            GroupByAggregateField aggregateField = new GroupByAggregateField();
            String aggregateFieldName = groupByMeta.getAggregateField()[i];
            String subjectFieldName = groupByMeta.getSubjectField()[i];
            String aggregateFieldConfigValue = groupByMeta.getValueField()[i];
            int aggregateType = groupByMeta.getAggregateType()[i];
            aggregateField.setAggregateField(MemoryGroupByMetaDataMapper.mapPentahoSparkField(aggregateFieldName, outSchema, outRowMeta));
            aggregateField.setSubjectField(MemoryGroupByMetaDataMapper.mapPentahoSparkField(subjectFieldName, inSchema, inRowMeta));
            aggregateField.setAggregateFieldConfgValue(aggregateFieldConfigValue);
            aggregateField.setAggregateType(GroupByAggregationTypeEnum.getGroupByAggregateTypeByMemoryGroupById(aggregateType));
            aggregateField = MemoryGroupByMetaDataMapper.makeTypeSpecificAggregateFieldModifications(aggregateField);
            return aggregateField;
        }).collect(Collectors.toList());
        return aggregateFields;
    }

    protected static GroupByAggregateField makeTypeSpecificAggregateFieldModifications(GroupByAggregateField aggregateField) {
        if (aggregateField.getAggregateType().equals((Object)GroupByAggregationTypeEnum.TYPE_GROUP_PERCENTILE)) {
            double percentValue;
            if (aggregateField.getAggregateFieldConfgValue() == null) {
                return aggregateField;
            }
            try {
                percentValue = Double.valueOf(aggregateField.getAggregateFieldConfgValue());
            }
            catch (NumberFormatException e) {
                return aggregateField;
            }
            if (percentValue > 1.0) {
                aggregateField.setAggregateFieldConfgValue(Double.toString(percentValue / 100.0));
            }
        }
        if (aggregateField.getAggregateType().equals((Object)GroupByAggregationTypeEnum.TYPE_GROUP_CONCAT_STRING)) {
            if (aggregateField.getAggregateFieldConfgValue() == null) {
                return aggregateField;
            }
            if (aggregateField.getAggregateFieldConfgValue().startsWith("\"") && aggregateField.getAggregateFieldConfgValue().endsWith("\"") || aggregateField.getAggregateFieldConfgValue().startsWith("'") && aggregateField.getAggregateFieldConfgValue().endsWith("'")) {
                return aggregateField;
            }
            aggregateField.setAggregateFieldConfgValue("'" + aggregateField.getAggregateFieldConfgValue() + "'");
        }
        return aggregateField;
    }

    protected static List<PentahoSparkField> mapGroupingFields(MemoryGroupByMeta groupByMeta, RowMetaInterface inRowMeta) {
        ArrayList<PentahoSparkField> groupingFields = new ArrayList();
        String[] groupFieldNames = groupByMeta.getGroupField();
        StructType schema = new StructTypeMapper(inRowMeta).schema();
        groupingFields = Arrays.stream(groupFieldNames).map(fieldName -> {
            PentahoSparkField pentahoSparkField = MemoryGroupByMetaDataMapper.mapPentahoSparkField(fieldName, schema, inRowMeta);
            return pentahoSparkField;
        }).collect(Collectors.toList());
        return groupingFields;
    }

    protected static PentahoSparkField mapPentahoSparkField(String fieldName, StructType schema, RowMetaInterface rowMeta) {
        PentahoSparkField pentahoSparkField = new PentahoSparkField();
        DataType dataType = schema.fields()[(Integer)schema.getFieldIndex(fieldName).get()].dataType();
        Column column = functions.col((String)fieldName);
        Field pentahoField = StructTypeMapper.fromField((String)fieldName, (RowMetaInterface)rowMeta);
        pentahoSparkField.setFieldName(fieldName);
        pentahoSparkField.setPentahoField(pentahoField);
        pentahoSparkField.setSparkSqlColumn(column);
        pentahoSparkField.setSparkSqlDataType(dataType);
        return pentahoSparkField;
    }
}

