/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.groupby.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAelMeta;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregateField;
import org.pentaho.di.engine.spark.impl.ops.groupby.model.GroupByAggregationTypeEnum;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;

public class GroupByAelMetaValidator {
    private static final Class<?> PKG = GroupByAelMetaValidator.class;
    private static final String VALIDATION_MESSAGE_LINE_NUMBERS_CHECK = "GroupByAelMetaValidator.LineNumbersValidtionMessage";
    private static final String VALIDATION_MESSAGE_MISSING_AGGREGATE_FIELDS = "GroupByAelMetaValidator.MissingAggregateFieldsValidationMessage";
    private static final String VALIDATION_MESSAGE_AGGREGATE_VALUE_NOT_SET = "GroupByAelMetaValidator.AggregateFieldValueNotSetValidationMessage";
    private static final String VALIDATION_MESSAGE_CUM_AGGREGATE_BUT_NOT_ALL_ROWS = "GroupByAelMetaValidator.CumulatieAggregateButNotAllRowsValidationMessage";
    private static final String VALIDATION_MESSAGE_INVALID_FIELD_NAME = "GroupByAelMetaValidator.InvalidFieldNameValidationMessage";
    private static final String FIELD_NAME_VALIDATION_REGEX = "^[a-zA-Z_][a-zA-Z0-9_]*$";
    GroupByAelMeta groupByAelMetad;
    GroupByMeta groupByMeta;
    List<String> validationErrors = new ArrayList<String>();

    private GroupByAelMetaValidator(GroupByAelMeta groupByAelMetad) {
        this.groupByAelMetad = groupByAelMetad;
        this.groupByMeta = this.groupByMeta;
    }

    public static GroupByAelMetaValidator init(GroupByAelMeta groupByAelMetad) {
        return new GroupByAelMetaValidator(groupByAelMetad);
    }

    public void validate() {
        this.validateBasicStepLevelInfo();
        this.validateGroupingFields();
        this.validateAggregateFields();
        if (this.hasValidationErrors()) {
            throw new RuntimeException(this.buildExceptionMessage());
        }
    }

    private void validateBasicStepLevelInfo() {
        if (this.groupByAelMetad.getShouldAddLineNumbersToEachRow().booleanValue() && (this.groupByAelMetad.getLineNumbersFieldName() == null || this.groupByAelMetad.getLineNumbersFieldName().trim().isEmpty())) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_LINE_NUMBERS_CHECK, (String[])new String[0]));
        }
        if (this.groupByAelMetad.getAggregateFields() == null || this.groupByAelMetad.getAggregateFields().isEmpty()) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_MISSING_AGGREGATE_FIELDS, (String[])new String[0]));
        }
    }

    private void validateGroupingFields() {
        List<PentahoSparkField> groupingFields = this.groupByAelMetad.getGroupingFields();
        groupingFields.forEach(groupingField -> this.validateGroupingField((PentahoSparkField)groupingField));
    }

    private void validateGroupingField(PentahoSparkField groupingField) {
        this.validateFieldName(groupingField.getFieldName(), "group");
    }

    private void validateAggregateFields() {
        List<GroupByAggregateField> aggregateFields = this.groupByAelMetad.getAggregateFields();
        aggregateFields.forEach(aggregateField -> this.validateAggregateField((GroupByAggregateField)aggregateField));
    }

    private void validateAggregateField(GroupByAggregateField aggregateField) {
        GroupByAggregationTypeEnum aggregateType = aggregateField.getAggregateType();
        String aggregateFieldName = aggregateField.getAggregateField().getFieldName();
        String subjectFieldName = aggregateField.getSubjectField() != null ? aggregateField.getSubjectField().getFieldName() : null;
        this.validateFieldName(aggregateFieldName, "aggregate");
        if (subjectFieldName != null) {
            this.validateFieldName(subjectFieldName, "aggregate subject");
        }
        if (aggregateType.isAggregateConfigValueRequired() && (aggregateField.getAggregateFieldConfgValue() == null || aggregateField.getAggregateFieldConfgValue().trim().isEmpty())) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_AGGREGATE_VALUE_NOT_SET, (String[])new String[]{aggregateFieldName, aggregateType.getCode()}));
        }
        if (aggregateType.isSqlAggFunctionCumulative().booleanValue() && !this.groupByAelMetad.getShouldIncludeAllRows().booleanValue()) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_CUM_AGGREGATE_BUT_NOT_ALL_ROWS, (String[])new String[]{aggregateFieldName, aggregateType.getCode()}));
        }
    }

    private void validateFieldName(String fieldName, String fieldType) {
        if (!fieldName.matches(FIELD_NAME_VALIDATION_REGEX)) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_INVALID_FIELD_NAME, (String[])new String[]{fieldType, fieldName, FIELD_NAME_VALIDATION_REGEX}));
        }
    }

    private boolean hasValidationErrors() {
        return !this.validationErrors.isEmpty();
    }

    private String buildExceptionMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  Group By Validation Errors:\n");
        for (int i = 0; i < this.validationErrors.size(); ++i) {
            String error = this.validationErrors.get(i);
            sb.append("    Validation Error ").append(++i).append(":  ").append(error).append("\n");
        }
        return sb.toString();
    }
}

