/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.groupby.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.pentaho.di.engine.spark.impl.functions.sql.functions.ConcatStringUDAggregateFunction;
import org.pentaho.di.engine.spark.impl.functions.sql.functions.FirstUDAggregateFunction;
import org.pentaho.di.engine.spark.impl.functions.sql.functions.LastValueUDAggregateFunction;

public enum GroupByAggregationTypeEnum {
    TYPE_GROUP_NONE(0, 0, "-", "-", null, 1, null, false, false, false),
    TYPE_GROUP_SUM(1, 1, "SUM", "sum", null, 1, null, false, false, false),
    TYPE_GROUP_AVERAGE(2, 2, "AVERAGE", "avg", null, 1, null, false, false, false),
    TYPE_GROUP_MEDIAN(3, 3, "MEDIAN", "percentile", null, 2, "0.5", false, false, false),
    TYPE_GROUP_PERCENTILE(4, 4, "PERCENTILE", "percentile", null, 2, null, false, false, false),
    TYPE_GROUP_MIN(5, 5, "MIN", "min", null, 1, null, false, false, false),
    TYPE_GROUP_MAX(6, 6, "MAX", "max", null, 1, null, false, false, false),
    TYPE_GROUP_COUNT_ALL(7, 7, "COUNT_ALL", "count", null, 1, null, false, false, false),
    TYPE_GROUP_CONCAT_COMMA(8, 8, "CONCAT_COMMA", "concatenateStringValues", ConcatStringUDAggregateFunction.class, 2, "', '", false, false, false),
    TYPE_GROUP_FIRST(9, 9, "FIRST", "firstValue", FirstUDAggregateFunction.class, 2, "true", false, false, false),
    TYPE_GROUP_LAST(10, 10, "LAST", "lastValue", LastValueUDAggregateFunction.class, 2, "true", false, false, false),
    TYPE_GROUP_FIRST_INCL_NULL(11, 11, "FIRST_INCL_NULL", "firstNonNullValue", FirstUDAggregateFunction.class, 2, "false", false, false, false),
    TYPE_GROUP_LAST_INCL_NULL(12, 12, "LAST_INCL_NULL", "lastNonNullValue", LastValueUDAggregateFunction.class, 2, "false", false, false, false),
    TYPE_GROUP_CUMULATIVE_SUM(13, -1, "CUM_SUM", "sum", null, 1, null, false, true, false),
    TYPE_GROUP_CUMULATIVE_AVERAGE(14, -1, "CUM_AVG", "avg", null, 1, null, false, true, false),
    TYPE_GROUP_STANDARD_DEVIATION(15, 13, "STD_DEV", "stddev", null, 1, null, false, false, false),
    TYPE_GROUP_CONCAT_STRING(16, 14, "CONCAT_STRING", "concatenateStringValues", ConcatStringUDAggregateFunction.class, 2, null, false, false, false),
    TYPE_GROUP_COUNT_DISTINCT(17, 15, "COUNT_DISTINCT", "count", null, 1, null, true, false, false),
    TYPE_GROUP_COUNT_ANY(18, 16, "COUNT_ANY", "count", null, 1, null, false, false, true),
    TYPE_GROUP_ROW_NUMBER(19, -1, "ROW_NUMBER", "row_number", null, 0, null, false, false, false);

    private final int groupById;
    private final int memoryGroupById;
    private final String code;
    private final String sqlAggFunctionName;
    private final Class sqlAggFunctionUserDefinedClass;
    private final int sqlAggFunctionNumOfParameters;
    private final String sqlAggFunction2ndParameterValue;
    private final Boolean isSqlAggFunctionDistinct;
    private final Boolean isSqlAggFunctionCumulative;
    private final Boolean doesSqlAggOperateOnAllColumns;

    private GroupByAggregationTypeEnum(int groupById, int memoryGroupById, String code, String sqlAggFunctionName, Class sqlAggFunctionUserDefinedClass, int sqlAggFunctionNumOfParameters, String sqlAggFunction2ndParameterDefaultValue, Boolean isSqlAggFunctionDistinct, Boolean isSqlAggFunctionCumulative, Boolean doesSqlAggOperateOnAllColumns) {
        this.groupById = groupById;
        this.memoryGroupById = memoryGroupById;
        this.code = code;
        this.sqlAggFunctionName = sqlAggFunctionName;
        this.sqlAggFunctionNumOfParameters = sqlAggFunctionNumOfParameters;
        this.sqlAggFunction2ndParameterValue = sqlAggFunction2ndParameterDefaultValue;
        this.doesSqlAggOperateOnAllColumns = doesSqlAggOperateOnAllColumns;
        this.isSqlAggFunctionDistinct = isSqlAggFunctionDistinct;
        this.isSqlAggFunctionCumulative = isSqlAggFunctionCumulative;
        this.sqlAggFunctionUserDefinedClass = sqlAggFunctionUserDefinedClass;
    }

    public static GroupByAggregationTypeEnum getGroupByAggregateTypeByGroupById(int typeGroupId) {
        if (typeGroupId < 0 || typeGroupId > 18) {
            return null;
        }
        for (GroupByAggregationTypeEnum groupByAggType : GroupByAggregationTypeEnum.values()) {
            if (groupByAggType.getGroupById() != typeGroupId) continue;
            return groupByAggType;
        }
        return null;
    }

    public static GroupByAggregationTypeEnum getGroupByAggregateTypeByMemoryGroupById(int typeGroupId) {
        if (typeGroupId < 0 || typeGroupId > 18) {
            return null;
        }
        for (GroupByAggregationTypeEnum groupByAggType : GroupByAggregationTypeEnum.values()) {
            if (groupByAggType.getMemoryGroupById() != typeGroupId) continue;
            return groupByAggType;
        }
        return null;
    }

    public static List<GroupByAggregationTypeEnum> getAllAggregateTypesWithCustomUdaFunction() {
        return Arrays.stream(GroupByAggregationTypeEnum.values()).filter(enumValue -> enumValue.isCustomUdaFunction()).collect(Collectors.toList());
    }

    public boolean isAggregateConfigValueRequired() {
        return this.sqlAggFunctionNumOfParameters > 1 && (this.sqlAggFunction2ndParameterValue == null || this.sqlAggFunction2ndParameterValue.isEmpty());
    }

    public String getAggregateConfigValue(String aggregateConfigValue) {
        return aggregateConfigValue != null && !aggregateConfigValue.isEmpty() ? aggregateConfigValue : this.sqlAggFunction2ndParameterValue;
    }

    public boolean isCustomUdaFunction() {
        return this.getSqlAggFunctionUserDefinedClass() != null;
    }

    public int getGroupById() {
        return this.groupById;
    }

    public String getCode() {
        return this.code;
    }

    public String getSqlAggFunctionName() {
        return this.sqlAggFunctionName;
    }

    public Boolean getIsSqlAggFunctionDistinct() {
        return this.isSqlAggFunctionDistinct;
    }

    public int getSqlAggFunctionNumOfParameters() {
        return this.sqlAggFunctionNumOfParameters;
    }

    public String getSqlAggFunction2ndParameterValue() {
        return this.sqlAggFunction2ndParameterValue;
    }

    public Boolean getDoesSqlAggOperateOnAllColumns() {
        return this.doesSqlAggOperateOnAllColumns;
    }

    public Class getSqlAggFunctionUserDefinedClass() {
        return this.sqlAggFunctionUserDefinedClass;
    }

    public Boolean isSqlAggFunctionDistinct() {
        return this.isSqlAggFunctionDistinct;
    }

    public Boolean isSqlAggFunctionCumulative() {
        return this.isSqlAggFunctionCumulative;
    }

    public int getMemoryGroupById() {
        return this.memoryGroupById;
    }
}

