/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.uniquerows;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.RowToSparkDatasetConverter;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.builder.UniqueRowsSparkSqlBuilder;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMeta;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMetaValidator;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUniqueRowsSparkOperation
extends BaseSparkOperation {
    private static final long serialVersionUID = 1778585150509557393L;
    private final Logger LOG = LoggerFactory.getLogger(BaseUniqueRowsSparkOperation.class);
    private static final String TABLE_NAME_UNIQUE_ROWS_INPUT = "uniqueRowsInput";
    private static final String TABLE_NAME_UNIQUE_ROWS_OUTPUT = "uniqueRowsOutput";
    private static final String LOG_MESSAGE_PRINT_DATAFRAME_INCOMMING_ROWS = "Unique Rows DataFrame Schema - Incomming Rows";
    private static final String LOG_MESSAGE_PRINT_DATAFRAME_OUTGOIING_ROWS = "Unique Rows DataFrame Schema - Result Outgoing Rows";
    private static final String LOG_MESSAGE_PRINT_DATAFRAME_REJECTED_ROWS = "Rejected Rows DataFrame Schema - Result Rejected Rows";
    private static final String LOG_MESSAGE_PRINT_SQL_QUERY = "Executing the following Spark SQL Query for Unique Rows transformation ";
    private static final String LOG_MESSAGE_PRINT_SQL_QUERY_REJECTED_ROWS = "Executing the following Spark SQL Query for Rejected Rows transformation ";
    protected final StepMetaInterface stepMetaInterface;
    protected final JavaSparkContext sparkContext;
    protected final Operation operation;
    protected final RowMetaInterface inRowMeta;
    protected final RowMetaInterface outRowMeta;
    protected final List<Field> inRowFields;
    protected final List<Field> outRowFields;
    protected MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();

    protected BaseUniqueRowsSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        super(operation);
        this.stepMetaInterface = stepMeta.getStepMetaInterface();
        this.inRowMeta = MetaHelper.getPrevStepFields((TransMeta)MetaHelper.getTransMeta((Transformation)transformation), (String)operation.getId());
        this.outRowMeta = MetaHelper.getRowMeta((TransMeta)MetaHelper.getTransMeta((Transformation)transformation), (String)operation.getId());
        this.inRowFields = StructTypeMapper.from((RowMetaInterface)this.inRowMeta);
        this.outRowFields = StructTypeMapper.from((RowMetaInterface)this.outRowMeta);
        this.sparkContext = sparkContext;
        this.operation = operation;
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        UniqueRowsSparkSqlBuilder sparkSqlBuilder = null;
        Object sqlQuery = null;
        Dataset<Row> inputRowsDataFrame = null;
        Dataset<Row> outputUniqueRowsDataFrame = null;
        Dataset<Row> outputRejectedRowsDataFrame = null;
        Set expectedOutputs = subscriber.getExpectedOutputs();
        Set expectedErrorOutputs = subscriber.getExpectedErrorOutputs();
        UniqueRowsAelMeta uniqueRowsAelMeta = this.mapToUniqueRowsAelMeta(this.inRowMeta, this.outRowMeta);
        UniqueRowsAelMetaValidator.init(uniqueRowsAelMeta, expectedOutputs, expectedErrorOutputs).validate();
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        inputRowsDataFrame = this.getInputRowsDataFrame(subscriber, this.metricsAccumulator);
        sparkSqlBuilder = UniqueRowsSparkSqlBuilder.init(uniqueRowsAelMeta, TABLE_NAME_UNIQUE_ROWS_INPUT, this.inRowFields, inputRowsDataFrame);
        SparkSession spark = Util.getSparkSession();
        if (uniqueRowsAelMeta.isRedirectDuplicateRow().booleanValue()) {
            outputRejectedRowsDataFrame = this.executeSqlGetDuplicateRows(spark, uniqueRowsAelMeta, sparkSqlBuilder);
            JavaRDD<org.pentaho.di.engine.api.model.Row> rejectedRowsOutput = this.getOutputJavaRddRow(outputRejectedRowsDataFrame, this.metricsAccumulator);
            subscriber.setErrorOutput(rejectedRowsOutput);
        }
        outputUniqueRowsDataFrame = this.executeSqlGetUniqueRows(spark, uniqueRowsAelMeta, sparkSqlBuilder);
        JavaRDD<org.pentaho.di.engine.api.model.Row> uniqueRowsOutput = this.getOutputJavaRddRow(outputUniqueRowsDataFrame, this.metricsAccumulator);
        subscriber.setOutput(uniqueRowsOutput);
    }

    protected Dataset<Row> getInputRowsDataFrame(SparkOperation.Subscriber subscriber, MetricsAccumulator metricsAccumulator) {
        JavaRDD inputRowsRDD = subscriber.getInput().orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        Dataset<Row> inputRowsDataFrame = RowToSparkDatasetConverter.convert((JavaRDD<org.pentaho.di.engine.api.model.Row>)inputRowsRDD, this.inRowMeta, this.stepMetaInterface.getParentStepMeta().getStepID(), metricsAccumulator);
        this.logDataFrame(inputRowsDataFrame, LOG_MESSAGE_PRINT_DATAFRAME_INCOMMING_ROWS);
        return inputRowsDataFrame;
    }

    protected Dataset<Row> executeSqlGetUniqueRows(SparkSession spark, UniqueRowsAelMeta uniqueRowsAelMeta, UniqueRowsSparkSqlBuilder sparkSqlBuilder) {
        Dataset outputUniqueRowsDataFrame = null;
        String sqlQuery = sparkSqlBuilder.buildUniqueRowsSparkSqlQuery(false);
        this.logSqlQuery(sqlQuery, "Executing the following Spark SQL Query for Unique Rows transformation '" + uniqueRowsAelMeta.getStepName() + "'");
        outputUniqueRowsDataFrame = spark.sql(sqlQuery);
        this.logDataFrame((Dataset<Row>)outputUniqueRowsDataFrame, LOG_MESSAGE_PRINT_DATAFRAME_OUTGOIING_ROWS);
        return outputUniqueRowsDataFrame;
    }

    protected Dataset<Row> executeSqlGetDuplicateRows(SparkSession spark, UniqueRowsAelMeta uniqueRowsAelMeta, UniqueRowsSparkSqlBuilder sparkSqlBuilder) {
        Dataset outputDuplicateRowsDataFrame = null;
        String sqlQuery = sparkSqlBuilder.buildUniqueRowsSparkSqlQuery(true);
        this.logSqlQuery(sqlQuery, "Executing the following Spark SQL Query for Rejected Rows transformation '" + uniqueRowsAelMeta.getStepName() + "'");
        outputDuplicateRowsDataFrame = spark.sql(sqlQuery);
        this.logDataFrame((Dataset<Row>)outputDuplicateRowsDataFrame, LOG_MESSAGE_PRINT_DATAFRAME_REJECTED_ROWS);
        return outputDuplicateRowsDataFrame;
    }

    protected JavaRDD<org.pentaho.di.engine.api.model.Row> getOutputJavaRddRow(Dataset<Row> outputRowsDataFrame, MetricsAccumulator metricsAccumulator) {
        JavaRDD outputRowsJavaRDD = outputRowsDataFrame.toJavaRDD();
        JavaRDD outputRowsOutput = outputRowsJavaRDD.mapPartitions(new SparkToKettleRowFunction(this.stepMetaInterface.getParentStepMeta(), metricsAccumulator).asRegisteredFunction(this.stepMetaInterface.getParentStepMeta().getStepID()).toFlatMap());
        return outputRowsOutput;
    }

    protected void logDataFrame(Dataset<Row> dataFrame, String message) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("DataFrames Schema - " + message + ":  ");
            dataFrame.printSchema();
            this.LOG.debug("DataFrames table - " + message + ":  ");
            dataFrame.show();
        }
    }

    protected void logSqlQuery(String sqlQuery, String message) {
        this.LOG.debug(message + "':  \n" + sqlQuery);
    }

    protected abstract UniqueRowsAelMeta mapToUniqueRowsAelMeta(RowMetaInterface var1, RowMetaInterface var2);
}

