/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.uniquerows.builder;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMeta;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsCompareField;

public class UniqueRowsSparkSqlBuilder {
    private static final String TABLE_ALIAS = "A";
    private static final String FORMATTING_LEADING_SPACES_SQL_FIELD = "       ";
    private static final String FORMATTING_LEADING_SPACES_SQL_FIELD_JOIN = "               ";
    private static final String FORMATTING_LEADING_SPACES_SQL_CLAUSE = "";
    private static final String FORMATTING_LEADING_SPACES_SQL_CLAUSE_JOIN = "           ";
    private static final String TEXT_FIELD_SEPARATOR = ", ";
    private static final String TEXT_NEWLINE_CHAR = "\n";
    private static final String TEXT_OPEN_PAREN = "(";
    private static final String TEXT_CLOSE_PAREN = ")";
    private static final String SQL_CLAUSE_SELECT = "SELECT";
    private static final String SQL_CLAUSE_FROM = "FROM";
    private static final String SQL_CLAUSE_WHERE = "WHERE";
    private static final String SQL_CLAUSE_ORDER_BY = "ORDER BY";
    private static final String SQL_CLAUSE_OVER = "OVER";
    private static final String SQL_CLAUSE_PARTITION_BY = "PARTITION BY";
    private static final String SQL_CLAUSE_ALL_COLUMNS = "*";
    private static final String SQL_CLAUSE_COUNT = "count";
    private static final String SQL_CLAUSE_ROW_NUMBER = "row_number";
    private static final String SQL_FIELD_NAME_ROW_NUMBER = "rowNumber";
    private final UniqueRowsAelMeta uniqueRowsAelMeta;
    private final String inputTableName;
    private final List<Field> inRowFields;
    private Dataset<Row> inputRowsDataFrame;
    private boolean isSqlBuilderInitialized = false;

    private UniqueRowsSparkSqlBuilder(UniqueRowsAelMeta uniqueRowsAelMeta, String inputTableName, List<Field> inRowFields, Dataset<Row> inputRowsDataFrame) {
        this.uniqueRowsAelMeta = uniqueRowsAelMeta;
        this.inputTableName = inputTableName;
        this.inRowFields = inRowFields;
        this.inputRowsDataFrame = inputRowsDataFrame;
        this.initializeSqlBuilder();
    }

    private void initializeSqlBuilder() {
        List<UniqueRowsCompareField> caseInsensitiveFields = null;
        StructType inputRowsSchema = null;
        DataType fromDataType = null;
        Column fromColumn = null;
        Column toColumn = null;
        if (this.isSqlBuilderInitialized) {
            return;
        }
        if (this.uniqueRowsAelMeta.hasIgnoreCaseFields().booleanValue()) {
            inputRowsSchema = this.inputRowsDataFrame.schema();
            caseInsensitiveFields = this.buildIgnoreCaseColumnNames();
            assert (caseInsensitiveFields != null);
            for (UniqueRowsCompareField field : caseInsensitiveFields) {
                fromColumn = functions.col((String)field.getCompareField().getFieldName());
                fromDataType = inputRowsSchema.fields()[(Integer)inputRowsSchema.getFieldIndex(field.getCompareField().getFieldName()).get()].dataType();
                toColumn = DataTypes.StringType.equals(fromDataType) ? functions.upper((Column)fromColumn) : fromColumn;
                this.inputRowsDataFrame = this.inputRowsDataFrame.withColumn(field.getFieldNameCase(), toColumn);
            }
        }
        this.inputRowsDataFrame.registerTempTable(this.inputTableName);
        this.isSqlBuilderInitialized = true;
    }

    public static UniqueRowsSparkSqlBuilder init(UniqueRowsAelMeta uniqueRowsAelMeta, String inputTableName, List<Field> inRowFields, Dataset<Row> inputRowsDataFrame) {
        return new UniqueRowsSparkSqlBuilder(uniqueRowsAelMeta, inputTableName, inRowFields, inputRowsDataFrame);
    }

    public String buildUniqueRowsSparkSqlQuery(boolean isSqlForRejectedRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append((CharSequence)this.buildSelectString(true)).append(TEXT_NEWLINE_CHAR).append(SQL_CLAUSE_FROM).append(TEXT_NEWLINE_CHAR).append((CharSequence)this.buildSubSelectString()).append(TEXT_NEWLINE_CHAR).append((CharSequence)this.buildWhereString(isSqlForRejectedRows));
        return queryStringBuilder.toString();
    }

    private StringBuilder buildSelectString(boolean isOuterSelect) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("SELECT ").append((CharSequence)this.buildAllInputFields(false));
        if (this.uniqueRowsAelMeta.isAddCounterToOputut().booleanValue()) {
            if (isOuterSelect) {
                queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append(this.uniqueRowsAelMeta.getCounterField());
            } else {
                queryStringBuilder.append((CharSequence)this.buildCounterField());
            }
        }
        if (this.uniqueRowsAelMeta.hasIgnoreCaseFields().booleanValue() && !isOuterSelect) {
            queryStringBuilder.append((CharSequence)this.buildIgnoreCaseFields());
        }
        return queryStringBuilder;
    }

    private StringBuilder buildAllInputFields(boolean singleLine) {
        StringBuilder queryStringBuilder = new StringBuilder();
        IntStream.range(0, this.inRowFields.size()).forEach(i -> {
            Field field = this.inRowFields.get(i);
            queryStringBuilder.append(i == 0 ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_FIELD_SEPARATOR).append(singleLine ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_NEWLINE_CHAR).append(singleLine ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : FORMATTING_LEADING_SPACES_SQL_FIELD_JOIN).append(field.getName());
        });
        return queryStringBuilder;
    }

    private StringBuilder buildIgnoreCaseFields() {
        StringBuilder queryStringBuilder = new StringBuilder();
        this.uniqueRowsAelMeta.getCompareFields().stream().filter(UniqueRowsCompareField::isIgnoreCase).forEach(compareField -> queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append(compareField.getFieldNameCase()));
        return queryStringBuilder;
    }

    private StringBuilder buildCounterField() {
        StringBuilder queryStringBuilder = new StringBuilder();
        StringBuilder partitionFields = this.buildPartitionFields();
        queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append(SQL_CLAUSE_COUNT).append(TEXT_OPEN_PAREN).append(SQL_CLAUSE_ALL_COLUMNS).append(TEXT_CLOSE_PAREN).append(" ").append(SQL_CLAUSE_OVER).append(" ").append(TEXT_OPEN_PAREN).append(" ").append(SQL_CLAUSE_PARTITION_BY).append(" ").append((CharSequence)partitionFields).append(" ").append(SQL_CLAUSE_ORDER_BY).append(" ").append((CharSequence)partitionFields).append(TEXT_CLOSE_PAREN).append(" ").append(this.uniqueRowsAelMeta.getCounterField());
        return queryStringBuilder;
    }

    private StringBuilder buildSubSelectString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append("( ").append(" ").append((CharSequence)this.buildSelectString(false)).append((CharSequence)this.buildRowNumberField()).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_CLAUSE_JOIN).append("FROM " + this.inputTableName).append(" ").append(TEXT_CLOSE_PAREN).append(" ").append(TABLE_ALIAS);
        return queryStringBuilder;
    }

    private StringBuilder buildRowNumberField() {
        StringBuilder queryStringBuilder = new StringBuilder();
        StringBuilder partitionFields = this.buildPartitionFields();
        queryStringBuilder.append(TEXT_FIELD_SEPARATOR).append(TEXT_NEWLINE_CHAR).append(FORMATTING_LEADING_SPACES_SQL_FIELD).append(SQL_CLAUSE_ROW_NUMBER).append(TEXT_OPEN_PAREN).append(TEXT_CLOSE_PAREN).append(" ").append(SQL_CLAUSE_OVER).append(" ").append(TEXT_OPEN_PAREN).append(" ").append(SQL_CLAUSE_PARTITION_BY).append(" ").append((CharSequence)partitionFields).append(" ").append(SQL_CLAUSE_ORDER_BY).append(" ").append((CharSequence)partitionFields).append(" ").append(TEXT_CLOSE_PAREN).append(" ").append(SQL_FIELD_NAME_ROW_NUMBER);
        return queryStringBuilder;
    }

    private StringBuilder buildPartitionFields() {
        if (this.uniqueRowsAelMeta.hasCompareFields().booleanValue()) {
            return this.buildCompareFields(true);
        }
        return this.buildAllInputFields(true);
    }

    private StringBuilder buildCompareFields(boolean singleLine) {
        StringBuilder queryStringBuilder = new StringBuilder();
        if (!this.uniqueRowsAelMeta.hasCompareFields().booleanValue()) {
            return queryStringBuilder;
        }
        IntStream.range(0, this.uniqueRowsAelMeta.getCompareFields().size()).forEach(i -> {
            UniqueRowsCompareField compareField = this.uniqueRowsAelMeta.getCompareFields().get(i);
            queryStringBuilder.append(i == 0 ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_FIELD_SEPARATOR).append(singleLine ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : TEXT_NEWLINE_CHAR).append(singleLine ? FORMATTING_LEADING_SPACES_SQL_CLAUSE : FORMATTING_LEADING_SPACES_SQL_FIELD).append(compareField.getFieldNameCase());
        });
        return queryStringBuilder;
    }

    private StringBuilder buildWhereString(boolean isSqlForRejectedRows) {
        StringBuilder queryStringBuilder = new StringBuilder();
        String rowNumberWhereExpression = null;
        rowNumberWhereExpression = !isSqlForRejectedRows ? " = 1" : " > 1";
        queryStringBuilder.append(FORMATTING_LEADING_SPACES_SQL_CLAUSE).append(SQL_CLAUSE_WHERE).append(" ").append("A.rowNumber").append(rowNumberWhereExpression);
        return queryStringBuilder;
    }

    private List<UniqueRowsCompareField> buildIgnoreCaseColumnNames() {
        if (!this.uniqueRowsAelMeta.hasIgnoreCaseFields().booleanValue()) {
            return null;
        }
        return this.uniqueRowsAelMeta.getCompareFields().stream().filter(UniqueRowsCompareField::isIgnoreCase).collect(Collectors.toList());
    }
}

