/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.uniquerows.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.PentahoSparkField;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMeta;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsCompareField;
import org.pentaho.di.engine.spark.util.StructTypeMapper;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsMeta;

public class UniqueRowsMetaDataMapper {
    public static UniqueRowsAelMeta fromPdiToAelUniqueRowsMeta(UniqueRowsMeta uniqueRowsMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        UniqueRowsAelMeta uniqueRowsAelMeta = new UniqueRowsAelMeta();
        uniqueRowsAelMeta.setStepName(uniqueRowsMeta.getParentStepMeta().getName());
        uniqueRowsAelMeta.setAddCounterToOputut(uniqueRowsMeta.isCountRows());
        uniqueRowsAelMeta.setCounterField(uniqueRowsMeta.getCountField());
        uniqueRowsAelMeta.setDuplicateRowErrorDescription(uniqueRowsMeta.getErrorDescription());
        uniqueRowsAelMeta.setRedirectDuplicateRow(uniqueRowsMeta.isRejectDuplicateRow());
        uniqueRowsAelMeta.setCompareFields(UniqueRowsMetaDataMapper.mapCompareFields(uniqueRowsAelMeta, uniqueRowsMeta, inRowMeta, outRowMeta));
        return uniqueRowsAelMeta;
    }

    protected static List<UniqueRowsCompareField> mapCompareFields(UniqueRowsAelMeta uniqueRowsAelMeta, UniqueRowsMeta uniqueRowsMeta, RowMetaInterface inRowMeta, RowMetaInterface outRowMeta) {
        ArrayList<UniqueRowsCompareField> uniqueRowsCompareFields = new ArrayList();
        StructType inSchema = new StructTypeMapper(inRowMeta).schema();
        uniqueRowsCompareFields = IntStream.range(0, uniqueRowsMeta.getCompareFields().length).mapToObj(i -> {
            UniqueRowsCompareField uniqueRowsCompareField = new UniqueRowsCompareField();
            String compareFieldName = uniqueRowsMeta.getCompareFields()[i];
            Boolean compareCaseSensitive = uniqueRowsMeta.getCaseInsensitive()[i];
            uniqueRowsCompareField.setCompareField(UniqueRowsMetaDataMapper.mapPentahoSparkField(compareFieldName, inSchema, inRowMeta));
            uniqueRowsCompareField.setIgnoreCase(compareCaseSensitive);
            if (compareCaseSensitive.booleanValue()) {
                uniqueRowsAelMeta.setHasIgnoreCaseFields(true);
            }
            return uniqueRowsCompareField;
        }).collect(Collectors.toList());
        return uniqueRowsCompareFields;
    }

    protected static PentahoSparkField mapPentahoSparkField(String fieldName, StructType schema, RowMetaInterface rowMeta) {
        PentahoSparkField pentahoSparkField = new PentahoSparkField();
        DataType dataType = schema.fields()[(Integer)schema.getFieldIndex(fieldName).get()].dataType();
        Column column = functions.col((String)fieldName);
        Field pentahoField = StructTypeMapper.fromField((String)fieldName, (RowMetaInterface)rowMeta);
        pentahoSparkField.setFieldName(fieldName);
        pentahoSparkField.setPentahoField(pentahoField);
        pentahoSparkField.setSparkSqlColumn(column);
        pentahoSparkField.setSparkSqlDataType(dataType);
        return pentahoSparkField;
    }
}

