/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops.uniquerows.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.ops.uniquerows.model.UniqueRowsAelMeta;
import org.pentaho.di.i18n.BaseMessages;

public class UniqueRowsAelMetaValidator {
    private static final Class<?> PKG = UniqueRowsAelMetaValidator.class;
    private static final String VALIDATION_MESSAGE_COUNTER_ROW_CHECK = "UniqueRowsAelMetaValidator.CounterRowValidtionMessage";
    private static final String VALIDATION_MESSAGE_REDIRECT_DUP_ROW_CHECK = "UniqueRowsAelMetaValidator.RedireceDuplicateRowValidtionMessage";
    private static final String VALIDATION_MESSAGE_INVALID_HOPS_AT_LEAST_ONE_NORMAL = "UniqueRowsAelMetaValidator.InvalidHopsDefinedAtLeastOneNormalHop";
    private static final String VALIDATION_MESSAGE_INVALID_HOPS_MORE_THANK_1_ERROR = "UniqueRowsAelMetaValidator.InvalidHopsDefinedMoreThankOneErrorHop";
    private static final String VALIDATION_MESSAGE_INVALID_HOPS_NO_REDIRECT_BUT_ERROR_HOP = "UniqueRowsAelMetaValidator.InvalidHopsDefinedNoRedirectButErrorHopFound";
    private static final String VALIDATION_MESSAGE_INVALID_HOPS_REDIRECT_BUT_NO_ERROR_HOP = "UniqueRowsAelMetaValidator.InvalidHopsDefinedRedirectButNoErrorHopFound";
    UniqueRowsAelMeta uniqueRowsAelMeta;
    Set<SparkOperation> expectedOutputs;
    Set<SparkOperation> expectedErrorOutputs;
    List<String> validationErrors = new ArrayList<String>();

    private UniqueRowsAelMetaValidator(UniqueRowsAelMeta uniqueRowsAelMeta, Set<SparkOperation> expectedOutputs, Set<SparkOperation> expectedErrorOutputs) {
        this.uniqueRowsAelMeta = uniqueRowsAelMeta;
        this.expectedOutputs = expectedOutputs;
        this.expectedErrorOutputs = expectedErrorOutputs;
    }

    public static UniqueRowsAelMetaValidator init(UniqueRowsAelMeta uniqueRowsAelMeta, Set<SparkOperation> expectedOutputs, Set<SparkOperation> expectedErrorOutputs) {
        return new UniqueRowsAelMetaValidator(uniqueRowsAelMeta, expectedOutputs, expectedErrorOutputs);
    }

    public void validate() {
        this.validateBasicStepLevelInfo();
        this.validateOutputs();
        if (this.hasValidationErrors()) {
            throw new RuntimeException(this.buildExceptionMessage());
        }
    }

    protected void validateBasicStepLevelInfo() {
        if (this.uniqueRowsAelMeta.isAddCounterToOputut().booleanValue() && (this.uniqueRowsAelMeta.getCounterField() == null || this.uniqueRowsAelMeta.getCounterField().isEmpty())) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_COUNTER_ROW_CHECK, (String[])new String[0]));
        }
        if (this.uniqueRowsAelMeta.isRedirectDuplicateRow().booleanValue() && (this.uniqueRowsAelMeta.getDuplicateRowErrorDescription() == null || this.uniqueRowsAelMeta.getDuplicateRowErrorDescription().isEmpty())) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_REDIRECT_DUP_ROW_CHECK, (String[])new String[0]));
        }
    }

    protected void validateOutputs() {
        if (this.expectedOutputs == null || this.expectedOutputs.isEmpty()) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_INVALID_HOPS_AT_LEAST_ONE_NORMAL, (String[])new String[0]));
        }
        if (this.expectedErrorOutputs != null && this.expectedErrorOutputs.size() > 1) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_INVALID_HOPS_MORE_THANK_1_ERROR, (String[])new String[0]));
        }
        if (this.uniqueRowsAelMeta.isRedirectDuplicateRow().booleanValue() && (this.expectedErrorOutputs == null || this.expectedErrorOutputs.size() != 1)) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_INVALID_HOPS_REDIRECT_BUT_NO_ERROR_HOP, (String[])new String[0]));
        }
        if (!this.uniqueRowsAelMeta.isRedirectDuplicateRow().booleanValue() && this.expectedErrorOutputs != null && !this.expectedErrorOutputs.isEmpty()) {
            this.validationErrors.add(BaseMessages.getString(PKG, (String)VALIDATION_MESSAGE_INVALID_HOPS_NO_REDIRECT_BUT_ERROR_HOP, (String[])new String[0]));
        }
    }

    private boolean hasValidationErrors() {
        return !this.validationErrors.isEmpty();
    }

    private String buildExceptionMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  Unique Rows Validation Errors:\n");
        for (int i = 0; i < this.validationErrors.size(); ++i) {
            String error = this.validationErrors.get(i);
            sb.append("    Validation Error ").append(++i).append(":  ").append(error).append("\n");
        }
        return sb.toString();
    }
}

