/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.typehandling;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import org.pentaho.di.engine.spark.api.IFormatDataType;
import org.pentaho.di.engine.spark.api.IObjectConverter;
import org.pentaho.di.engine.spark.api.SparkDataType;

public class AvroSpec {
    public static final String TYPE_RECORD = "record";
    public static final String DOC = "doc";
    public static final String FIELDS_NODE = "fields";
    public static final String NAMESPACE_NODE = "namespace";
    public static final String NAME_NODE = "name";
    public static final String TYPE_NODE = "type";
    public static final String DEFAULT_NODE = "default";
    public static final String LOGICAL_TYPE = "logicalType";

    public static enum DataType implements IFormatDataType
    {
        NULL(0, true, "null", null, "Null", 0, SparkDataType.INTEGER_TYPE.ordinal(), null),
        BOOLEAN(1, true, "boolean", null, "Boolean", 4, SparkDataType.BOOLEAN_TYPE.ordinal(), null),
        INTEGER(2, true, "int", null, "Integer", 5, SparkDataType.INTEGER_TYPE.ordinal(), (IObjectConverter & Serializable)input -> (int)((Long)input).longValue()),
        LONG(3, true, "long", null, "Long", 5, SparkDataType.LONG_TYPE.ordinal(), null),
        FLOAT(4, true, "float", null, "Float", 1, SparkDataType.FLOAT_TYPE.ordinal(), (IObjectConverter & Serializable)input -> Float.valueOf((float)((Double)input).doubleValue())),
        DOUBLE(5, true, "double", null, "Double", 1, SparkDataType.DOUBLE_TYPE.ordinal(), null),
        BYTES(6, true, "bytes", null, "Bytes", 8, SparkDataType.BINARY_TYPE.ordinal(), null),
        STRING(7, true, "string", null, "String", 2, SparkDataType.STRING_TYPE.ordinal(), null),
        RECORD(8, true, "record", null, "Record", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        ENUM(9, true, "enum", null, "Enum", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        ARRAY(10, true, "array", null, "Array", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        MAP(11, true, "map", null, "Map", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        FIXED(12, true, "fixed", null, "Fixed", 0, SparkDataType.NULL_TYPE.ordinal(), null),
        DECIMAL(13, true, "bytes", "decimal", "Decimal", 6, SparkDataType.NULL_TYPE.ordinal(), null),
        DATE(14, true, "int", "date", "Date", 3, SparkDataType.INTEGER_TYPE.ordinal(), (IObjectConverter & Serializable)input -> {
            LocalDate rowDate = input != null ? ((Date)input).toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null;
            return Math.toIntExact(ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), rowDate));
        }),
        TIME_MILLIS(15, true, "int", "time_millis", "Time", 9, SparkDataType.NULL_TYPE.ordinal(), null),
        TIME_MICROS(16, true, "long", "time_micros", "Time In Microseconds", 9, SparkDataType.NULL_TYPE.ordinal(), null),
        TIMESTAMP_MILLIS(17, true, "long", "timestamp_millis", "Timestamp", 9, SparkDataType.TIMESTAMP_TYPE.ordinal(), null),
        TIMESTAMP_MICROS(18, true, "long", "timestamp_micros", "Timestamp In Microseconds", 9, SparkDataType.NULL_TYPE.ordinal(), null),
        DURATION(19, true, "fixed", "duration", "Duration", 0, SparkDataType.NULL_TYPE.ordinal(), null);

        private final int id;
        private final boolean isPrimitiveType;
        private final String baseType;
        private final String logicalType;
        private final String name;
        private final int pdiType;
        private final int sparkSqlType;
        private final IObjectConverter sparkOutputConverter;
        private static final ArrayList<DataType> enumValues;

        private DataType(int id, boolean isPrimitiveType, String baseType, String logicalType, String name, int pdiType, int sparkSqlType, IObjectConverter sparkOutputConverter) {
            this.id = id;
            this.isPrimitiveType = isPrimitiveType;
            this.baseType = baseType;
            this.logicalType = logicalType;
            this.name = name;
            this.pdiType = pdiType;
            this.sparkSqlType = sparkSqlType;
            this.sparkOutputConverter = sparkOutputConverter;
        }

        public static DataType getDataType(int id) {
            return enumValues.get(id);
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimitiveType() {
            return this.isPrimitiveType;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getLogicalType() {
            return this.logicalType;
        }

        public String getName() {
            return this.name;
        }

        public int getPdiType() {
            return this.pdiType;
        }

        public int getSparkSqlType() {
            return this.sparkSqlType;
        }

        public IObjectConverter getSparkOutputConverter() {
            return this.sparkOutputConverter;
        }

        static {
            enumValues = new ArrayList();
            for (DataType dataType : DataType.values()) {
                enumValues.add(dataType.getId(), dataType);
            }
        }
    }
}

