/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.typehandling;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputField;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.engine.spark.api.Field;
import org.pentaho.di.engine.spark.api.FormatField;
import org.pentaho.di.engine.spark.api.IFormatDataType;
import org.pentaho.di.engine.spark.api.IFormatDataTypeProvider;
import org.pentaho.di.engine.spark.api.SparkEngineException;
import org.pentaho.di.engine.spark.impl.typehandling.AvroSpec;
import org.pentaho.di.engine.spark.impl.typehandling.FormatDataTypeProvider;
import org.pentaho.di.engine.spark.impl.typehandling.FormatStructTypeMapper;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.api.format.IFormatInputField;
import org.pentaho.hadoop.shim.api.format.IFormatOutputField;

public class AvroTypeMapper
extends FormatStructTypeMapper {
    private static final String ERROR_NO_MATCH_INPUT = "ERROR.No_Matching_Input";
    IFormatDataTypeProvider iFormatDataTypeProvider = new FormatDataTypeProvider(AvroSpec.DataType.class);

    public AvroTypeMapper(IAvroInputField[] avroInputFields, StructType schema, Class<? extends IFormatDataType> dataTypeEnumeration) {
        this.generateInputFormatFields((IFormatInputField[])avroInputFields, schema);
    }

    public AvroTypeMapper(RowMetaInterface avroInputFields, List<AvroOutputField> avroOutputFields, boolean allowNullables, Class<? extends IFormatDataType> dataTypeEnumeration) {
        List<Field> incomingPdiFields = FormatStructTypeMapper.from(avroInputFields);
        this.generateOutputFormatFields(avroOutputFields, incomingPdiFields, allowNullables);
    }

    @Override
    protected List<FormatField> generateOutputFormatFields(List<? extends IFormatOutputField> formatOutputFields, List<Field> incomingPdiFields, boolean allowSettingNullable) {
        this.formatFields = new ArrayList();
        int outputColumnOrdinal = 0;
        for (IFormatOutputField iFormatOutputField : formatOutputFields) {
            Field correspondingPdiField = incomingPdiFields.stream().filter(f -> f.getName().equals(formatOutputField.getPentahoFieldName())).findFirst().orElseThrow(() -> new SparkEngineException(AvroTypeMapper.msg(ERROR_NO_MATCH_INPUT, formatOutputField.getPentahoFieldName())));
            Field pdiField = Field.FieldBuilder.builder().field(correspondingPdiField).nullable(!allowSettingNullable).ifNull((Object)(iFormatOutputField.getDefaultValue() == null ? "" : iFormatOutputField.getDefaultValue())).build();
            IFormatDataType iFormatDataType = this.iFormatDataTypeProvider.getDataType(iFormatOutputField.getFormatType());
            Field stagingPdiField = Field.FieldBuilder.builder().name(iFormatOutputField.getPentahoFieldName()).path(iFormatOutputField.getFormatFieldName()).nullable(!allowSettingNullable).ifNull((Object)(iFormatOutputField.getDefaultValue() == null ? "" : iFormatOutputField.getDefaultValue())).type(iFormatDataType.getPdiType()).precision(iFormatOutputField.getScale()).length(iFormatOutputField.getPrecision()).dateFormat(pdiField.getDateFormat()).columnOrdinal(outputColumnOrdinal++).build();
            Field sparkField = Field.FieldBuilder.builder().name(iFormatOutputField.getFormatFieldName()).path(iFormatOutputField.getFormatFieldName()).nullable(!allowSettingNullable).ifNull((Object)iFormatOutputField.getDefaultValue()).type(iFormatDataType.getSparkSqlType()).precision(iFormatOutputField.getScale()).length(iFormatOutputField.getPrecision()).dateFormat(pdiField.getDateFormat()).columnOrdinal(stagingPdiField.getColumnOrdinal()).objectConverter(iFormatDataType.getSparkOutputConverter()).build();
            this.formatFields.add(new FormatField(pdiField, stagingPdiField, sparkField));
        }
        return this.formatFields;
    }

    private int getPdiTypeFromHackedFieldName(String hackedFieldName) {
        int startingIndex = hackedFieldName.indexOf("_delimiter_") + "_delimiter".length() + 1;
        String tmpString = hackedFieldName.substring(startingIndex);
        int endingIndex = tmpString.indexOf("_delimiter_");
        tmpString = tmpString.substring(0, endingIndex);
        return Integer.parseInt(tmpString);
    }

    public int convertToAvroType(int pdiType) {
        switch (pdiType) {
            case 2: 
            case 10: {
                return AvroSpec.DataType.STRING.getId();
            }
            case 9: {
                return AvroSpec.DataType.LONG.getId();
            }
            case 8: {
                return AvroSpec.DataType.BYTES.getId();
            }
            case 6: {
                return AvroSpec.DataType.DOUBLE.getId();
            }
            case 4: {
                return AvroSpec.DataType.BOOLEAN.getId();
            }
            case 3: {
                return AvroSpec.DataType.INTEGER.getId();
            }
            case 5: {
                return AvroSpec.DataType.LONG.getId();
            }
            case 1: {
                return AvroSpec.DataType.DOUBLE.getId();
            }
        }
        return AvroSpec.DataType.NULL.getId();
    }

    @Override
    protected List<FormatField> generateInputFormatFields(List<? extends IFormatInputField> formatInputFields, StructType schema) {
        this.formatFields = new ArrayList();
        StructField[] structFields = schema.fields();
        boolean isLegacyAvroFile = structFields.length > 0 && structFields[0].name().contains("_delimiter_");
        boolean isLegacyFieldNames = formatInputFields.size() > 0 && formatInputFields.get(0).getFormatFieldName().contains("_delimiter_");
        int inputColumnOrdinal = 0;
        for (IFormatInputField iFormatInputField : formatInputFields) {
            int avroFileOrdinal = -1;
            IntPredicate filterTest = null;
            if (isLegacyAvroFile == isLegacyFieldNames) {
                filterTest = x -> structFields[x].name().equals(field.getFormatFieldName());
            } else if (isLegacyAvroFile) {
                filterTest = x -> structFields[x].name().substring(0, structFields[x].name().indexOf("_delimiter_")).equals(field.getFormatFieldName());
            }
            avroFileOrdinal = IntStream.range(0, structFields.length).filter(filterTest).findFirst().orElseThrow(() -> new RuntimeException(AvroTypeMapper.msg(ERROR_NO_MATCH_INPUT, field.getFormatFieldName())));
            int avroType = -1;
            avroType = isLegacyAvroFile ? this.convertToAvroType(this.getPdiTypeFromHackedFieldName(structFields[avroFileOrdinal].name())) : iFormatInputField.getFormatType();
            IFormatDataType iFormatDataType = this.iFormatDataTypeProvider.getDataType(avroType);
            Field sparkField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(avroType).columnOrdinal(avroFileOrdinal).build();
            Field stagingPdiField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(iFormatDataType.getPdiType()).columnOrdinal(inputColumnOrdinal).build();
            SimpleDateFormat dateFormat = new SimpleDateFormat(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
            String stringFormat = iFormatInputField.getStringFormat();
            if (stringFormat != null && stringFormat.trim().length() > 0) {
                dateFormat = new SimpleDateFormat(stringFormat);
            }
            Field pdiField = Field.FieldBuilder.builder().path(iFormatInputField.getFormatFieldName()).name(iFormatInputField.getPentahoFieldName()).type(iFormatInputField.getPentahoType()).columnOrdinal(inputColumnOrdinal).dateFormat(dateFormat).build();
            ++inputColumnOrdinal;
            this.formatFields.add(new FormatField(pdiField, stagingPdiField, sparkField));
        }
        return this.formatFields;
    }

    public static List<Field> from(List<AvroInputField> avroInputFields) {
        List<Field> fields = avroInputFields.stream().map(field -> Field.FieldBuilder.builder().path(field.getAvroFieldName()).name(field.getPentahoFieldName()).type(field.getFormatType()).build()).collect(Collectors.toList());
        return fields;
    }

    @Override
    protected Object sparkToStaging(Object value, DataType sparkSqlType, FormatField formatField) {
        Object retVal;
        if (value == null) {
            return null;
        }
        if (this.isDate(formatField.getPdiField().getType())) {
            if (sparkSqlType == DataTypes.IntegerType) {
                LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(((Integer)value).intValue());
                return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()).getTime();
            }
            retVal = value;
        } else {
            retVal = sparkSqlType == DataTypes.StringType && formatField.getStagingField().getType() == 6 ? new BigDecimal(value.toString()) : super.sparkToStaging(value, sparkSqlType, formatField);
        }
        return retVal;
    }
}

