/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.BooleanUtils;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;

public final class MQTTClientBuilder {
    private static final Class<?> PKG = MQTTClientBuilder.class;
    private static final String UNSECURE_PROTOCOL = "tcp://";
    private static final String SECURE_PROTOCOL = "ssl://";
    private static final String SSL_PROP_PREFIX = "com.ibm.";
    public static final Map<String, String> DEFAULT_SSL_OPTS = ImmutableMap.builder().put((Object)"ssl.protocol", (Object)"TLS").put((Object)"ssl.contextProvider", (Object)"").put((Object)"ssl.keyStore", (Object)"").put((Object)"ssl.keyStorePassword", (Object)"").put((Object)"ssl.keyStoreType", (Object)"JKS").put((Object)"ssl.keyStoreProvider", (Object)"").put((Object)"ssl.trustStore", (Object)"").put((Object)"ssl.trustStorePassword", (Object)"").put((Object)"ssl.trustStoreType", (Object)"").put((Object)"ssl.trustStoreProvider", (Object)"").put((Object)"ssl.enabledCipherSuites", (Object)"").put((Object)"ssl.keyManager", (Object)"").put((Object)"ssl.trustManager", (Object)"").build();
    private String broker;
    private List<String> topics;
    private String qos = "0";
    private boolean isSecure;
    private String username;
    private String password;
    private Map<String, String> sslConfig;
    private String keepAliveInterval;
    private String maxInflight;
    private String connectionTimeout;
    private String cleanSession;
    private String storageLevel;
    private String serverUris;
    private String mqttVersion;
    private String automaticReconnect;
    private MqttCallback callback;
    private String clientId = MqttAsyncClient.generateClientId();
    private LogChannelInterface logChannel;
    private String stepName;
    @VisibleForTesting
    ClientFactory clientFactory = MqttClient::new;

    private MQTTClientBuilder() {
    }

    public static MQTTClientBuilder builder() {
        return new MQTTClientBuilder();
    }

    MQTTClientBuilder withCallback(MqttCallback callback) {
        this.callback = callback;
        return this;
    }

    public MQTTClientBuilder withBroker(String broker) {
        this.broker = broker;
        return this;
    }

    MQTTClientBuilder withTopics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    public MQTTClientBuilder withQos(String qos) {
        this.qos = qos;
        return this;
    }

    MQTTClientBuilder withIsSecure(boolean isSecure) {
        this.isSecure = isSecure;
        return this;
    }

    MQTTClientBuilder withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MQTTClientBuilder withUsername(String username) {
        this.username = username;
        return this;
    }

    public MQTTClientBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public MQTTClientBuilder withStep(StepInterface step) {
        this.logChannel = step.getLogChannel();
        this.stepName = step.getStepMeta().getName();
        return this;
    }

    MQTTClientBuilder withSslConfig(Map<String, String> sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public MQTTClientBuilder withKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    MQTTClientBuilder withMaxInflight(String maxInflight) {
        this.maxInflight = maxInflight;
        return this;
    }

    public MQTTClientBuilder withConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public MQTTClientBuilder withCleanSession(String cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    MQTTClientBuilder withStorageLevel(String storageLevel) {
        this.storageLevel = storageLevel;
        return this;
    }

    MQTTClientBuilder withServerUris(String serverUris) {
        this.serverUris = serverUris;
        return this;
    }

    public MQTTClientBuilder withMqttVersion(String mqttVersion) {
        this.mqttVersion = mqttVersion;
        return this;
    }

    public MQTTClientBuilder withAutomaticReconnect(String automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
        return this;
    }

    public MqttClient buildAndConnect() throws MqttException {
        this.validateArgs();
        String broker = this.getProtocol() + this.broker;
        MemoryPersistence persistence = new MemoryPersistence();
        if (StringUtil.isEmpty((String)this.storageLevel)) {
            this.logChannel.logDebug("Using Memory Storage Level");
        } else {
            this.logChannel.logDebug("Using File Storage Level to " + this.storageLevel);
            persistence = new MqttDefaultFilePersistence(this.storageLevel);
        }
        if (StringUtil.isEmpty((String)this.clientId)) {
            this.clientId = MqttAsyncClient.generateClientId();
        }
        MqttClient client = this.clientFactory.getClient(broker, this.clientId, (MqttClientPersistence)persistence);
        client.setCallback(this.callback);
        this.logChannel.logDebug("Subscribing to topics with a quality of service level of " + this.qos);
        this.logChannel.logDebug("Server URIs is set to " + this.serverUris);
        this.logChannel.logDebug("Max Inflight is set to " + this.maxInflight);
        this.logChannel.logDebug("Automatic Reconnect is set to " + this.automaticReconnect);
        this.logChannel.logDebug(this.loggableOptions().toString());
        client.connect(this.getOptions());
        if (this.topics != null && this.topics.size() > 0) {
            client.subscribe(this.topics.toArray(new String[this.topics.size()]), this.initializedIntAray(Integer.parseInt(this.qos)));
        }
        return client;
    }

    private String getProtocol() {
        return this.isSecure ? SECURE_PROTOCOL : UNSECURE_PROTOCOL;
    }

    private void validateArgs() {
        Preconditions.checkArgument((boolean)this.broker.matches("^[^ :/]+:\\d+"), (Object)BaseMessages.getString(PKG, (String)"MQTTInput.Error.ConnectionURL", (String[])new String[0]));
        try {
            int qosVal = Integer.parseInt(this.qos);
            Preconditions.checkArgument((qosVal >= 0 && qosVal <= 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"MQTTClientBuilder.Error.QOS", (String[])new String[]{this.stepName, this.qos}));
        }
    }

    private int[] initializedIntAray(int val) {
        return IntStream.range(0, this.topics.size()).map(i -> val).toArray();
    }

    private MqttConnectOptions getOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        if (this.isSecure) {
            this.setSSLProps(options);
        }
        if (!StringUtil.isEmpty((String)this.username)) {
            options.setUserName(this.username);
        }
        if (!StringUtil.isEmpty((String)this.password)) {
            options.setPassword(this.password.toCharArray());
        }
        if (!StringUtil.isEmpty((String)this.keepAliveInterval)) {
            options.setKeepAliveInterval(Integer.parseInt(this.keepAliveInterval));
        }
        if (!StringUtil.isEmpty((String)this.maxInflight)) {
            options.setMaxInflight(Integer.parseInt(this.maxInflight));
        }
        if (!StringUtil.isEmpty((String)this.connectionTimeout)) {
            options.setConnectionTimeout(Integer.parseInt(this.connectionTimeout));
        }
        if (!StringUtil.isEmpty((String)this.cleanSession)) {
            options.setCleanSession(BooleanUtils.toBoolean((String)this.cleanSession));
        }
        if (!StringUtil.isEmpty((String)this.serverUris)) {
            options.setServerURIs((String[])Arrays.stream(this.serverUris.split(";")).map(uri -> this.getProtocol() + uri).toArray(String[]::new));
        }
        if (!StringUtil.isEmpty((String)this.mqttVersion)) {
            options.setMqttVersion(Integer.parseInt(this.mqttVersion));
        }
        if (!StringUtil.isEmpty((String)this.automaticReconnect)) {
            options.setAutomaticReconnect(BooleanUtils.toBoolean((String)this.automaticReconnect));
        }
        return options;
    }

    private MqttConnectOptions loggableOptions() {
        MqttConnectOptions loggableOptions = this.getOptions();
        Optional.ofNullable(loggableOptions.getSSLProperties()).orElseGet(Properties::new).keySet().stream().filter(key -> key.toString().toUpperCase().contains("PASSWORD")).forEach(key -> loggableOptions.getSSLProperties().put(key, "*****"));
        return loggableOptions;
    }

    private void setSSLProps(MqttConnectOptions options) {
        Properties props = new Properties();
        props.putAll(this.sslConfig.entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getValue()))).collect(Collectors.toMap(e -> SSL_PROP_PREFIX + (String)e.getKey(), Map.Entry::getValue)));
        options.setSSLProperties(props);
    }

    public static void checkVersion(List<CheckResultInterface> remarks, StepMeta stepMeta, VariableSpace space, String value) {
        String version = space.environmentSubstitute(value);
        if (!StringUtil.isEmpty((String)version)) {
            try {
                new MqttConnectOptions().setMqttVersion(Integer.parseInt(version));
            }
            catch (Exception e) {
                remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"MQTTMeta.CheckResult.NotCorrectVersion", (String[])new String[]{BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MQTT_VERSION", (String[])new String[0]), version}), (CheckResultSourceInterface)stepMeta));
            }
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface ClientFactory {
        public MqttClient getClient(String var1, String var2, MqttClientPersistence var3) throws MqttException;
    }
}

