/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTProducerData;
import org.pentaho.di.trans.step.mqtt.MQTTProducerMeta;

public class MQTTProducer
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MQTTProducer.class;
    private MQTTProducerMeta meta;
    private MQTTProducerData data;

    public MQTTProducer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean errorsPresent;
        boolean isInitalized = super.init(stepMetaInterface, stepDataInterface);
        BaseSerializingMeta serializingMeta = (BaseSerializingMeta)stepMetaInterface;
        this.meta = (MQTTProducerMeta)serializingMeta.withVariables((VariableSpace)this);
        this.data = (MQTTProducerData)stepDataInterface;
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        this.meta.check(remarks, this.getTransMeta(), this.meta.getParentStepMeta(), null, null, null, null, this.variables, this.getRepository(), this.getMetaStore());
        boolean bl = errorsPresent = remarks.stream().filter(result -> result.getType() == 4).peek(result -> this.logError(result.getText())).count() > 0L;
        if (errorsPresent) {
            return false;
        }
        return isInitalized;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (null == row) {
            this.setOutputDone();
            this.stopMqttClient();
            return false;
        }
        if (this.first) {
            this.logDebug("Publishing using a quality of service level of " + this.environmentSubstitute(this.meta.getQOS()));
            this.data.messageFieldIndex = this.getInputRowMeta().indexOfValue(this.environmentSubstitute(this.meta.getMessageField()));
            try {
                this.data.mqttClient = MQTTClientBuilder.builder().withBroker(this.meta.getMqttServer()).withTopics(Collections.singletonList(this.meta.getTopic())).withClientId(this.meta.getClientId()).withQos(this.meta.getQOS()).withStep(this).withUsername(this.meta.getUsername()).withPassword(this.meta.getPassword()).withSslConfig(this.meta.getSslConfig()).withIsSecure(this.meta.isUseSsl()).withKeepAliveInterval(this.meta.getKeepAliveInterval()).withMaxInflight(this.meta.getMaxInflight()).withConnectionTimeout(this.meta.getConnectionTimeout()).withCleanSession(this.meta.getCleanSession()).withStorageLevel(this.meta.getStorageLevel()).withServerUris(this.meta.getServerUris()).withMqttVersion(this.meta.getMqttVersion()).withAutomaticReconnect(this.meta.getAutomaticReconnect()).buildAndConnect();
            }
            catch (Exception e) {
                this.stopAll();
                this.logError(e.toString());
                return false;
            }
            this.first = false;
        }
        MqttMessage mqttMessage = new MqttMessage();
        try {
            mqttMessage.setQos(Integer.parseInt(this.environmentSubstitute(this.meta.getQOS())));
        }
        catch (NumberFormatException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"MQTTProducer.Error.QOS", (String[])new String[]{this.environmentSubstitute(this.meta.getQOS())}));
        }
        mqttMessage.setPayload(row[this.data.messageFieldIndex].toString().getBytes(Charset.defaultCharset()));
        try {
            this.data.mqttClient.publish(this.environmentSubstitute(this.meta.getTopic()), mqttMessage);
            this.incrementLinesOutput();
            this.putRow(this.getInputRowMeta(), row);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MQTTProducer.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (MqttException e) {
            this.logError(BaseMessages.getString(PKG, (String)"MQTTProducer.Error.QOSNotSupported", (String[])new String[]{this.meta.getQOS()}));
            this.logError(e.getMessage(), e);
            this.setErrors(1L);
            this.stopAll();
        }
        return true;
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        this.stopMqttClient();
        super.stopRunning(stepMetaInterface, stepDataInterface);
    }

    private void stopMqttClient() {
        try {
            if (null != this.data.mqttClient && this.data.mqttClient.isConnected()) {
                this.data.mqttClient.disconnect();
                this.data.mqttClient.close();
            }
        }
        catch (MqttException e) {
            this.logError(e.getMessage());
        }
    }
}

