/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.generated.Hbase;

@InterfaceAudience.Private
public class HbaseHandlerMetricsProxy
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(HbaseHandlerMetricsProxy.class);
    private final Hbase.Iface handler;
    private final ThriftMetrics metrics;

    public static Hbase.Iface newInstance(Hbase.Iface handler, ThriftMetrics metrics, Configuration conf) {
        return (Hbase.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{Hbase.Iface.class}, (InvocationHandler)new HbaseHandlerMetricsProxy(handler, metrics, conf));
    }

    private HbaseHandlerMetricsProxy(Hbase.Iface handler, ThriftMetrics metrics, Configuration conf) {
        this.handler = handler;
        this.metrics = metrics;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        long start = HbaseHandlerMetricsProxy.now();
        try {
            result = m.invoke((Object)this.handler, args);
        }
        catch (InvocationTargetException e) {
            this.metrics.exception(e.getCause());
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.metrics.exception(e);
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        finally {
            long processTime = HbaseHandlerMetricsProxy.now() - start;
            this.metrics.incMethodTime(m.getName(), processTime);
        }
        return result;
    }

    private static long now() {
        return System.nanoTime();
    }
}

