/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;

public class ShuffleTran
implements SparkTran<HiveKey, BytesWritable, HiveKey, Iterable<BytesWritable>> {
    private final SparkShuffler shuffler;
    private final int numOfPartitions;
    private final boolean toCache;
    private final SparkPlan sparkPlan;
    private String name = "Shuffle";

    public ShuffleTran(SparkPlan sparkPlan, SparkShuffler sf, int n) {
        this(sparkPlan, sf, n, false);
    }

    public ShuffleTran(SparkPlan sparkPlan, SparkShuffler sf, int n, boolean toCache) {
        this.shuffler = sf;
        this.numOfPartitions = n;
        this.toCache = toCache;
        this.sparkPlan = sparkPlan;
    }

    @Override
    public JavaPairRDD<HiveKey, Iterable<BytesWritable>> transform(JavaPairRDD<HiveKey, BytesWritable> input) {
        JavaPairRDD result = this.shuffler.shuffle(input, this.numOfPartitions);
        if (this.toCache) {
            this.sparkPlan.addCachedRDDId(result.id());
            result = result.persist(StorageLevel.MEMORY_AND_DISK());
        }
        return result;
    }

    public int getNoOfPartitions() {
        return this.numOfPartitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean isCacheEnable() {
        return new Boolean(this.toCache);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public SparkShuffler getShuffler() {
        return this.shuffler;
    }
}

