/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.hive.ql.io.BucketizedHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketizedHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat");

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BucketizedHiveInputSplit hsplit = (BucketizedHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        Path splitPath = hsplit.getPath();
        URI uri = splitPath.toUri();
        try {
            URI normURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            splitPath = new Path(normURI);
        }
        catch (URISyntaxException e) {
            LOG.debug("URISyntaxException", (Throwable)e);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, splitPath.toString(), splitPath.toUri().getPath());
        InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
        BucketizedHiveRecordReader rr = new BucketizedHiveRecordReader(inputFormat, hsplit, job, reporter);
        rr.initIOContext(hsplit, job, inputFormatClass);
        return rr;
    }

    protected FileStatus[] listStatus(JobConf job, Path dir) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        FileSystem fs = dir.getFileSystem((Configuration)job);
        FileStatus[] matches = fs.globStatus(dir, FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (matches == null) {
            errors.add(new IOException("Input path does not exist: " + dir));
        } else if (matches.length == 0) {
            errors.add(new IOException("Input Pattern " + dir + " matches 0 files"));
        } else {
            for (FileStatus globStat : matches) {
                FileUtils.listStatusRecursively(fs, globStat, result);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.debug("Matches for " + dir + ": " + result);
        LOG.info("Total input paths to process : " + result.size() + " from dir " + dir);
        return result.toArray(new FileStatus[result.size()]);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.init(job);
        Path[] dirs = this.getInputPaths(job);
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<BucketizedHiveInputSplit> result = new ArrayList<BucketizedHiveInputSplit>();
        int numOrigSplits = 0;
        for (Path dir : dirs) {
            FileStatus[] listStatus;
            PartitionDesc part = BucketizedHiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            newjob.setInputFormat(inputFormat.getClass());
            for (FileStatus status : listStatus = this.listStatus(newjob, dir)) {
                LOG.info("block size: " + status.getBlockSize());
                LOG.info("file length: " + status.getLen());
                FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{status.getPath()});
                InputSplit[] iss = inputFormat.getSplits(newjob, 0);
                if (iss == null || iss.length <= 0) continue;
                numOrigSplits += iss.length;
                result.add(new BucketizedHiveInputSplit(iss, inputFormatClass.getName()));
            }
        }
        LOG.info(result.size() + " bucketized splits generated from " + numOrigSplits + " original splits.");
        return result.toArray(new BucketizedHiveInputSplit[result.size()]);
    }
}

