/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBBoxFactory;
import org.apache.lucene.geo3d.GeoBaseBBox;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoWideSouthRectangle
extends GeoBaseBBox {
    protected final double topLat;
    protected final double leftLon;
    protected final double rightLon;
    protected final double cosMiddleLat;
    protected final GeoPoint ULHC;
    protected final GeoPoint URHC;
    protected final SidedPlane topPlane;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final GeoPoint[] topPlanePoints;
    protected final GeoPoint[] leftPlanePoints;
    protected final GeoPoint[] rightPlanePoints;
    protected final GeoPoint centerPoint;
    protected final EitherBound eitherBound;
    protected final GeoPoint[] edgePoints;

    public GeoWideSouthRectangle(PlanetModel planetModel, double topLat, double leftLon, double rightLon) {
        super(planetModel);
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent < Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too small");
        }
        this.topLat = topLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.ULHC = new GeoPoint(planetModel, sinTopLat, sinLeftLon, cosTopLat, cosLeftLon, topLat, leftLon);
        this.URHC = new GeoPoint(planetModel, sinTopLat, sinRightLon, cosTopLat, cosRightLon, topLat, rightLon);
        double middleLat = (topLat - 1.5707963267948966) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.topPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinTopLat);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.topPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
        this.leftPlanePoints = new GeoPoint[]{this.ULHC, planetModel.SOUTH_POLE};
        this.rightPlanePoints = new GeoPoint[]{this.URHC, planetModel.SOUTH_POLE};
        this.eitherBound = new EitherBound();
        this.edgePoints = new GeoPoint[]{planetModel.SOUTH_POLE};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = -1.5707963267948966;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z) && (this.leftPlane.isWithin(x, y, z) || this.rightPlane.isWithin(x, y, z));
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double topAngle = this.centerPoint.arcDistance(this.URHC);
        return Math.max(centerAngle, topAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.topPlane, notablePoints, this.topPlanePoints, bounds, this.eitherBound) || p.intersects(this.planetModel, this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.topPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.topPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.isWide().addHorizontalPlane(this.planetModel, this.topLat, this.topPlane, this.eitherBound).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.topPlane).addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.topPlane).addPoint(this.ULHC).addPoint(this.URHC).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.planetModel.SOUTH_POLE);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.topPlane, this.topPlanePoints, this.eitherBound) || path.intersects(this.leftPlane, this.leftPlanePoints, this.topPlane) || path.intersects(this.rightPlane, this.rightPlanePoints, this.topPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double topDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.topPlane, x, y, z, this.eitherBound);
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.topPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.topPlane);
        double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
        double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
        return Math.min(Math.min(topDistance, Math.min(leftDistance, rightDistance)), Math.min(ULHCDistance, URHCDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWideSouthRectangle)) {
            return false;
        }
        GeoWideSouthRectangle other = (GeoWideSouthRectangle)o;
        return super.equals(o) && other.ULHC.equals(this.ULHC) && other.URHC.equals(this.URHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ULHC.hashCode();
        result = 31 * result + this.URHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoWideSouthRectangle: {planetmodel=" + this.planetModel + ", toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }

    protected class EitherBound
    implements Membership {
        @Override
        public boolean isWithin(Vector v) {
            return GeoWideSouthRectangle.this.leftPlane.isWithin(v) || GeoWideSouthRectangle.this.rightPlane.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return GeoWideSouthRectangle.this.leftPlane.isWithin(x, y, z) || GeoWideSouthRectangle.this.rightPlane.isWithin(x, y, z);
        }
    }
}

