/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.format;

import java.util.ArrayList;
import java.util.Arrays;

public class OrcSpec {
    public static final int DEFAULT_DECIMAL_PRECISION = 20;
    public static final int DEFAULT_DECIMAL_SCALE = 10;

    public static enum DataType {
        NULL(0, true, "null", null, false, "Null", 0),
        BOOLEAN(1, true, "LongColumnVector", null, true, "Boolean", 4),
        TINYINT(2, true, "LongColumnVector", null, true, "TinyInt", 5),
        SMALLINT(3, true, "LongColumnVector", null, true, "SmallInt", 5),
        INTEGER(4, true, "LongColumnVector", null, true, "Int", 5),
        BIGINT(5, true, "LongColumnVector", null, true, "BigInt", 5),
        BINARY(6, true, "BytesColumnVector", null, true, "Binary", 8),
        FLOAT(7, true, "DoubleColumnVector", null, true, "Float", 1),
        DOUBLE(8, true, "DoubleColumnVector", null, true, "Double", 1),
        DECIMAL(9, true, "DecimalColumnVector", null, true, "Decimal", 6),
        STRING(10, true, "BytesColumnVector", null, true, "String", 2),
        CHAR(11, true, "BytesColumnVector", null, true, "Char", 2),
        VARCHAR(12, true, "BytesColumnVector", null, true, "VarChar", 2),
        TIMESTAMP(13, true, "TimestampColumnVector", null, true, "Timestamp", 9),
        DATE(14, true, "LongColumnVector", null, true, "Date", 3),
        STRUCT(15, true, "StructColumnVector", null, false, "Struct", 0),
        LIST(16, true, "ListColumnVector", null, false, "List", 0),
        MAP(17, true, "MapColumnVector", null, false, "List", 0),
        UNION(18, true, "UnionColumnVector", null, false, "Union", 0);

        private final int id;
        private final boolean isPrimitive;
        private final String baseType;
        private final String logicalType;
        private final boolean displayable;
        private final String name;
        private final int pdiType;
        private static final ArrayList<DataType> enumValues;

        private DataType(int id, boolean isPrimitiveType, String baseType, String logicalType, boolean displayable, String name, int pdiType) {
            this.id = id;
            this.isPrimitive = isPrimitiveType;
            this.baseType = baseType;
            this.logicalType = logicalType;
            this.displayable = displayable;
            this.name = name;
            this.pdiType = pdiType;
        }

        public static DataType getDataType(int id) {
            return enumValues.get(id);
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        public boolean isComplexType() {
            return !this.isPrimitive && this.logicalType == null;
        }

        public boolean isLogicalType() {
            return this.logicalType != null;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getLogicalType() {
            return this.logicalType;
        }

        public String getType() {
            return this.isLogicalType() ? this.logicalType : this.baseType;
        }

        public boolean isDisplayable() {
            return this.displayable;
        }

        public String getName() {
            return this.name;
        }

        public int getPdiType() {
            return this.pdiType;
        }

        public static String[] getDisplayableTypeNames() {
            return (String[])Arrays.stream(DataType.values()).filter(DataType::isDisplayable).map(DataType::getName).sorted().toArray(String[]::new);
        }

        static {
            enumValues = new ArrayList<DataType>(){
                {
                    for (DataType dataType : DataType.values()) {
                        this.add(dataType.getId(), dataType);
                    }
                }
            };
        }
    }
}

