/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.format;

import java.util.ArrayList;
import java.util.Arrays;

public class ParquetSpec {
    public static final int DEFAULT_DECIMAL_PRECISION = 20;
    public static final int DEFAULT_DECIMAL_SCALE = 0;

    public static enum DataType {
        NULL(0, true, "null", null, false, "Null", 0),
        BINARY(1, true, "binary", null, true, "ByteArray", 8),
        BOOLEAN(2, true, "boolean", null, true, "Boolean", 4),
        DOUBLE(3, true, "double", null, true, "Double", 1),
        FLOAT(4, true, "float", null, true, "Float", 1),
        INT_32(5, true, "int32", null, true, "Int32", 5),
        FIXED_LEN_BYTE_ARRAY(6, true, "fixed_len_byte_array", null, true, "FixedLengthByteArray", 8),
        DECIMAL(7, false, "binary", null, true, "Decimal", 6),
        DECIMAL_INT_32(8, false, "int32", null, true, "Decimal", 6),
        DECIMAL_INT_64(9, false, "int64", null, true, "Decimal", 6),
        DECIMAL_FIXED_LEN_BYTE_ARRAY(10, false, "fixed_len_byte_array", null, true, "Decimal", 6),
        DATE(11, false, "int32", null, true, "Date", 3),
        ENUM(12, false, "binary", null, true, "Enum", 2),
        INT_8(13, false, "int32", null, true, "Int8", 5),
        INT_16(14, false, "int32", null, true, "Int16", 5),
        INT_64(15, false, "int64", null, true, "Int64", 5),
        INT_96(16, false, "int96", null, true, "Int96", 9),
        UINT_8(17, false, "int32", null, true, "UInt8", 5),
        UINT_16(18, false, "int32", null, true, "UInt16", 5),
        UINT_32(19, false, "int32", null, true, "UInt32", 5),
        UINT_64(20, false, "int64", null, true, "UInt64", 5),
        UTF8(21, false, "binary", null, true, "UTF8", 2),
        TIME_MILLIS(22, false, "int32", null, true, "TimeMillis", 9),
        TIMESTAMP_MILLIS(23, false, "int64", null, true, "TimestampMillis", 9),
        BSON(24, false, "binary", null, false, "BSON", 0),
        INTERVAL(25, false, "fixed_len_byte_array", null, false, "Interval", 0),
        JSON(26, false, "binary", null, false, "JSON", 0),
        LIST(27, false, "", null, false, "List", 0),
        MAP(28, false, "", null, false, "Map", 0),
        MAP_KEY_VALUE(29, false, "", null, false, "MapKeyValue", 0),
        STRUCT(30, false, "", null, false, "Struct", 0),
        UNION(31, false, "", null, false, "Union", 0);

        private final int id;
        private final boolean isPrimitive;
        private final String baseType;
        private final String logicalType;
        private final boolean displayable;
        private final String name;
        private final int pdiType;
        private static final ArrayList<DataType> enumValues;

        private DataType(int id, boolean isPrimitiveType, String baseType, String logicalType, boolean displayable, String name, int pdiType) {
            this.id = id;
            this.isPrimitive = isPrimitiveType;
            this.baseType = baseType;
            this.logicalType = logicalType;
            this.displayable = displayable;
            this.name = name;
            this.pdiType = pdiType;
        }

        public static DataType getDataType(int id) {
            return enumValues.get(id);
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        public boolean isComplexType() {
            return !this.isPrimitive && this.logicalType == null;
        }

        public boolean isLogicalType() {
            return this.logicalType != null;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getLogicalType() {
            return this.logicalType;
        }

        public String getType() {
            return this.isLogicalType() ? this.logicalType : this.baseType;
        }

        public boolean isDisplayable() {
            return this.displayable;
        }

        public String getName() {
            return this.name;
        }

        public int getPdiType() {
            return this.pdiType;
        }

        public static String[] getDisplayableTypeNames() {
            return (String[])Arrays.stream(DataType.values()).filter(DataType::isDisplayable).map(DataType::getName).sorted().toArray(String[]::new);
        }

        static {
            enumValues = new ArrayList<DataType>(){
                {
                    for (DataType dataType : DataType.values()) {
                        this.add(dataType.getId(), dataType);
                    }
                }
            };
        }
    }
}

