/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputData;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaStreamSource;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.FixedTimeStreamWindow;

public class KafkaConsumerInput
extends BaseStreamStep
implements StepInterface {
    private static Class<?> PKG = KafkaConsumerInputMeta.class;

    public KafkaConsumerInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        KafkaConsumerInputMeta kafkaConsumerInputMeta = (KafkaConsumerInputMeta)stepMetaInterface;
        KafkaConsumerInputData kafkaConsumerInputData = (KafkaConsumerInputData)stepDataInterface;
        boolean superInit = super.init((StepMetaInterface)kafkaConsumerInputMeta, (StepDataInterface)kafkaConsumerInputData);
        if (!superInit) {
            this.logError(BaseMessages.getString(PKG, (String)"KafkaConsumerInput.Error.InitFailed", (String[])new String[0]));
            return false;
        }
        try {
            kafkaConsumerInputData.outputRowMeta = kafkaConsumerInputMeta.getRowMeta(this.getStepname(), (VariableSpace)this);
        }
        catch (KettleStepException e) {
            this.log.logError(e.getMessage(), (Throwable)e);
        }
        Consumer consumer = kafkaConsumerInputMeta.getKafkaFactory().consumer(kafkaConsumerInputMeta, arg_0 -> ((KafkaConsumerInput)this).environmentSubstitute(arg_0), kafkaConsumerInputMeta.getKeyField().getOutputType(), kafkaConsumerInputMeta.getMessageField().getOutputType());
        Set topics = kafkaConsumerInputMeta.getTopics().stream().map(arg_0 -> ((KafkaConsumerInput)this).environmentSubstitute(arg_0)).collect(Collectors.toSet());
        consumer.subscribe(topics);
        this.window = new FixedTimeStreamWindow(this.subtransExecutor, kafkaConsumerInputData.outputRowMeta, this.getDuration(), this.getBatchSize());
        this.source = new KafkaStreamSource(consumer, kafkaConsumerInputMeta, kafkaConsumerInputData, this.variables, this);
        return true;
    }
}

