/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.trans;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HadoopFileInputPlugin", image="HDI.svg", name="HadoopFileInputPlugin.Name", description="HadoopFileInputPlugin.Description", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Hadoop_File_Input", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hadoopfileinput")
@InjectionSupported(localizationPrefix="HadoopFileInput.Injection.", groups={"FILENAME_LINES", "FIELDS", "FILTERS"})
public class HadoopFileInputMeta
extends TextFileInputMeta {
    private VariableSpace variableSpace;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private Map<String, String> namedClusterURLMapping = null;
    public static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    public static final String LOCAL_SOURCE_FILE = "LOCAL-SOURCE-FILE-";
    public static final String STATIC_SOURCE_FILE = "STATIC-SOURCE-FILE-";
    public static final String S3_SOURCE_FILE = "S3-SOURCE-FILE-";
    public static final String S3_DEST_FILE = "S3-DEST-FILE-";
    private final NamedClusterService namedClusterService;
    @Injection(name="ENVIRONMENT", group="FILENAME_LINES")
    public String[] environment = new String[0];

    public HadoopFileInputMeta() {
        this(null, null, null);
    }

    public HadoopFileInputMeta(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterURLMapping = new HashMap<String, String>();
    }

    protected String loadSource(Node filenode, Node filenamenode, int i, IMetaStore metaStore) {
        String source_filefolder = XMLHandler.getNodeValue((Node)filenamenode);
        Node sourceNode = XMLHandler.getSubNodeByNr((Node)filenode, (String)SOURCE_CONFIGURATION_NAME, (int)i);
        String source = XMLHandler.getNodeValue((Node)sourceNode);
        return this.loadUrl(source_filefolder, source, metaStore, this.namedClusterURLMapping);
    }

    protected void saveSource(StringBuilder retVal, String source) {
        String namedCluster = this.namedClusterURLMapping.get(source);
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)source));
        retVal.append("          ").append(XMLHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)namedCluster));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step, int i, IMetaStore metaStore) throws KettleException {
        String source_filefolder = rep.getStepAttributeString(id_step, i, "file_name");
        String ncName = rep.getJobEntryAttributeString(id_step, i, SOURCE_CONFIGURATION_NAME);
        return this.loadUrl(source_filefolder, ncName, metaStore, this.namedClusterURLMapping);
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int i, String fileName) throws KettleException {
        String namedCluster = this.namedClusterURLMapping.get(fileName);
        rep.saveStepAttribute(id_transformation, id_step, i, "file_name", fileName);
        rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_CONFIGURATION_NAME, namedCluster);
    }

    public String loadUrl(String url, String ncName, IMetaStore metastore, Map<String, String> mappings) {
        NamedCluster c = this.namedClusterService.getNamedClusterByName(ncName, metastore);
        if (c != null) {
            url = c.processURLsubstitution(url, metastore, (VariableSpace)new Variables());
        }
        if (!Utils.isEmpty((CharSequence)ncName) && !Utils.isEmpty((CharSequence)url) && mappings != null) {
            mappings.put(url, ncName);
        }
        return url;
    }

    public void setNamedClusterURLMapping(Map<String, String> mappings) {
        this.namedClusterURLMapping = mappings;
    }

    public Map<String, String> getNamedClusterURLMapping() {
        return this.namedClusterURLMapping;
    }

    public String getClusterNameBy(String url) {
        return this.namedClusterURLMapping.get(url);
    }

    public String getUrlPath(String incomingURL) {
        String path = null;
        try {
            String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
            FileName fileName = KettleVFS.getInstance().getFileSystemManager().resolveURI(noVariablesURL);
            String root = fileName.getRootURI();
            path = incomingURL.substring(root.length() - 1);
        }
        catch (FileSystemException e) {
            path = null;
        }
        return path;
    }

    public void setVariableSpace(VariableSpace variableSpace) {
        this.variableSpace = variableSpace;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public FileInputList getFileInputList(VariableSpace space) {
        this.inputFiles.normalizeAllocation(this.inputFiles.fileName.length);
        for (int i = 0; i < this.environment.length; ++i) {
            if (this.inputFiles.fileName[i].contains("://")) continue;
            String sourceNc = this.environment[i];
            sourceNc = sourceNc.equals("Local") ? LOCAL_SOURCE_FILE + i : sourceNc;
            sourceNc = sourceNc.equals("<Static>") ? STATIC_SOURCE_FILE + i : sourceNc;
            sourceNc = sourceNc.equals("S3") ? S3_SOURCE_FILE + i : sourceNc;
            String source = this.inputFiles.fileName[i];
            this.inputFiles.fileName[i] = !Const.isEmpty((String)source) ? this.loadUrl(source, sourceNc, this.getParentStepMeta().getParentTransMeta().getMetaStore(), null) : "";
        }
        return this.createFileList(space);
    }

    FileInputList createFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }
}

